/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax2.DTDInfo;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.validation.ValidationProblemHandler;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;

public final class Stax2WriterAdapter
implements XMLStreamWriter2,
XMLStreamConstants {
    final XMLStreamWriter mDelegate;
    String mEncoding;

    private Stax2WriterAdapter(XMLStreamWriter sw) {
        this.mDelegate = sw;
    }

    public static XMLStreamWriter2 wrapIfNecessary(XMLStreamWriter sw) {
        if (sw instanceof XMLStreamWriter2) {
            return (XMLStreamWriter2)sw;
        }
        return new Stax2WriterAdapter(sw);
    }

    public void close() throws XMLStreamException {
        this.mDelegate.close();
    }

    public void flush() throws XMLStreamException {
        this.mDelegate.flush();
    }

    public NamespaceContext getNamespaceContext() {
        return this.mDelegate.getNamespaceContext();
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this.mDelegate.getPrefix(uri);
    }

    public Object getProperty(String name) {
        return this.mDelegate.getProperty(name);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.mDelegate.setDefaultNamespace(uri);
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.mDelegate.setNamespaceContext(context);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.mDelegate.setPrefix(prefix, uri);
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.mDelegate.writeAttribute(localName, value);
    }

    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.mDelegate.writeAttribute(namespaceURI, localName, value);
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.mDelegate.writeAttribute(prefix, namespaceURI, localName, value);
    }

    public void writeCData(String data) throws XMLStreamException {
        this.mDelegate.writeCData(data);
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.mDelegate.writeCharacters(text, start, len);
    }

    public void writeCharacters(String text) throws XMLStreamException {
        this.mDelegate.writeCharacters(text);
    }

    public void writeComment(String data) throws XMLStreamException {
        this.mDelegate.writeComment(data);
    }

    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.mDelegate.writeDefaultNamespace(namespaceURI);
    }

    public void writeDTD(String dtd) throws XMLStreamException {
        this.mDelegate.writeDTD(dtd);
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.mDelegate.writeEmptyElement(localName);
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.mDelegate.writeEmptyElement(namespaceURI, localName);
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.mDelegate.writeEmptyElement(prefix, localName, namespaceURI);
    }

    public void writeEndDocument() throws XMLStreamException {
        this.mDelegate.writeEndDocument();
    }

    public void writeEndElement() throws XMLStreamException {
        this.mDelegate.writeEndElement();
    }

    public void writeEntityRef(String name) throws XMLStreamException {
        this.mDelegate.writeEntityRef(name);
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.mDelegate.writeNamespace(prefix, namespaceURI);
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.mDelegate.writeProcessingInstruction(target);
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.mDelegate.writeProcessingInstruction(target, data);
    }

    public void writeStartDocument() throws XMLStreamException {
        this.mDelegate.writeStartDocument();
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        this.mDelegate.writeStartDocument(version);
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.mEncoding = encoding;
        this.mDelegate.writeStartDocument(encoding, version);
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.mDelegate.writeStartElement(localName);
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.mDelegate.writeStartElement(namespaceURI, localName);
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.mDelegate.writeStartElement(prefix, localName, namespaceURI);
    }

    public boolean isPropertySupported(String name) {
        return false;
    }

    public boolean setProperty(String name, Object value) {
        throw new IllegalArgumentException("No settable property '" + name + "'");
    }

    public XMLStreamLocation2 getLocation() {
        return null;
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    public void writeCData(char[] text, int start, int len) throws XMLStreamException {
        this.writeCData(new String(text, start, len));
    }

    public void writeDTD(String rootName, String systemId, String publicId, String internalSubset) throws XMLStreamException {
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE");
        sb.append(rootName);
        if (systemId != null) {
            if (publicId != null) {
                sb.append(" PUBLIC \"");
                sb.append(publicId);
                sb.append("\" \"");
            } else {
                sb.append(" SYSTEM \"");
            }
            sb.append(systemId);
            sb.append('\"');
        }
        if (internalSubset != null && internalSubset.length() > 0) {
            sb.append(" [");
            sb.append(internalSubset);
            sb.append(']');
        }
        sb.append('>');
        this.writeDTD(sb.toString());
    }

    public void writeFullEndElement() throws XMLStreamException {
        this.mDelegate.writeCharacters("");
        this.mDelegate.writeEndElement();
    }

    public void writeSpace(String text) throws XMLStreamException {
        this.writeRaw(text);
    }

    public void writeSpace(char[] text, int offset, int length) throws XMLStreamException {
        this.writeRaw(text, offset, length);
    }

    public void writeStartDocument(String version, String encoding, boolean standAlone) throws XMLStreamException {
        this.writeStartDocument(encoding, version);
    }

    public void writeRaw(String text) throws XMLStreamException {
        this.writeRaw(text, 0, text.length());
    }

    public void writeRaw(String text, int offset, int len) throws XMLStreamException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void writeRaw(char[] text, int offset, int length) throws XMLStreamException {
        this.writeRaw(new String(text, offset, length));
    }

    public void copyEventFromReader(XMLStreamReader2 sr, boolean preserveEventData) throws XMLStreamException {
        switch (sr.getEventType()) {
            case 7: {
                String version = sr.getVersion();
                if (version != null && version.length() != 0) {
                    if (sr.standaloneSet()) {
                        this.writeStartDocument(sr.getVersion(), sr.getCharacterEncodingScheme(), sr.isStandalone());
                    } else {
                        this.writeStartDocument(sr.getCharacterEncodingScheme(), sr.getVersion());
                    }
                }
                return;
            }
            case 8: {
                this.writeEndDocument();
                return;
            }
            case 1: {
                this.copyStartElement(sr);
                return;
            }
            case 2: {
                this.writeEndElement();
                return;
            }
            case 6: {
                this.writeSpace(sr.getTextCharacters(), sr.getTextStart(), sr.getTextLength());
                return;
            }
            case 12: {
                this.writeCData(sr.getTextCharacters(), sr.getTextStart(), sr.getTextLength());
                return;
            }
            case 4: {
                this.writeCharacters(sr.getTextCharacters(), sr.getTextStart(), sr.getTextLength());
                return;
            }
            case 5: {
                this.writeComment(sr.getText());
                return;
            }
            case 3: {
                this.writeProcessingInstruction(sr.getPITarget(), sr.getPIData());
                return;
            }
            case 11: {
                DTDInfo info = sr.getDTDInfo();
                if (info == null) {
                    throw new XMLStreamException("Current state DOCTYPE, but not DTDInfo Object returned -- reader doesn't support DTDs?");
                }
                this.writeDTD(info.getDTDRootName(), info.getDTDSystemId(), info.getDTDPublicId(), info.getDTDInternalSubset());
                return;
            }
            case 9: {
                this.writeEntityRef(sr.getLocalName());
                return;
            }
        }
        throw new XMLStreamException("Unrecognized event type (" + sr.getEventType() + "); not sure how to copy");
    }

    public XMLValidator validateAgainst(XMLValidationSchema schema) throws XMLStreamException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public XMLValidator stopValidatingAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidator validator) throws XMLStreamException {
        return null;
    }

    public ValidationProblemHandler setValidationProblemHandler(ValidationProblemHandler h2) {
        return null;
    }

    protected void copyStartElement(XMLStreamReader sr) throws XMLStreamException {
        int attrCount;
        String uri;
        String prefix;
        int i;
        int nsCount = sr.getNamespaceCount();
        if (nsCount > 0) {
            for (i = 0; i < nsCount; ++i) {
                prefix = sr.getNamespacePrefix(i);
                uri = sr.getNamespaceURI(i);
                if (prefix == null || prefix.length() == 0) {
                    this.setDefaultNamespace(uri);
                    continue;
                }
                this.setPrefix(prefix, uri);
            }
        }
        this.writeStartElement(sr.getPrefix(), sr.getLocalName(), sr.getNamespaceURI());
        if (nsCount > 0) {
            for (i = 0; i < nsCount; ++i) {
                prefix = sr.getNamespacePrefix(i);
                uri = sr.getNamespaceURI(i);
                if (prefix == null || prefix.length() == 0) {
                    this.writeDefaultNamespace(uri);
                    continue;
                }
                this.writeNamespace(prefix, uri);
            }
        }
        if ((attrCount = sr.getAttributeCount()) > 0) {
            for (int i2 = 0; i2 < attrCount; ++i2) {
                this.writeAttribute(sr.getAttributePrefix(i2), sr.getAttributeNamespace(i2), sr.getAttributeLocalName(i2), sr.getAttributeValue(i2));
            }
        }
    }
}

