/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.analytics.publisher.client;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.EventHubProducerClient;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.log4j.Logger;
import org.wso2.am.analytics.publisher.auth.AuthClient;
import org.wso2.am.analytics.publisher.client.EventHubClient;
import org.wso2.am.analytics.publisher.client.WSO2TokenCredential;
import org.wso2.am.analytics.publisher.exception.ConnectionRecoverableException;
import org.wso2.am.analytics.publisher.exception.ConnectionUnrecoverableException;

public class EventHubProducerClientFactory {
    private static final Logger log = Logger.getLogger(EventHubClient.class);

    public static EventHubProducerClient create(String authEndpoint, String authToken, AmqpRetryOptions retryOptions) throws ConnectionRecoverableException, ConnectionUnrecoverableException {
        WSO2TokenCredential tokenCredential = new WSO2TokenCredential(authEndpoint, authToken);
        String tempSASToken = null;
        tempSASToken = EventHubProducerClientFactory.getSASToken(authEndpoint, authToken);
        String resourceURI = EventHubProducerClientFactory.getResourceURI(tempSASToken);
        String fullyQualifiedNamespace = EventHubProducerClientFactory.getNamespace(resourceURI);
        String eventhubName = EventHubProducerClientFactory.getEventHubName(resourceURI);
        return new EventHubClientBuilder().credential(fullyQualifiedNamespace, eventhubName, tokenCredential).retry(retryOptions).buildProducerClient();
    }

    private static String getSASToken(String authEndpoint, String authToken) throws ConnectionRecoverableException, ConnectionUnrecoverableException {
        return AuthClient.getSASToken(authEndpoint, authToken);
    }

    private static String getResourceURI(String sasToken) {
        String[] sasAttributes = sasToken.split("&");
        String[] resource = sasAttributes[0].split("=");
        String resourceURI = "";
        try {
            resourceURI = URLDecoder.decode(resource[1], "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return resourceURI.replace("sb://", "");
    }

    private static String getNamespace(String resourceURI) {
        return resourceURI.split("/")[0];
    }

    private static String getEventHubName(String resourceURI) {
        return resourceURI.split("/", 2)[1];
    }
}

