/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import org.wso2.andes.AMQException;
import org.wso2.andes.client.AMQConnection;
import org.wso2.andes.client.AMQDestination;
import org.wso2.andes.client.AMQSession;
import org.wso2.andes.client.BasicMessageProducer;
import org.wso2.andes.client.CustomJMSXProperty;
import org.wso2.andes.client.message.AMQMessageDelegate_0_8;
import org.wso2.andes.client.message.AbstractJMSMessage;
import org.wso2.andes.client.protocol.AMQProtocolHandler;
import org.wso2.andes.framing.AMQDataBlock;
import org.wso2.andes.framing.AMQFrame;
import org.wso2.andes.framing.BasicContentHeaderProperties;
import org.wso2.andes.framing.BasicPublishBody;
import org.wso2.andes.framing.CompositeAMQDataBlock;
import org.wso2.andes.framing.ContentBody;
import org.wso2.andes.framing.ContentHeaderBody;
import org.wso2.andes.framing.ExchangeDeclareBody;
import org.wso2.org.apache.mina.common.ByteBuffer;

public class BasicMessageProducer_0_8
extends BasicMessageProducer {
    BasicMessageProducer_0_8(AMQConnection connection, AMQDestination destination, boolean transacted, int channelId, AMQSession session, AMQProtocolHandler protocolHandler, long producerId, boolean immediate, boolean mandatory, boolean waitUntilSent) throws AMQException {
        super(connection, destination, transacted, channelId, session, protocolHandler, producerId, immediate, mandatory, waitUntilSent);
    }

    @Override
    void declareDestination(AMQDestination destination) {
        String exchangeName = destination.getExchangeName().toString();
        ExchangeDeclareBody body = this.getSession().getMethodRegistry().createExchangeDeclareBody(this._session.getTicket(), destination.getExchangeName(), destination.getExchangeClass(), exchangeName.startsWith("amq."), false, false, false, true, null);
        AMQFrame declare = body.generateFrame(this._channelId);
        this._protocolHandler.writeFrame(declare);
    }

    @Override
    void sendMessage(AMQDestination destination, Message origMessage, AbstractJMSMessage message, UUID messageId, int deliveryMode, int priority, long timeToLive, boolean mandatory, boolean immediate, boolean wait) throws JMSException {
        BasicPublishBody body = this.getSession().getMethodRegistry().createBasicPublishBody(this._session.getTicket(), destination.getExchangeName(), destination.getRoutingKey(), mandatory, immediate);
        AMQFrame publishFrame = body.generateFrame(this._channelId);
        message.prepareForSending();
        ByteBuffer payload = message.getData();
        AMQMessageDelegate_0_8 delegate = (AMQMessageDelegate_0_8)message.getDelegate();
        BasicContentHeaderProperties contentHeaderProperties = delegate.getContentHeaderProperties();
        contentHeaderProperties.setUserId(this._userID);
        int type = destination instanceof Topic ? 2 : (destination instanceof Queue ? 1 : 3);
        delegate.getContentHeaderProperties().getHeaders().setInteger(CustomJMSXProperty.JMS_QPID_DESTTYPE.getShortStringName(), (Integer)type);
        if (null != System.getProperty("AndesSetRoutingKey")) {
            delegate.getContentHeaderProperties().getHeaders().setString(CustomJMSXProperty.JMS_ANDES_ROUTING_KEY.getShortStringName(), destination.getRoutingKey().asString());
        }
        if (!this._disableTimestamps) {
            long currentTime = System.currentTimeMillis();
            contentHeaderProperties.setTimestamp(currentTime);
            if (timeToLive > 0L) {
                contentHeaderProperties.setExpiration(currentTime + timeToLive);
            } else {
                contentHeaderProperties.setExpiration(0L);
            }
        }
        contentHeaderProperties.setDeliveryMode((byte)deliveryMode);
        contentHeaderProperties.setPriority((byte)priority);
        int size = payload != null ? payload.limit() : 0;
        int contentBodyFrameCount = this.calculateContentBodyFrameCount(payload);
        AMQDataBlock[] frames = new AMQFrame[2 + contentBodyFrameCount];
        if (payload != null) {
            this.createContentBodies(payload, (AMQFrame[])frames, 2, this._channelId);
        }
        if (contentBodyFrameCount != 0 && this._logger.isDebugEnabled()) {
            this._logger.debug("Sending content body frames to " + destination);
        }
        int classIfForBasic = this.getSession().getMethodRegistry().createBasicQosOkBody().getClazz();
        AMQFrame contentHeaderFrame = ContentHeaderBody.createAMQFrame(this._channelId, classIfForBasic, 0, contentHeaderProperties, size);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Sending content header frame to " + destination);
        }
        frames[0] = publishFrame;
        frames[1] = contentHeaderFrame;
        CompositeAMQDataBlock compositeFrame = new CompositeAMQDataBlock(frames);
        try {
            this._session.checkFlowControl();
        }
        catch (InterruptedException e) {
            JMSException jmse = new JMSException("Interrupted while waiting for flow control to be removed");
            jmse.setLinkedException(e);
            jmse.initCause(e);
            throw jmse;
        }
        this._protocolHandler.writeFrame(compositeFrame, wait);
    }

    private void createContentBodies(ByteBuffer payload, AMQFrame[] frames, int offset, int channelId) {
        if (frames.length == offset + 1) {
            frames[offset] = ContentBody.createAMQFrame(channelId, new ContentBody(payload));
        } else {
            long framePayloadMax = this._session.getAMQConnection().getMaximumFrameSize() - 1L;
            long remaining = payload.remaining();
            for (int i = offset; i < frames.length; ++i) {
                payload.position((int)framePayloadMax * (i - offset));
                int length = remaining >= framePayloadMax ? (int)framePayloadMax : (int)remaining;
                payload.limit(payload.position() + length);
                frames[i] = ContentBody.createAMQFrame(channelId, new ContentBody(payload.slice()));
                remaining -= (long)length;
            }
        }
    }

    private int calculateContentBodyFrameCount(ByteBuffer payload) {
        int frameCount;
        if (payload == null || payload.remaining() == 0) {
            frameCount = 0;
        } else {
            long framePayloadMax;
            int dataLength = payload.remaining();
            int lastFrame = (long)dataLength % (framePayloadMax = this._session.getAMQConnection().getMaximumFrameSize() - 1L) > 0L ? 1 : 0;
            frameCount = (int)((long)dataLength / framePayloadMax) + lastFrame;
        }
        return frameCount;
    }
}

