/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.wso2.andes.client.AMQSession;

public final class ChannelToSessionMap {
    private final AMQSession[] _fastAccessSessions = new AMQSession[16];
    private final LinkedHashMap<Integer, AMQSession> _slowAccessSessions = new LinkedHashMap();
    private int _size = 0;
    private static final int FAST_CHANNEL_ACCESS_MASK = -16;
    private AtomicInteger _idFactory = new AtomicInteger(0);
    private int _maxChannelID;
    private int _minChannelID;

    public AMQSession get(int channelId) {
        if ((channelId & 0xFFFFFFF0) == 0) {
            return this._fastAccessSessions[channelId];
        }
        return this._slowAccessSessions.get(channelId);
    }

    public AMQSession put(int channelId, AMQSession session) {
        AMQSession oldVal;
        if ((channelId & 0xFFFFFFF0) == 0) {
            oldVal = this._fastAccessSessions[channelId];
            this._fastAccessSessions[channelId] = session;
        } else {
            oldVal = this._slowAccessSessions.put(channelId, session);
        }
        if (oldVal != null && session == null) {
            --this._size;
        } else if (oldVal == null && session != null) {
            ++this._size;
        }
        return session;
    }

    public AMQSession remove(int channelId) {
        AMQSession session;
        if ((channelId & 0xFFFFFFF0) == 0) {
            session = this._fastAccessSessions[channelId];
            this._fastAccessSessions[channelId] = null;
        } else {
            session = (AMQSession)this._slowAccessSessions.remove(channelId);
        }
        if (session != null) {
            --this._size;
        }
        return session;
    }

    public Collection<AMQSession> values() {
        ArrayList<AMQSession> values = new ArrayList<AMQSession>(this.size());
        for (int i = 0; i < 16; ++i) {
            if (this._fastAccessSessions[i] == null) continue;
            values.add(this._fastAccessSessions[i]);
        }
        values.addAll(this._slowAccessSessions.values());
        return values;
    }

    public int size() {
        return this._size;
    }

    public void clear() {
        this._size = 0;
        this._slowAccessSessions.clear();
        for (int i = 0; i < 16; ++i) {
            this._fastAccessSessions[i] = null;
        }
    }

    public synchronized int getNextChannelId() {
        int id = this._minChannelID;
        boolean done = false;
        while (!done) {
            id = this._idFactory.getAndIncrement();
            if (id == this._maxChannelID) {
                this._idFactory.set(this._minChannelID);
            }
            if ((id & 0xFFFFFFF0) == 0) {
                done = this._fastAccessSessions[id] == null;
                continue;
            }
            done = !this._slowAccessSessions.keySet().contains(id);
        }
        return id;
    }

    public void setMaxChannelID(int maxChannelID) {
        this._maxChannelID = maxChannelID;
    }

    public void setMinChannelID(int minChannelID) {
        this._minChannelID = minChannelID;
        this._idFactory.set(this._minChannelID);
    }
}

