/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.wso2.andes.client.message.AbstractJMSMessage;

public class DelayedObject
implements Delayed {
    private final long startTime;
    private final Object objectElement;

    public DelayedObject(long deliveryDelay, Object objectElement) {
        this.startTime = System.currentTimeMillis() + deliveryDelay;
        this.objectElement = objectElement;
    }

    public Object getObject() {
        return this.objectElement;
    }

    @Override
    public long getDelay(TimeUnit timeUnit) {
        long diff = this.startTime - System.currentTimeMillis();
        return timeUnit.convert(diff, TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed delayedObject) {
        int compareToValue = Long.compare(this.startTime, ((DelayedObject)delayedObject).startTime);
        DelayedObject compareToDelayedObject = (DelayedObject)delayedObject;
        Object compareToObject = compareToDelayedObject.getObject();
        if (0 == compareToValue && this.objectElement instanceof AbstractJMSMessage && compareToObject instanceof AbstractJMSMessage) {
            AbstractJMSMessage currentAbstractJMSMessage = (AbstractJMSMessage)this.objectElement;
            AbstractJMSMessage compareToAbstractJMSMessage = (AbstractJMSMessage)compareToObject;
            compareToValue = Long.compare(currentAbstractJMSMessage.getDeliveryTag(), compareToAbstractJMSMessage.getDeliveryTag());
        }
        return compareToValue;
    }
}

