/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import org.wso2.andes.client.AMQSession;
import org.wso2.andes.client.BasicMessageConsumer;

public class QueueReceiverAdaptor
implements QueueReceiver {
    protected MessageConsumer _consumer;
    protected Queue _queue;

    protected QueueReceiverAdaptor(Queue queue, MessageConsumer consumer) {
        this._consumer = consumer;
        this._queue = queue;
    }

    @Override
    public String getMessageSelector() throws JMSException {
        this.checkPreConditions();
        return this._consumer.getMessageSelector();
    }

    @Override
    public MessageListener getMessageListener() throws JMSException {
        this.checkPreConditions();
        return this._consumer.getMessageListener();
    }

    @Override
    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkPreConditions();
        this._consumer.setMessageListener(messageListener);
    }

    @Override
    public Message receive() throws JMSException {
        this.checkPreConditions();
        return this._consumer.receive();
    }

    @Override
    public Message receive(long l) throws JMSException {
        this.checkPreConditions();
        return this._consumer.receive(l);
    }

    @Override
    public Message receiveNoWait() throws JMSException {
        this.checkPreConditions();
        return this._consumer.receiveNoWait();
    }

    @Override
    public void close() throws JMSException {
        this._consumer.close();
    }

    @Override
    public Queue getQueue() throws JMSException {
        this.checkPreConditions();
        return this._queue;
    }

    private void checkPreConditions() throws IllegalStateException {
        BasicMessageConsumer msgConsumer = (BasicMessageConsumer)this._consumer;
        if (msgConsumer.isClosed()) {
            throw new IllegalStateException("Consumer is closed");
        }
        if (this._queue == null) {
            throw new UnsupportedOperationException("Queue is null");
        }
        AMQSession session = msgConsumer.getSession();
        if (session == null || session.isClosed()) {
            throw new IllegalStateException("Invalid Session");
        }
    }
}

