/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;
import org.wso2.andes.client.AMQDestination;
import org.wso2.andes.client.AMQSession;
import org.wso2.andes.client.BasicMessageProducer;

public class QueueSenderAdapter
implements QueueSender {
    private BasicMessageProducer _delegate;
    private Queue _queue;
    private boolean closed = false;
    private boolean verifyQueueBindingBeforePublish;

    public QueueSenderAdapter(BasicMessageProducer msgProducer, Queue queue) {
        this._delegate = msgProducer;
        this._queue = queue;
        this.verifyQueueBindingBeforePublish = Boolean.parseBoolean(System.getProperty("org.wso2.andes.client.verifyQueueBindingBeforePublish", "true"));
    }

    @Override
    public Queue getQueue() throws JMSException {
        this.checkPreConditions();
        return this._queue;
    }

    @Override
    public void send(Message msg) throws JMSException {
        this.checkQueuePreConditions(this._queue);
        this._delegate.send(msg);
    }

    @Override
    public void send(Queue queue, Message msg) throws JMSException {
        this.checkQueuePreConditions(queue);
        this._delegate.send(queue, msg);
    }

    public void publish(Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkQueuePreConditions(this._queue);
        this._delegate.send(msg, deliveryMode, priority, timeToLive);
    }

    @Override
    public void send(Queue queue, Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkQueuePreConditions(queue);
        this._delegate.send(queue, msg, deliveryMode, priority, timeToLive);
    }

    @Override
    public void close() throws JMSException {
        this._delegate.close();
        this.closed = true;
    }

    @Override
    public int getDeliveryMode() throws JMSException {
        this.checkPreConditions();
        return this._delegate.getDeliveryMode();
    }

    @Override
    public Destination getDestination() throws JMSException {
        this.checkPreConditions();
        return this._delegate.getDestination();
    }

    @Override
    public boolean getDisableMessageID() throws JMSException {
        this.checkPreConditions();
        return this._delegate.getDisableMessageID();
    }

    @Override
    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkPreConditions();
        return this._delegate.getDisableMessageTimestamp();
    }

    @Override
    public int getPriority() throws JMSException {
        this.checkPreConditions();
        return this._delegate.getPriority();
    }

    @Override
    public long getTimeToLive() throws JMSException {
        this.checkPreConditions();
        return this._delegate.getTimeToLive();
    }

    @Override
    public void send(Destination dest, Message msg) throws JMSException {
        this.checkQueuePreConditions((Queue)dest);
        this._delegate.send(dest, msg);
    }

    @Override
    public void send(Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkQueuePreConditions(this._queue);
        this._delegate.send(msg, deliveryMode, priority, timeToLive);
    }

    @Override
    public void send(Destination dest, Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkQueuePreConditions((Queue)dest);
        this._delegate.send(dest, msg, deliveryMode, priority, timeToLive);
    }

    @Override
    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkPreConditions();
        this._delegate.setDeliveryMode(deliveryMode);
    }

    @Override
    public void setDisableMessageID(boolean disableMessageID) throws JMSException {
        this.checkPreConditions();
        this._delegate.setDisableMessageID(disableMessageID);
    }

    @Override
    public void setDisableMessageTimestamp(boolean disableMessageTimestamp) throws JMSException {
        this.checkPreConditions();
        this._delegate.setDisableMessageTimestamp(disableMessageTimestamp);
    }

    @Override
    public void setPriority(int priority) throws JMSException {
        this.checkPreConditions();
        this._delegate.setPriority(priority);
    }

    @Override
    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkPreConditions();
        this._delegate.setTimeToLive(timeToLive);
    }

    private void checkPreConditions() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Publisher is closed");
        }
        AMQSession session = this._delegate.getSession();
        if (session == null || session.isClosed()) {
            throw new IllegalStateException("Invalid Session");
        }
    }

    private void checkQueuePreConditions(Queue queue) throws JMSException {
        this.checkPreConditions();
        if (queue == null) {
            throw new UnsupportedOperationException("Queue is null.");
        }
        if (!(queue instanceof AMQDestination)) {
            throw new InvalidDestinationException("Queue: " + queue + " is not a valid Qpid queue");
        }
        AMQDestination destination = (AMQDestination)((Object)queue);
        if (!destination.isCheckedForQueueBinding() && this.checkQueueBeforePublish()) {
            if (this._delegate.getSession().isStrictAMQP()) {
                this._delegate._logger.warn("AMQP does not support destination validation before publish, ");
                destination.setCheckedForQueueBinding(true);
            } else if (this._delegate.isBound(destination)) {
                destination.setCheckedForQueueBinding(true);
            } else {
                throw new InvalidDestinationException("Queue: " + queue + " is not a valid destination (no bindings on server");
            }
        }
    }

    private boolean checkQueueBeforePublish() {
        return this.verifyQueueBindingBeforePublish;
    }
}

