/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.handler;

import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.wso2.andes.AMQException;
import org.wso2.andes.client.protocol.AMQProtocolSession;
import org.wso2.andes.client.state.StateAwareMethodListener;
import org.wso2.andes.framing.ConnectionSecureBody;
import org.wso2.andes.framing.ConnectionSecureOkBody;

public class ConnectionSecureMethodHandler
implements StateAwareMethodListener<ConnectionSecureBody> {
    private static final ConnectionSecureMethodHandler _instance = new ConnectionSecureMethodHandler();

    public static ConnectionSecureMethodHandler getInstance() {
        return _instance;
    }

    @Override
    public void methodReceived(AMQProtocolSession session, ConnectionSecureBody body, int channelId) throws AMQException {
        SaslClient client = session.getSaslClient();
        if (client == null) {
            throw new AMQException(null, "No SASL client set up - cannot proceed with authentication", null);
        }
        try {
            byte[] response = client.evaluateChallenge(body.getChallenge());
            ConnectionSecureOkBody secureOkBody = session.getMethodRegistry().createConnectionSecureOkBody(response);
            session.writeFrame(secureOkBody.generateFrame(channelId));
        }
        catch (SaslException e) {
            throw new AMQException(null, "Error processing SASL challenge: " + e, e);
        }
    }
}

