/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.message;

import java.util.Enumeration;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.wso2.andes.AMQException;
import org.wso2.andes.client.AMQSession;
import org.wso2.andes.client.message.AMQMessageDelegate;
import org.wso2.andes.client.message.AMQMessageDelegateFactory;
import org.wso2.andes.jms.Message;
import org.wso2.org.apache.mina.common.ByteBuffer;

public abstract class AbstractJMSMessage
implements Message {
    protected ByteBuffer _data;
    protected boolean _readableMessage = false;
    protected boolean _changedData = true;
    protected AMQMessageDelegate _delegate;
    private boolean _redelivered;

    protected AbstractJMSMessage(AMQMessageDelegateFactory delegateFactory, ByteBuffer data) {
        this._delegate = delegateFactory.createDelegate();
        this._data = data;
        if (this._data != null) {
            this._data.acquire();
        }
        this._readableMessage = data != null;
        this._changedData = data == null;
    }

    protected AbstractJMSMessage(AMQMessageDelegate delegate, ByteBuffer data) throws AMQException {
        this._delegate = delegate;
        this._data = data;
        if (this._data != null) {
            this._data.acquire();
        }
        this._readableMessage = data != null;
    }

    @Override
    public String getJMSMessageID() throws JMSException {
        return this._delegate.getJMSMessageID();
    }

    @Override
    public void setJMSMessageID(String messageId) throws JMSException {
        this._delegate.setJMSMessageID(messageId);
    }

    public void setJMSMessageID(UUID messageId) throws JMSException {
        this._delegate.setJMSMessageID(messageId);
    }

    @Override
    public long getJMSTimestamp() throws JMSException {
        return this._delegate.getJMSTimestamp();
    }

    @Override
    public void setJMSTimestamp(long timestamp) throws JMSException {
        this._delegate.setJMSTimestamp(timestamp);
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this._delegate.getJMSCorrelationIDAsBytes();
    }

    @Override
    public void setJMSCorrelationIDAsBytes(byte[] bytes) throws JMSException {
        this._delegate.setJMSCorrelationIDAsBytes(bytes);
    }

    @Override
    public void setJMSCorrelationID(String correlationId) throws JMSException {
        this._delegate.setJMSCorrelationID(correlationId);
    }

    @Override
    public String getJMSCorrelationID() throws JMSException {
        return this._delegate.getJMSCorrelationID();
    }

    @Override
    public Destination getJMSReplyTo() throws JMSException {
        return this._delegate.getJMSReplyTo();
    }

    @Override
    public void setJMSReplyTo(Destination destination) throws JMSException {
        this._delegate.setJMSReplyTo(destination);
    }

    @Override
    public Destination getJMSDestination() throws JMSException {
        return this._delegate.getJMSDestination();
    }

    @Override
    public void setJMSDestination(Destination destination) {
        this._delegate.setJMSDestination(destination);
    }

    @Override
    public int getJMSDeliveryMode() throws JMSException {
        return this._delegate.getJMSDeliveryMode();
    }

    @Override
    public void setJMSDeliveryMode(int i) throws JMSException {
        this._delegate.setJMSDeliveryMode(i);
    }

    @Override
    public boolean getJMSRedelivered() throws JMSException {
        return this._redelivered;
    }

    @Override
    public void setJMSRedelivered(boolean b) throws JMSException {
        this._redelivered = b;
    }

    @Override
    public String getJMSType() throws JMSException {
        return this._delegate.getJMSType();
    }

    @Override
    public void setJMSType(String string) throws JMSException {
        this._delegate.setJMSType(string);
    }

    @Override
    public long getJMSExpiration() throws JMSException {
        return this._delegate.getJMSExpiration();
    }

    @Override
    public void setJMSExpiration(long l) throws JMSException {
        this._delegate.setJMSExpiration(l);
    }

    @Override
    public int getJMSPriority() throws JMSException {
        return this._delegate.getJMSPriority();
    }

    @Override
    public void setJMSPriority(int i) throws JMSException {
        this._delegate.setJMSPriority(i);
    }

    @Override
    public boolean propertyExists(String propertyName) throws JMSException {
        return this._delegate.propertyExists(propertyName);
    }

    @Override
    public boolean getBooleanProperty(String s2) throws JMSException {
        return this._delegate.getBooleanProperty(s2);
    }

    @Override
    public byte getByteProperty(String s2) throws JMSException {
        return this._delegate.getByteProperty(s2);
    }

    @Override
    public short getShortProperty(String s2) throws JMSException {
        return this._delegate.getShortProperty(s2);
    }

    @Override
    public int getIntProperty(String s2) throws JMSException {
        return this._delegate.getIntProperty(s2);
    }

    @Override
    public long getLongProperty(String s2) throws JMSException {
        return this._delegate.getLongProperty(s2);
    }

    @Override
    public float getFloatProperty(String s2) throws JMSException {
        return this._delegate.getFloatProperty(s2);
    }

    @Override
    public double getDoubleProperty(String s2) throws JMSException {
        return this._delegate.getDoubleProperty(s2);
    }

    @Override
    public String getStringProperty(String s2) throws JMSException {
        return this._delegate.getStringProperty(s2);
    }

    @Override
    public Object getObjectProperty(String s2) throws JMSException {
        return this._delegate.getObjectProperty(s2);
    }

    @Override
    public Enumeration getPropertyNames() throws JMSException {
        return this._delegate.getPropertyNames();
    }

    @Override
    public void setBooleanProperty(String s2, boolean b) throws JMSException {
        this._delegate.setBooleanProperty(s2, b);
    }

    @Override
    public void setByteProperty(String s2, byte b) throws JMSException {
        this._delegate.setByteProperty(s2, b);
    }

    @Override
    public void setShortProperty(String s2, short i) throws JMSException {
        this._delegate.setShortProperty(s2, i);
    }

    @Override
    public void setIntProperty(String s2, int i) throws JMSException {
        this._delegate.setIntProperty(s2, i);
    }

    @Override
    public void setLongProperty(String s2, long l) throws JMSException {
        this._delegate.setLongProperty(s2, l);
    }

    @Override
    public void setFloatProperty(String s2, float v) throws JMSException {
        this._delegate.setFloatProperty(s2, v);
    }

    @Override
    public void setDoubleProperty(String s2, double v) throws JMSException {
        this._delegate.setDoubleProperty(s2, v);
    }

    @Override
    public void setStringProperty(String s2, String s1) throws JMSException {
        this._delegate.setStringProperty(s2, s1);
    }

    @Override
    public void setObjectProperty(String s2, Object o) throws JMSException {
        this._delegate.setObjectProperty(s2, o);
    }

    @Override
    public void clearProperties() throws JMSException {
        this._delegate.clearProperties();
    }

    @Override
    public void clearBody() throws JMSException {
        this.clearBodyImpl();
        this._readableMessage = false;
    }

    @Override
    public void acknowledgeThis() throws JMSException {
        this._delegate.acknowledgeThis();
    }

    @Override
    public void acknowledge() throws JMSException {
        this._delegate.acknowledge();
    }

    public abstract void clearBodyImpl() throws JMSException;

    public abstract String toBodyString() throws JMSException;

    protected abstract String getMimeType();

    public String toString() {
        try {
            StringBuffer buf = new StringBuffer("Body:\n");
            buf.append(this.toBodyString());
            buf.append("\nJMS Correlation ID: ").append(this.getJMSCorrelationID());
            buf.append("\nJMS timestamp: ").append(this.getJMSTimestamp());
            buf.append("\nJMS expiration: ").append(this.getJMSExpiration());
            buf.append("\nJMS priority: ").append(this.getJMSPriority());
            buf.append("\nJMS delivery mode: ").append(this.getJMSDeliveryMode());
            buf.append("\nJMS reply to: ").append(this.getReplyToString());
            buf.append("\nJMS Redelivered: ").append(this._redelivered);
            buf.append("\nJMS Destination: ").append(this.getJMSDestination());
            buf.append("\nJMS Type: ").append(this.getJMSType());
            buf.append("\nJMS MessageID: ").append(this.getJMSMessageID());
            buf.append("\nJMS Content-Type: ").append(this.getContentType());
            buf.append("\nAMQ message number: ").append(this.getDeliveryTag());
            buf.append("\nProperties:");
            Enumeration propertyNames = this.getPropertyNames();
            if (!propertyNames.hasMoreElements()) {
                buf.append("<NONE>");
            } else {
                buf.append('\n');
                while (propertyNames.hasMoreElements()) {
                    String propertyName = (String)propertyNames.nextElement();
                    buf.append("\t").append(propertyName).append(" = ").append(this.getObjectProperty(propertyName)).append("\n");
                }
            }
            return buf.toString();
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    public AMQMessageDelegate getDelegate() {
        return this._delegate;
    }

    public ByteBuffer getData() {
        if (this._data != null) {
            this.reset();
        }
        return this._data;
    }

    protected void checkReadable() throws MessageNotReadableException {
        if (!this._readableMessage) {
            throw new MessageNotReadableException("You need to call reset() to make the message readable");
        }
    }

    protected void checkWritable() throws MessageNotWriteableException {
        if (this._readableMessage) {
            throw new MessageNotWriteableException("You need to call clearBody() to make the message writable");
        }
    }

    public void reset() {
        if (!this._changedData) {
            this._data.rewind();
        } else {
            this._data.flip();
            this._changedData = false;
        }
    }

    public int getContentLength() {
        if (this._data != null) {
            return this._data.remaining();
        }
        return 0;
    }

    public void receivedFromServer() {
        this._changedData = false;
    }

    public void setAMQSession(AMQSession s2) {
        this._delegate.setAMQSession(s2);
    }

    public AMQSession getAMQSession() {
        return this._delegate.getAMQSession();
    }

    public long getDeliveryTag() {
        return this._delegate.getDeliveryTag();
    }

    public void prepareForSending() throws JMSException {
    }

    public void setContentType(String contentType) {
        this._delegate.setContentType(contentType);
    }

    public String getContentType() {
        return this._delegate.getContentType();
    }

    public void setEncoding(String encoding) {
        this._delegate.setEncoding(encoding);
    }

    public String getEncoding() {
        return this._delegate.getEncoding();
    }

    public String getReplyToString() {
        return this._delegate.getReplyToString();
    }

    protected void removeProperty(String propertyName) throws JMSException {
        this._delegate.removeProperty(propertyName);
    }
}

