/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.message;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import org.wso2.andes.AMQException;
import org.wso2.andes.client.message.AMQMessageDelegate;
import org.wso2.andes.client.message.AMQMessageDelegateFactory;
import org.wso2.andes.client.message.AbstractBytesMessage;

public class JMSBytesMessage
extends AbstractBytesMessage
implements BytesMessage {
    public static final String MIME_TYPE = "application/octet-stream";

    public JMSBytesMessage(AMQMessageDelegateFactory delegateFactory) {
        this(delegateFactory, null);
    }

    JMSBytesMessage(AMQMessageDelegateFactory delegateFactory, org.wso2.org.apache.mina.common.ByteBuffer data) {
        super(delegateFactory, data);
    }

    JMSBytesMessage(AMQMessageDelegate delegate, org.wso2.org.apache.mina.common.ByteBuffer data) throws AMQException {
        super(delegate, data);
    }

    @Override
    public void reset() {
        super.reset();
        this._readableMessage = true;
    }

    @Override
    protected String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public long getBodyLength() throws JMSException {
        this.checkReadable();
        return this._data.limit();
    }

    @Override
    public boolean readBoolean() throws JMSException {
        this.checkReadable();
        this.checkAvailable(1);
        return this._data.get() != 0;
    }

    @Override
    public byte readByte() throws JMSException {
        this.checkReadable();
        this.checkAvailable(1);
        return this._data.get();
    }

    @Override
    public int readUnsignedByte() throws JMSException {
        this.checkReadable();
        this.checkAvailable(1);
        return this._data.getUnsigned();
    }

    @Override
    public short readShort() throws JMSException {
        this.checkReadable();
        this.checkAvailable(2);
        return this._data.getShort();
    }

    @Override
    public int readUnsignedShort() throws JMSException {
        this.checkReadable();
        this.checkAvailable(2);
        return this._data.getUnsignedShort();
    }

    @Override
    public char readChar() throws JMSException {
        this.checkReadable();
        this.checkAvailable(2);
        return this._data.getChar();
    }

    @Override
    public int readInt() throws JMSException {
        this.checkReadable();
        this.checkAvailable(4);
        return this._data.getInt();
    }

    @Override
    public long readLong() throws JMSException {
        this.checkReadable();
        this.checkAvailable(8);
        return this._data.getLong();
    }

    @Override
    public float readFloat() throws JMSException {
        this.checkReadable();
        this.checkAvailable(4);
        return this._data.getFloat();
    }

    @Override
    public double readDouble() throws JMSException {
        this.checkReadable();
        this.checkAvailable(8);
        return this._data.getDouble();
    }

    @Override
    public String readUTF() throws JMSException {
        this.checkReadable();
        try {
            short length = this.readShort();
            if (length == 0) {
                return "";
            }
            CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
            org.wso2.org.apache.mina.common.ByteBuffer encodedString = this._data.slice();
            encodedString.limit(length);
            this._data.position(this._data.position() + length);
            CharBuffer string = decoder.decode(encodedString.buf());
            return string.toString();
        }
        catch (CharacterCodingException e) {
            JMSException jmse = new JMSException("Error decoding byte stream as a UTF8 string: " + e);
            jmse.setLinkedException(e);
            jmse.initCause(e);
            throw jmse;
        }
    }

    @Override
    public int readBytes(byte[] bytes) throws JMSException {
        int count;
        if (bytes == null) {
            throw new IllegalArgumentException("byte array must not be null");
        }
        this.checkReadable();
        int n = count = this._data.remaining() >= bytes.length ? bytes.length : this._data.remaining();
        if (count == 0) {
            return -1;
        }
        this._data.get(bytes, 0, count);
        return count;
    }

    @Override
    public int readBytes(byte[] bytes, int maxLength) throws JMSException {
        int count;
        if (bytes == null) {
            throw new IllegalArgumentException("byte array must not be null");
        }
        if (maxLength > bytes.length) {
            throw new IllegalArgumentException("maxLength must be <= bytes.length");
        }
        this.checkReadable();
        int n = count = this._data.remaining() >= maxLength ? maxLength : this._data.remaining();
        if (count == 0) {
            return -1;
        }
        this._data.get(bytes, 0, count);
        return count;
    }

    @Override
    public void writeBoolean(boolean b) throws JMSException {
        this.checkWritable();
        this._changedData = true;
        this._data.put(b ? (byte)1 : 0);
    }

    @Override
    public void writeByte(byte b) throws JMSException {
        this.checkWritable();
        this._changedData = true;
        this._data.put(b);
    }

    @Override
    public void writeShort(short i) throws JMSException {
        this.checkWritable();
        this._changedData = true;
        this._data.putShort(i);
    }

    @Override
    public void writeChar(char c) throws JMSException {
        this.checkWritable();
        this._changedData = true;
        this._data.putChar(c);
    }

    @Override
    public void writeInt(int i) throws JMSException {
        this.checkWritable();
        this._changedData = true;
        this._data.putInt(i);
    }

    @Override
    public void writeLong(long l) throws JMSException {
        this.checkWritable();
        this._changedData = true;
        this._data.putLong(l);
    }

    @Override
    public void writeFloat(float v) throws JMSException {
        this.checkWritable();
        this._changedData = true;
        this._data.putFloat(v);
    }

    @Override
    public void writeDouble(double v) throws JMSException {
        this.checkWritable();
        this._changedData = true;
        this._data.putDouble(v);
    }

    @Override
    public void writeUTF(String string) throws JMSException {
        this.checkWritable();
        try {
            CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
            ByteBuffer encodedString = encoder.encode(CharBuffer.wrap(string));
            this._data.putShort((short)encodedString.limit());
            this._data.put(encodedString);
            this._changedData = true;
        }
        catch (CharacterCodingException e) {
            JMSException jmse = new JMSException("Unable to encode string: " + e);
            jmse.setLinkedException(e);
            jmse.initCause(e);
            throw jmse;
        }
    }

    @Override
    public void writeBytes(byte[] bytes) throws JMSException {
        this.checkWritable();
        this._data.put(bytes);
        this._changedData = true;
    }

    @Override
    public void writeBytes(byte[] bytes, int offset, int length) throws JMSException {
        this.checkWritable();
        this._data.put(bytes, offset, length);
        this._changedData = true;
    }

    @Override
    public void writeObject(Object object) throws JMSException {
        this.checkWritable();
        if (object == null) {
            throw new NullPointerException("Argument must not be null");
        }
        Class<?> clazz = object.getClass();
        if (clazz == Byte.class) {
            this.writeByte((Byte)object);
        } else if (clazz == Boolean.class) {
            this.writeBoolean((Boolean)object);
        } else if (clazz == byte[].class) {
            this.writeBytes((byte[])object);
        } else if (clazz == Short.class) {
            this.writeShort((Short)object);
        } else if (clazz == Character.class) {
            this.writeChar(((Character)object).charValue());
        } else if (clazz == Integer.class) {
            this.writeInt((Integer)object);
        } else if (clazz == Long.class) {
            this.writeLong((Long)object);
        } else if (clazz == Float.class) {
            this.writeFloat(((Float)object).floatValue());
        } else if (clazz == Double.class) {
            this.writeDouble((Double)object);
        } else if (clazz == String.class) {
            this.writeUTF((String)object);
        } else {
            throw new MessageFormatException("Only primitives plus byte arrays and String are valid types");
        }
    }
}

