/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.url;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wso2.andes.client.AMQBrokerDetails;
import org.wso2.andes.client.AMQConnectionURL;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.url.URLHelper;
import org.wso2.andes.url.URLSyntaxException;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class URLParser {
    private AMQConnectionURL _url;
    private static final String SECRET_ALIAS = "secretAlias:";
    private static final String RANDOM_PASSWORD_KEY = "password";

    public URLParser(AMQConnectionURL url) throws URLSyntaxException {
        this._url = url;
        String amqpUrl = this.resolveAlias(this._url.getURL());
        this.parseURL(amqpUrl);
    }

    private String resolveAlias(String amqpUrl) {
        Pattern p = Pattern.compile("\\{(.*?)\\}");
        Matcher m3 = p.matcher(amqpUrl);
        while (m3.find()) {
            String password = m3.group(1);
            if (!password.startsWith(SECRET_ALIAS)) continue;
            password = password.split(SECRET_ALIAS)[1];
            Properties properties = new Properties();
            properties.setProperty(RANDOM_PASSWORD_KEY, password);
            SecretResolver secretResolver = SecretResolverFactory.create(properties);
            password = secretResolver.resolve(password);
            amqpUrl = amqpUrl.replace("{" + m3.group(1) + "}", password);
        }
        return amqpUrl;
    }

    private void parseURL(String fullURL) throws URLSyntaxException {
        try {
            URI connection = new URI(fullURL);
            if (connection.getScheme() == null || !connection.getScheme().equalsIgnoreCase("amqp")) {
                throw new URISyntaxException(fullURL, "Not an AMQP URL");
            }
            if (connection.getHost() == null || connection.getHost().equals("")) {
                String tmp = connection.getAuthority();
                if (tmp != null && tmp.indexOf(64) < tmp.length() - 1) {
                    this._url.setClientName(tmp.substring(tmp.indexOf(64) + 1, tmp.length()));
                }
            } else {
                this._url.setClientName(connection.getHost());
            }
            String userInfo = connection.getUserInfo();
            if (userInfo == null && (userInfo = connection.getAuthority()) != null) {
                int atIndex = userInfo.indexOf(64);
                userInfo = atIndex != -1 ? userInfo.substring(0, atIndex) : null;
            }
            if (userInfo == null) {
                throw URLHelper.parseError("amqp".length() + 3, "User information not found on url", fullURL);
            }
            this.parseUserInfo(userInfo);
            String virtualHost = connection.getPath();
            if (virtualHost == null || virtualHost.equals("")) {
                int authLength = connection.getAuthority().length();
                int start = "amqp".length() + 3;
                int testIndex = start + authLength;
                if (testIndex < fullURL.length() && fullURL.charAt(testIndex) == '?') {
                    throw URLHelper.parseError(start, testIndex - start, "Virtual host found", fullURL);
                }
                throw URLHelper.parseError(-1, "Virtual host not specified", fullURL);
            }
            this._url.setVirtualHost(virtualHost);
            URLHelper.parseOptions(this._url.getOptions(), connection.getQuery());
            this.processOptions();
        }
        catch (URISyntaxException uris) {
            if (uris instanceof URLSyntaxException) {
                throw (URLSyntaxException)uris;
            }
            int slash = fullURL.indexOf("\\");
            if (slash == -1) {
                throw URLHelper.parseError(uris.getIndex(), uris.getReason(), uris.getInput());
            }
            if (slash != 0 && fullURL.charAt(slash - 1) == ':') {
                throw URLHelper.parseError(slash - 2, fullURL.indexOf(63) - slash + 2, "Virtual host looks like a windows path, forward slash not allowed in URL", fullURL);
            }
            throw URLHelper.parseError(slash, "Forward slash not allowed in URL", fullURL);
        }
    }

    private void parseUserInfo(String userinfo) throws URLSyntaxException {
        int colonIndex = userinfo.indexOf(58);
        if (colonIndex == -1) {
            throw URLHelper.parseError("amqp".length() + 3, userinfo.length(), "Null password in user information not allowed.", this._url.getURL());
        }
        this._url.setUsername(userinfo.substring(0, colonIndex));
        this._url.setPassword(userinfo.substring(colonIndex + 1));
    }

    private void processOptions() throws URLSyntaxException {
        if (this._url.getOptions().containsKey("brokerlist")) {
            String brokerlist = this._url.getOptions().get("brokerlist");
            StringTokenizer st = new StringTokenizer(brokerlist, ";");
            while (st.hasMoreTokens()) {
                String broker = st.nextToken();
                AMQBrokerDetails brokerDetails = new AMQBrokerDetails(broker);
                this._url.addBrokerDetails(brokerDetails);
            }
            this._url.getOptions().remove("brokerlist");
        }
        if (this._url.getOptions().containsKey("failover")) {
            String failover = this._url.getOptions().get("failover");
            int methodIndex = failover.indexOf(63);
            if (methodIndex > -1) {
                this._url.setFailoverMethod(failover.substring(0, methodIndex));
                URLHelper.parseOptions(this._url.getFailoverOptions(), failover.substring(methodIndex + 1));
            } else {
                this._url.setFailoverMethod(failover);
            }
            this._url.getOptions().remove("failover");
        }
        if (this._url.getOptions().containsKey("defaultTopicExchange")) {
            this._url.setDefaultTopicExchangeName(new AMQShortString(this._url.getOptions().get("defaultTopicExchange")));
        }
        if (this._url.getOptions().containsKey("defaultQueueExchange")) {
            this._url.setDefaultQueueExchangeName(new AMQShortString(this._url.getOptions().get("defaultQueueExchange")));
        }
        if (this._url.getOptions().containsKey("temporaryQueueExchange")) {
            this._url.setTemporaryQueueExchangeName(new AMQShortString(this._url.getOptions().get("temporaryQueueExchange")));
        }
        if (this._url.getOptions().containsKey("temporaryTopicExchange")) {
            this._url.setTemporaryTopicExchangeName(new AMQShortString(this._url.getOptions().get("temporaryTopicExchange")));
        }
    }
}

