/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing;

import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.framing.AMQDataBlock;
import org.wso2.andes.framing.EncodableAMQDataBlock;
import org.wso2.andes.framing.EncodingUtils;
import org.wso2.org.apache.mina.common.ByteBuffer;
import org.wso2.org.apache.mina.common.IoSession;
import org.wso2.org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.wso2.org.apache.mina.filter.codec.demux.MessageEncoder;

public final class AMQDataBlockEncoder
implements MessageEncoder {
    private static final Logger _logger = LoggerFactory.getLogger(AMQDataBlockEncoder.class);
    private final Set _messageTypes = Collections.singleton(EncodableAMQDataBlock.class);

    @Override
    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        AMQDataBlock frame = (AMQDataBlock)message;
        ByteBuffer buffer = frame.toByteBuffer();
        if (_logger.isDebugEnabled()) {
            _logger.debug("Encoded frame byte-buffer is '" + EncodingUtils.convertToHexString(buffer) + "'");
        }
        out.write(buffer);
    }

    public Set getMessageTypes() {
        return this._messageTypes;
    }
}

