/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing;

import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.Content;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.framing.FieldTableFactory;
import org.wso2.org.apache.mina.common.ByteBuffer;

public class EncodingUtils {
    private static final Logger _logger = LoggerFactory.getLogger(EncodingUtils.class);
    private static final String STRING_ENCODING = "iso8859-15";
    private static final Charset _charset = Charset.forName("iso8859-15");
    public static final int SIZEOF_UNSIGNED_SHORT = 2;
    public static final int SIZEOF_UNSIGNED_INT = 4;
    private static final boolean[] ALL_FALSE_ARRAY = new boolean[8];
    private static char[] hex_chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static int encodedShortStringLength(String s2) {
        if (s2 == null) {
            return 1;
        }
        return (short)(1 + s2.length());
    }

    public static int encodedShortStringLength(short s2) {
        if (s2 == 0) {
            return 2;
        }
        boolean len = false;
        if (s2 < 0) {
            len = true;
            s2 = -s2;
        }
        if (s2 > 9999) {
            return 6;
        }
        if (s2 > 999) {
            return 5;
        }
        if (s2 > 99) {
            return 4;
        }
        if (s2 > 9) {
            return 3;
        }
        return 2;
    }

    public static int encodedShortStringLength(int i) {
        if (i == 0) {
            return 2;
        }
        int len = 0;
        if (i < 0) {
            len = 1;
            i = -i;
        }
        if (i < Short.MAX_VALUE) {
            return len + EncodingUtils.encodedShortStringLength((short)i);
        }
        if (i > 999999) {
            return len + 6 + EncodingUtils.encodedShortStringLength((short)(i / 1000000));
        }
        return len + 5 + EncodingUtils.encodedShortStringLength((short)(i / 100000));
    }

    public static int encodedShortStringLength(long l) {
        if (l == 0L) {
            return 2;
        }
        int len = 0;
        if (l < 0L) {
            len = 1;
            l = -l;
        }
        if (l < Integer.MAX_VALUE) {
            return len + EncodingUtils.encodedShortStringLength((int)l);
        }
        if (l > 9999999999L) {
            return len + 10 + EncodingUtils.encodedShortStringLength((int)(l / 10000000000L));
        }
        return len + 1 + EncodingUtils.encodedShortStringLength((int)(l / 10L));
    }

    public static int encodedShortStringLength(AMQShortString s2) {
        if (s2 == null) {
            return 1;
        }
        return 1 + s2.length();
    }

    public static int encodedLongStringLength(String s2) {
        if (s2 == null) {
            return 4;
        }
        return 4 + s2.length();
    }

    public static int encodedLongStringLength(char[] s2) {
        if (s2 == null) {
            return 4;
        }
        return 4 + s2.length;
    }

    public static int encodedLongstrLength(byte[] bytes) {
        if (bytes == null) {
            return 4;
        }
        return 4 + bytes.length;
    }

    public static int encodedFieldTableLength(FieldTable table) {
        if (table == null) {
            return 4;
        }
        return (int)table.getEncodedSize() + 4;
    }

    public static int encodedContentLength(Content table) {
        return 0;
    }

    public static void writeShortStringBytes(ByteBuffer buffer, String s2) {
        if (s2 != null) {
            byte[] encodedString = new byte[s2.length()];
            char[] cha = s2.toCharArray();
            for (int i = 0; i < cha.length; ++i) {
                encodedString[i] = (byte)cha[i];
            }
            EncodingUtils.writeUnsignedByte(buffer, (short)encodedString.length);
            buffer.put(encodedString);
        } else {
            buffer.put((byte)0);
        }
    }

    public static void writeShortStringBytes(ByteBuffer buffer, AMQShortString s2) {
        if (s2 != null) {
            s2.writeToBuffer(buffer);
        } else {
            buffer.put((byte)0);
        }
    }

    public static void writeLongStringBytes(ByteBuffer buffer, String s2) {
        assert (s2 == null || s2.length() <= 65534);
        if (s2 != null) {
            int len = s2.length();
            EncodingUtils.writeUnsignedInteger(buffer, s2.length());
            byte[] encodedString = new byte[len];
            char[] cha = s2.toCharArray();
            for (int i = 0; i < cha.length; ++i) {
                encodedString[i] = (byte)cha[i];
            }
            buffer.put(encodedString);
        } else {
            EncodingUtils.writeUnsignedInteger(buffer, 0L);
        }
    }

    public static void writeLongStringBytes(ByteBuffer buffer, char[] s2) {
        assert (s2 == null || s2.length <= 65534);
        if (s2 != null) {
            int len = s2.length;
            EncodingUtils.writeUnsignedInteger(buffer, s2.length);
            byte[] encodedString = new byte[len];
            for (int i = 0; i < s2.length; ++i) {
                encodedString[i] = (byte)s2[i];
            }
            buffer.put(encodedString);
        } else {
            EncodingUtils.writeUnsignedInteger(buffer, 0L);
        }
    }

    public static void writeLongStringBytes(ByteBuffer buffer, byte[] bytes) {
        assert (bytes == null || bytes.length <= 65534);
        if (bytes != null) {
            EncodingUtils.writeUnsignedInteger(buffer, bytes.length);
            buffer.put(bytes);
        } else {
            EncodingUtils.writeUnsignedInteger(buffer, 0L);
        }
    }

    public static void writeUnsignedByte(ByteBuffer buffer, short b) {
        byte bv = (byte)b;
        buffer.put(bv);
    }

    public static void writeUnsignedShort(ByteBuffer buffer, int s2) {
        if (s2 < Short.MAX_VALUE) {
            buffer.putShort((short)s2);
        } else {
            short sv = (short)s2;
            buffer.put((byte)(0xFF & sv >> 8));
            buffer.put((byte)(0xFF & sv));
        }
    }

    public static int unsignedIntegerLength() {
        return 4;
    }

    public static void writeUnsignedInteger(ByteBuffer buffer, long l) {
        if (l < Integer.MAX_VALUE) {
            buffer.putInt((int)l);
        } else {
            int iv = (int)l;
            buffer.put((byte)(0xFF & iv >> 24));
            buffer.put((byte)(0xFF & iv >> 16));
            buffer.put((byte)(0xFF & iv >> 8));
            buffer.put((byte)(0xFF & iv));
        }
    }

    public static void writeFieldTableBytes(ByteBuffer buffer, FieldTable table) {
        if (table != null) {
            table.writeToBuffer(buffer);
        } else {
            EncodingUtils.writeUnsignedInteger(buffer, 0L);
        }
    }

    public static void writeContentBytes(ByteBuffer buffer, Content content) {
    }

    public static void writeBooleans(ByteBuffer buffer, boolean[] values) {
        byte packedValue = 0;
        for (int i = 0; i < values.length; ++i) {
            if (!values[i]) continue;
            packedValue = (byte)(packedValue | 1 << i);
        }
        buffer.put(packedValue);
    }

    public static void writeBooleans(ByteBuffer buffer, boolean value) {
        buffer.put(value ? (byte)1 : 0);
    }

    public static void writeBooleans(ByteBuffer buffer, boolean value0, boolean value1) {
        byte packedValue;
        byte by = packedValue = value0 ? (byte)1 : 0;
        if (value1) {
            packedValue = (byte)(packedValue | 2);
        }
        buffer.put(packedValue);
    }

    public static void writeBooleans(ByteBuffer buffer, boolean value0, boolean value1, boolean value2) {
        byte packedValue;
        byte by = packedValue = value0 ? (byte)1 : 0;
        if (value1) {
            packedValue = (byte)(packedValue | 2);
        }
        if (value2) {
            packedValue = (byte)(packedValue | 4);
        }
        buffer.put(packedValue);
    }

    public static void writeBooleans(ByteBuffer buffer, boolean value0, boolean value1, boolean value2, boolean value3) {
        byte packedValue;
        byte by = packedValue = value0 ? (byte)1 : 0;
        if (value1) {
            packedValue = (byte)(packedValue | 2);
        }
        if (value2) {
            packedValue = (byte)(packedValue | 4);
        }
        if (value3) {
            packedValue = (byte)(packedValue | 8);
        }
        buffer.put(packedValue);
    }

    public static void writeBooleans(ByteBuffer buffer, boolean value0, boolean value1, boolean value2, boolean value3, boolean value4) {
        byte packedValue;
        byte by = packedValue = value0 ? (byte)1 : 0;
        if (value1) {
            packedValue = (byte)(packedValue | 2);
        }
        if (value2) {
            packedValue = (byte)(packedValue | 4);
        }
        if (value3) {
            packedValue = (byte)(packedValue | 8);
        }
        if (value4) {
            packedValue = (byte)(packedValue | 0x10);
        }
        buffer.put(packedValue);
    }

    public static void writeBooleans(ByteBuffer buffer, boolean value0, boolean value1, boolean value2, boolean value3, boolean value4, boolean value5) {
        byte packedValue;
        byte by = packedValue = value0 ? (byte)1 : 0;
        if (value1) {
            packedValue = (byte)(packedValue | 2);
        }
        if (value2) {
            packedValue = (byte)(packedValue | 4);
        }
        if (value3) {
            packedValue = (byte)(packedValue | 8);
        }
        if (value4) {
            packedValue = (byte)(packedValue | 0x10);
        }
        if (value5) {
            packedValue = (byte)(packedValue | 0x20);
        }
        buffer.put(packedValue);
    }

    public static void writeBooleans(ByteBuffer buffer, boolean value0, boolean value1, boolean value2, boolean value3, boolean value4, boolean value5, boolean value6) {
        byte packedValue;
        byte by = packedValue = value0 ? (byte)1 : 0;
        if (value1) {
            packedValue = (byte)(packedValue | 2);
        }
        if (value2) {
            packedValue = (byte)(packedValue | 4);
        }
        if (value3) {
            packedValue = (byte)(packedValue | 8);
        }
        if (value4) {
            packedValue = (byte)(packedValue | 0x10);
        }
        if (value5) {
            packedValue = (byte)(packedValue | 0x20);
        }
        if (value6) {
            packedValue = (byte)(packedValue | 0x40);
        }
        buffer.put(packedValue);
    }

    public static void writeBooleans(ByteBuffer buffer, boolean value0, boolean value1, boolean value2, boolean value3, boolean value4, boolean value5, boolean value6, boolean value7) {
        byte packedValue;
        byte by = packedValue = value0 ? (byte)1 : 0;
        if (value1) {
            packedValue = (byte)(packedValue | 2);
        }
        if (value2) {
            packedValue = (byte)(packedValue | 4);
        }
        if (value3) {
            packedValue = (byte)(packedValue | 8);
        }
        if (value4) {
            packedValue = (byte)(packedValue | 0x10);
        }
        if (value5) {
            packedValue = (byte)(packedValue | 0x20);
        }
        if (value6) {
            packedValue = (byte)(packedValue | 0x40);
        }
        if (value7) {
            packedValue = (byte)(packedValue | 0xFFFFFF80);
        }
        buffer.put(packedValue);
    }

    public static void writeLongstr(ByteBuffer buffer, byte[] data) {
        if (data != null) {
            EncodingUtils.writeUnsignedInteger(buffer, data.length);
            buffer.put(data);
        } else {
            EncodingUtils.writeUnsignedInteger(buffer, 0L);
        }
    }

    public static void writeTimestamp(ByteBuffer buffer, long timestamp) {
        EncodingUtils.writeLong(buffer, timestamp);
    }

    public static boolean[] readBooleans(ByteBuffer buffer) {
        byte packedValue = buffer.get();
        if (packedValue == 0) {
            return ALL_FALSE_ARRAY;
        }
        boolean[] result = new boolean[8];
        result[0] = (packedValue & 1) != 0;
        result[1] = (packedValue & 2) != 0;
        result[2] = (packedValue & 4) != 0;
        boolean bl = result[3] = (packedValue & 8) != 0;
        if ((packedValue & 0xF0) == 0) {
            result[0] = (packedValue & 1) != 0;
        }
        result[4] = (packedValue & 0x10) != 0;
        result[5] = (packedValue & 0x20) != 0;
        result[6] = (packedValue & 0x40) != 0;
        result[7] = (packedValue & 0x80) != 0;
        return result;
    }

    public static FieldTable readFieldTable(ByteBuffer buffer) throws AMQFrameDecodingException {
        long length = buffer.getUnsignedInt();
        if (length == 0L) {
            return null;
        }
        return FieldTableFactory.newFieldTable(buffer, length);
    }

    public static Content readContent(ByteBuffer buffer) throws AMQFrameDecodingException {
        return null;
    }

    public static AMQShortString readAMQShortString(ByteBuffer buffer) {
        return AMQShortString.readFromBuffer(buffer);
    }

    public static String readShortString(ByteBuffer buffer) {
        short length = buffer.getUnsigned();
        if (length == 0) {
            return null;
        }
        byte[] stringBytes = new byte[length];
        buffer.get(stringBytes, 0, length);
        char[] stringChars = new char[length];
        for (int i = 0; i < stringChars.length; ++i) {
            stringChars[i] = (char)stringBytes[i];
        }
        return new String(stringChars);
    }

    public static String readLongString(ByteBuffer buffer) {
        long length = buffer.getUnsignedInt();
        if (length == 0L) {
            return "";
        }
        byte[] stringBytes = new byte[(int)length];
        buffer.get(stringBytes, 0, (int)length);
        char[] stringChars = new char[(int)length];
        for (int i = 0; i < stringChars.length; ++i) {
            stringChars[i] = (char)stringBytes[i];
        }
        return new String(stringChars);
    }

    public static byte[] readLongstr(ByteBuffer buffer) {
        long length = buffer.getUnsignedInt();
        if (length == 0L) {
            return null;
        }
        byte[] result = new byte[(int)length];
        buffer.get(result);
        return result;
    }

    public static long readTimestamp(ByteBuffer buffer) {
        return buffer.getLong();
    }

    static byte[] hexToByteArray(String id) {
        String s2 = id.charAt(1) == 'x' ? id.substring(2) : id;
        int len = s2.length();
        int byte_len = len / 2;
        byte[] b = new byte[byte_len];
        for (int i = 0; i < byte_len; ++i) {
            int ch = i * 2;
            byte b1 = Byte.parseByte(s2.substring(ch, ch + 1), 16);
            byte b2 = Byte.parseByte(s2.substring(ch + 1, ch + 2), 16);
            b[i] = (byte)(b1 * 16 + b2);
        }
        return b;
    }

    public static char[] convertToHexCharArray(byte[] from) {
        int length = from.length;
        char[] result_buff = new char[length * 2 + 2];
        result_buff[0] = 48;
        result_buff[1] = 120;
        int dest = 2;
        for (int i = 0; i < length; ++i) {
            int bite = from[i];
            if (bite < 0) {
                bite += 256;
            }
            result_buff[dest++] = hex_chars[bite >> 4];
            result_buff[dest++] = hex_chars[bite & 0xF];
        }
        return result_buff;
    }

    public static String convertToHexString(byte[] from) {
        return new String(EncodingUtils.convertToHexCharArray(from));
    }

    public static String convertToHexString(ByteBuffer bb) {
        int size = bb.limit();
        byte[] from = new byte[size];
        for (int i = 0; i < size; ++i) {
            from[i] = bb.get(i);
        }
        return new String(EncodingUtils.convertToHexCharArray(from));
    }

    public static void writeBoolean(ByteBuffer buffer, Boolean aBoolean) {
        buffer.put((byte)(aBoolean != false ? 1 : 0));
    }

    public static boolean readBoolean(ByteBuffer buffer) {
        byte packedValue = buffer.get();
        return packedValue == 1;
    }

    public static int encodedBooleanLength() {
        return 1;
    }

    public static void writeByte(ByteBuffer buffer, Byte aByte) {
        buffer.put(aByte);
    }

    public static byte readByte(ByteBuffer buffer) {
        return buffer.get();
    }

    public static int encodedByteLength() {
        return 1;
    }

    public static void writeShort(ByteBuffer buffer, Short aShort) {
        buffer.putShort(aShort);
    }

    public static short readShort(ByteBuffer buffer) {
        return buffer.getShort();
    }

    public static int encodedShortLength() {
        return 2;
    }

    public static void writeInteger(ByteBuffer buffer, Integer aInteger) {
        buffer.putInt(aInteger);
    }

    public static int readInteger(ByteBuffer buffer) {
        return buffer.getInt();
    }

    public static int encodedIntegerLength() {
        return 4;
    }

    public static void writeLong(ByteBuffer buffer, Long aLong) {
        buffer.putLong(aLong);
    }

    public static long readLong(ByteBuffer buffer) {
        return buffer.getLong();
    }

    public static int encodedLongLength() {
        return 8;
    }

    public static void writeFloat(ByteBuffer buffer, Float aFloat) {
        buffer.putFloat(aFloat.floatValue());
    }

    public static float readFloat(ByteBuffer buffer) {
        return buffer.getFloat();
    }

    public static int encodedFloatLength() {
        return 4;
    }

    public static void writeDouble(ByteBuffer buffer, Double aDouble) {
        buffer.putDouble(aDouble);
    }

    public static double readDouble(ByteBuffer buffer) {
        return buffer.getDouble();
    }

    public static int encodedDoubleLength() {
        return 8;
    }

    public static byte[] readBytes(ByteBuffer buffer) {
        long length = buffer.getUnsignedInt();
        if (length == 0L) {
            return null;
        }
        byte[] dataBytes = new byte[(int)length];
        buffer.get(dataBytes, 0, (int)length);
        return dataBytes;
    }

    public static void writeBytes(ByteBuffer buffer, byte[] data) {
        if (data != null) {
            EncodingUtils.writeUnsignedInteger(buffer, data.length);
            buffer.put(data);
        } else {
            EncodingUtils.writeUnsignedInteger(buffer, 0L);
        }
    }

    public static int encodedCharLength() {
        return EncodingUtils.encodedByteLength();
    }

    public static char readChar(ByteBuffer buffer) {
        return (char)buffer.get();
    }

    public static void writeChar(ByteBuffer buffer, char character) {
        EncodingUtils.writeByte(buffer, (byte)character);
    }

    public static long readLongAsShortString(ByteBuffer buffer) {
        boolean isNegative;
        short length = buffer.getUnsigned();
        short pos = 0;
        if (length == 0) {
            return 0L;
        }
        byte digit = buffer.get();
        long result = 0L;
        if (digit == 45) {
            isNegative = true;
            pos = (short)(pos + 1);
            digit = buffer.get();
        } else {
            isNegative = false;
        }
        result = digit - 48;
        pos = (short)(pos + 1);
        while (pos < length) {
            pos = (short)(pos + 1);
            digit = buffer.get();
            result = (result << 3) + (result << 1);
            result += (long)(digit - 48);
        }
        return result;
    }

    public static long readUnsignedInteger(ByteBuffer buffer) {
        long l = 0xFF & buffer.get();
        l <<= 8;
        l |= (long)(0xFF & buffer.get());
        l <<= 8;
        l |= (long)(0xFF & buffer.get());
        l <<= 8;
        return l |= (long)(0xFF & buffer.get());
    }
}

