/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_0_9;

import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.QueueDeleteBody;
import org.wso2.andes.framing.amqp_0_9.AMQMethodBody_0_9;
import org.wso2.andes.framing.amqp_0_9.MethodDispatcher_0_9;
import org.wso2.org.apache.mina.common.ByteBuffer;

public class QueueDeleteBodyImpl
extends AMQMethodBody_0_9
implements QueueDeleteBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new QueueDeleteBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 50;
    public static final int METHOD_ID = 40;
    private final int _ticket;
    private final AMQShortString _queue;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public QueueDeleteBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._ticket = this.readUnsignedShort(buffer);
        this._queue = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public QueueDeleteBodyImpl(int ticket, AMQShortString queue, boolean ifUnused, boolean ifEmpty, boolean nowait) {
        this._ticket = ticket;
        this._queue = queue;
        byte bitfield0 = 0;
        if (ifUnused) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (ifEmpty) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        if (nowait) {
            bitfield0 = (byte)(bitfield0 | 4);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 50;
    }

    @Override
    public int getMethod() {
        return 40;
    }

    @Override
    public final int getTicket() {
        return this._ticket;
    }

    @Override
    public final AMQShortString getQueue() {
        return this._queue;
    }

    @Override
    public final boolean getIfUnused() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    public final boolean getIfEmpty() {
        return (this._bitfield0 & 2) != 0;
    }

    @Override
    public final boolean getNowait() {
        return (this._bitfield0 & 4) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 3;
        return size += this.getSizeOf(this._queue);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._queue);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchQueueDelete(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[QueueDeleteBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("ifUnused=");
        buf.append(this.getIfUnused());
        buf.append(", ");
        buf.append("ifEmpty=");
        buf.append(this.getIfEmpty());
        buf.append(", ");
        buf.append("nowait=");
        buf.append(this.getNowait());
        buf.append("]");
        return buf.toString();
    }
}

