/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_0_9;

import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.StreamPublishBody;
import org.wso2.andes.framing.amqp_0_9.AMQMethodBody_0_9;
import org.wso2.andes.framing.amqp_0_9.MethodDispatcher_0_9;
import org.wso2.org.apache.mina.common.ByteBuffer;

public class StreamPublishBodyImpl
extends AMQMethodBody_0_9
implements StreamPublishBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new StreamPublishBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 80;
    public static final int METHOD_ID = 40;
    private final int _ticket;
    private final AMQShortString _exchange;
    private final AMQShortString _routingKey;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public StreamPublishBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._ticket = this.readUnsignedShort(buffer);
        this._exchange = this.readAMQShortString(buffer);
        this._routingKey = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public StreamPublishBodyImpl(int ticket, AMQShortString exchange, AMQShortString routingKey, boolean mandatory, boolean immediate) {
        this._ticket = ticket;
        this._exchange = exchange;
        this._routingKey = routingKey;
        byte bitfield0 = 0;
        if (mandatory) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (immediate) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 80;
    }

    @Override
    public int getMethod() {
        return 40;
    }

    @Override
    public final int getTicket() {
        return this._ticket;
    }

    @Override
    public final AMQShortString getExchange() {
        return this._exchange;
    }

    @Override
    public final AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    @Override
    public final boolean getMandatory() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    public final boolean getImmediate() {
        return (this._bitfield0 & 2) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 3;
        size += this.getSizeOf(this._exchange);
        return size += this.getSizeOf(this._routingKey);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._routingKey);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchStreamPublish(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[StreamPublishBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("routingKey=");
        buf.append(this.getRoutingKey());
        buf.append(", ");
        buf.append("mandatory=");
        buf.append(this.getMandatory());
        buf.append(", ");
        buf.append("immediate=");
        buf.append(this.getImmediate());
        buf.append("]");
        return buf.toString();
    }
}

