/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_0_91;

import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.ConnectionOpenBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_0_91.AMQMethodBody_0_91;
import org.wso2.andes.framing.amqp_0_91.MethodDispatcher_0_91;
import org.wso2.org.apache.mina.common.ByteBuffer;

public class ConnectionOpenBodyImpl
extends AMQMethodBody_0_91
implements ConnectionOpenBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new ConnectionOpenBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 40;
    private final AMQShortString _virtualHost;
    private final AMQShortString _capabilities;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ConnectionOpenBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._virtualHost = this.readAMQShortString(buffer);
        this._capabilities = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public ConnectionOpenBodyImpl(AMQShortString virtualHost, AMQShortString capabilities, boolean insist) {
        this._virtualHost = virtualHost;
        this._capabilities = capabilities;
        byte bitfield0 = 0;
        if (insist) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 10;
    }

    @Override
    public int getMethod() {
        return 40;
    }

    @Override
    public final AMQShortString getVirtualHost() {
        return this._virtualHost;
    }

    @Override
    public final AMQShortString getCapabilities() {
        return this._capabilities;
    }

    @Override
    public final boolean getInsist() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 1;
        size += this.getSizeOf(this._virtualHost);
        return size += this.getSizeOf(this._capabilities);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeAMQShortString(buffer, this._virtualHost);
        this.writeAMQShortString(buffer, this._capabilities);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_91)dispatcher).dispatchConnectionOpen(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionOpenBodyImpl: ");
        buf.append("virtualHost=");
        buf.append(this.getVirtualHost());
        buf.append(", ");
        buf.append("capabilities=");
        buf.append(this.getCapabilities());
        buf.append(", ");
        buf.append("insist=");
        buf.append(this.getInsist());
        buf.append("]");
        return buf.toString();
    }
}

