/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.messaging.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wso2.andes.messaging.util.LexError;
import org.wso2.andes.messaging.util.LineInfo;
import org.wso2.andes.messaging.util.Token;

public class Lexer {
    private List<Token.Type> types;
    private Token.Type eof;
    private Pattern rexp;

    public Lexer(List<Token.Type> types, Token.Type eof, Pattern rexp) {
        this.types = types;
        this.eof = eof;
        this.rexp = rexp;
    }

    public List<Token> lex(String st) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        int position = 0;
        Matcher m3 = this.rexp.matcher(st);
        block0: while (position < st.length()) {
            m3.region(position, st.length());
            if (m3.lookingAt()) {
                for (int i = 1; i <= m3.groupCount(); ++i) {
                    String value = m3.group(i);
                    if (value == null) continue;
                    tokens.add(new Token(this.types.get(i - 1), value, st, m3.start(i)));
                    position = m3.end(i);
                    continue block0;
                }
                throw new RuntimeException("no group matched");
            }
            throw new LexError("unrecognized characters line:" + LineInfo.get(st, position));
        }
        tokens.add(new Token(this.eof, null, st, position));
        return tokens;
    }
}

