/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.messaging.util;

import java.util.ArrayList;
import java.util.List;
import org.wso2.andes.messaging.util.ParseError;
import org.wso2.andes.messaging.util.Token;

class Parser {
    private List<Token> tokens;
    private int idx = 0;

    Parser(List<Token> tokens) {
        this.tokens = tokens;
        this.idx = 0;
    }

    Token next() {
        return this.tokens.get(this.idx);
    }

    boolean matches(Token.Type ... types) {
        for (Token.Type t : types) {
            if (this.next().getType() != t) continue;
            return true;
        }
        return false;
    }

    Token eat(Token.Type ... types) {
        if (types.length > 0 && !this.matches(types)) {
            throw new ParseError(this.next(), types);
        }
        Token t = this.next();
        ++this.idx;
        return t;
    }

    List<Token> eat_until(Token.Type ... types) {
        ArrayList<Token> result = new ArrayList<Token>();
        while (!this.matches(types)) {
            result.add(this.eat(new Token.Type[0]));
        }
        return result;
    }
}

