/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.wso2.andes.security.UsernamePasswordCallbackHandler;
import org.wso2.andes.transport.Connection;
import org.wso2.andes.transport.ConnectionDelegate;
import org.wso2.andes.transport.ConnectionException;
import org.wso2.andes.transport.ConnectionHeartbeat;
import org.wso2.andes.transport.ConnectionOpenOk;
import org.wso2.andes.transport.ConnectionRedirect;
import org.wso2.andes.transport.ConnectionSecure;
import org.wso2.andes.transport.ConnectionSettings;
import org.wso2.andes.transport.ConnectionStart;
import org.wso2.andes.transport.ConnectionTune;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.ProtocolHeader;
import org.wso2.andes.transport.ProtocolVersionException;
import org.wso2.andes.transport.util.Logger;

public class ClientDelegate
extends ConnectionDelegate {
    private static final Logger log;
    private static final String KRB5_OID_STR = "1.2.840.113554.1.2.2";
    protected static final Oid KRB5_OID;
    private List<String> clientMechs;
    private ConnectionSettings conSettings;

    public ClientDelegate(ConnectionSettings settings) {
        this.conSettings = settings;
        this.clientMechs = Arrays.asList(settings.getSaslMechs().split(" "));
    }

    @Override
    public void init(Connection conn, ProtocolHeader hdr) {
        if (hdr.getMajor() != 0 || hdr.getMinor() != 10) {
            conn.exception(new ProtocolVersionException(hdr.getMajor(), hdr.getMinor()));
        }
    }

    @Override
    public void connectionStart(Connection conn, ConnectionStart start) {
        HashMap<String, Object> clientProperties = new HashMap<String, Object>();
        if (this.conSettings.getClientProperties() != null) {
            clientProperties.putAll(this.conSettings.getClientProperties());
        }
        clientProperties.put("qpid.session_flow", 1);
        clientProperties.put("qpid.client_pid", this.getPID());
        clientProperties.put("qpid.client_process", System.getProperty("qpid.client_process", "Qpid Java Client"));
        List<Object> brokerMechs = start.getMechanisms();
        if (brokerMechs == null || brokerMechs.isEmpty()) {
            conn.connectionStartOk(clientProperties, null, null, conn.getLocale(), new Option[0]);
            return;
        }
        ArrayList<String> choosenMechs = new ArrayList<String>();
        for (String mech : this.clientMechs) {
            if (!brokerMechs.contains(mech)) continue;
            choosenMechs.add(mech);
        }
        if (choosenMechs.size() == 0) {
            conn.exception(new ConnectionException("The following SASL mechanisms " + this.clientMechs.toString() + " specified by the client are not supported by the broker"));
            return;
        }
        String[] mechs = new String[choosenMechs.size()];
        choosenMechs.toArray(mechs);
        conn.setServerProperties(start.getServerProperties());
        try {
            HashMap<String, String> saslProps = new HashMap<String, String>();
            if (this.conSettings.isUseSASLEncryption()) {
                saslProps.put("javax.security.sasl.qop", "auth-conf");
            }
            UsernamePasswordCallbackHandler handler = new UsernamePasswordCallbackHandler();
            handler.initialise(this.conSettings.getUsername(), this.conSettings.getPassword());
            SaslClient sc = Sasl.createSaslClient(mechs, null, this.conSettings.getSaslProtocol(), this.conSettings.getSaslServerName(), saslProps, handler);
            conn.setSaslClient(sc);
            byte[] response = sc.hasInitialResponse() ? sc.evaluateChallenge(new byte[0]) : null;
            conn.connectionStartOk(clientProperties, sc.getMechanismName(), response, conn.getLocale(), new Option[0]);
        }
        catch (SaslException e) {
            conn.exception(e);
        }
    }

    @Override
    public void connectionSecure(Connection conn, ConnectionSecure secure) {
        SaslClient sc = conn.getSaslClient();
        try {
            byte[] response = sc.evaluateChallenge(secure.getChallenge());
            conn.connectionSecureOk(response, new Option[0]);
        }
        catch (SaslException e) {
            conn.exception(e);
        }
    }

    @Override
    public void connectionTune(Connection conn, ConnectionTune tune) {
        int hb_interval = this.calculateHeartbeatInterval(this.conSettings.getHeartbeatInterval(), tune.getHeartbeatMin(), tune.getHeartbeatMax());
        conn.connectionTuneOk(tune.getChannelMax(), tune.getMaxFrameSize(), hb_interval, new Option[0]);
        conn.setIdleTimeout(hb_interval * 1000 * 2);
        int channelMax = tune.getChannelMax();
        conn.setChannelMax(channelMax == 0 ? 65535 : channelMax);
        conn.connectionOpen(this.conSettings.getVhost(), null, Option.INSIST);
    }

    @Override
    public void connectionOpenOk(Connection conn, ConnectionOpenOk ok) {
        SaslClient sc = conn.getSaslClient();
        if (sc != null) {
            if (sc.getMechanismName().equals("GSSAPI")) {
                String id = this.getKerberosUser();
                if (id != null) {
                    conn.setUserID(id);
                }
            } else if (sc.getMechanismName().equals("EXTERNAL") && conn.getSecurityLayer() != null) {
                conn.setUserID(conn.getSecurityLayer().getUserID());
            }
        }
        if (conn.isConnectionResuming()) {
            conn.setState(Connection.State.RESUMING);
        } else {
            conn.setState(Connection.State.OPEN);
        }
    }

    @Override
    public void connectionRedirect(Connection conn, ConnectionRedirect redir) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectionHeartbeat(Connection conn, ConnectionHeartbeat hearbeat) {
        conn.connectionHeartbeat(new Option[0]);
    }

    private int calculateHeartbeatInterval(int heartbeat, int min2, int max) {
        int i = heartbeat;
        if (i == 0) {
            log.info("Idle timeout is 0 sec. Heartbeats are disabled.", new Object[0]);
            return 0;
        }
        if (i >= min2 && i <= max) {
            return i;
        }
        log.info("The broker does not support the configured connection idle timeout of %s sec, using the brokers max supported value of %s sec instead.", i, max);
        return max;
    }

    private int getPID() {
        RuntimeMXBean rtb = ManagementFactory.getRuntimeMXBean();
        String processName = rtb.getName();
        if (processName != null && processName.indexOf(64) > 0) {
            try {
                return Integer.parseInt(processName.substring(0, processName.indexOf(64)));
            }
            catch (Exception e) {
                log.warn("Unable to get the client PID due to error", e);
                return -1;
            }
        }
        log.warn("Unable to get the client PID due to unsupported format : " + processName, new Object[0]);
        return -1;
    }

    private String getKerberosUser() {
        log.debug("Obtaining userID from kerberos", new Object[0]);
        String service = this.conSettings.getSaslProtocol() + "@" + this.conSettings.getSaslServerName();
        GSSManager manager = GSSManager.getInstance();
        try {
            GSSName acceptorName = manager.createName(service, GSSName.NT_HOSTBASED_SERVICE, KRB5_OID);
            GSSContext secCtx = manager.createContext(acceptorName, KRB5_OID, null, Integer.MAX_VALUE);
            secCtx.initSecContext(new byte[0], 0, 1);
            if (secCtx.getSrcName() != null) {
                return secCtx.getSrcName().toString();
            }
        }
        catch (GSSException e) {
            log.warn("Unable to retrieve userID from Kerberos due to error", e);
        }
        return null;
    }

    static {
        Oid oid;
        log = Logger.get(ClientDelegate.class);
        try {
            oid = new Oid(KRB5_OID_STR);
        }
        catch (GSSException ignore) {
            oid = null;
        }
        KRB5_OID = oid;
    }
}

