/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.wso2.andes.transport.ReplyTo;
import org.wso2.andes.transport.Struct;
import org.wso2.andes.transport.codec.Decoder;
import org.wso2.andes.transport.codec.Encoder;

public final class MessageProperties
extends Struct {
    public static final int TYPE = 1027;
    private short packing_flags = 0;
    private long contentLength;
    private UUID messageId;
    private byte[] correlationId;
    private ReplyTo replyTo;
    private String contentType;
    private String contentEncoding;
    private byte[] userId;
    private byte[] appId;
    private Map<String, Object> applicationHeaders;

    @Override
    public final int getStructType() {
        return 1027;
    }

    @Override
    public final int getSizeWidth() {
        return 4;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    public final boolean hasPayload() {
        return false;
    }

    public final byte getEncodedTrack() {
        return -1;
    }

    public final boolean isConnectionControl() {
        return false;
    }

    public MessageProperties() {
    }

    public MessageProperties(long contentLength, UUID messageId, byte[] correlationId, ReplyTo replyTo, String contentType, String contentEncoding, byte[] userId, byte[] appId, Map<String, Object> applicationHeaders) {
        this.setContentLength(contentLength);
        if (messageId != null) {
            this.setMessageId(messageId);
        }
        if (correlationId != null) {
            this.setCorrelationId(correlationId);
        }
        if (replyTo != null) {
            this.setReplyTo(replyTo);
        }
        if (contentType != null) {
            this.setContentType(contentType);
        }
        if (contentEncoding != null) {
            this.setContentEncoding(contentEncoding);
        }
        if (userId != null) {
            this.setUserId(userId);
        }
        if (appId != null) {
            this.setAppId(appId);
        }
        if (applicationHeaders != null) {
            this.setApplicationHeaders(applicationHeaders);
        }
    }

    public final boolean hasContentLength() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final MessageProperties clearContentLength() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.contentLength = 0L;
        this.dirty = true;
        return this;
    }

    public final long getContentLength() {
        return this.contentLength;
    }

    public final MessageProperties setContentLength(long value) {
        this.contentLength = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.dirty = true;
        return this;
    }

    public final MessageProperties contentLength(long value) {
        return this.setContentLength(value);
    }

    public final boolean hasMessageId() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final MessageProperties clearMessageId() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.messageId = null;
        this.dirty = true;
        return this;
    }

    public final UUID getMessageId() {
        return this.messageId;
    }

    public final MessageProperties setMessageId(UUID value) {
        this.messageId = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.dirty = true;
        return this;
    }

    public final MessageProperties messageId(UUID value) {
        return this.setMessageId(value);
    }

    public final boolean hasCorrelationId() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final MessageProperties clearCorrelationId() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.correlationId = null;
        this.dirty = true;
        return this;
    }

    public final byte[] getCorrelationId() {
        return this.correlationId;
    }

    public final MessageProperties setCorrelationId(byte[] value) {
        this.correlationId = value;
        this.packing_flags = (short)(this.packing_flags | 0x400);
        this.dirty = true;
        return this;
    }

    public final MessageProperties correlationId(byte[] value) {
        return this.setCorrelationId(value);
    }

    public final boolean hasReplyTo() {
        return (this.packing_flags & 0x800) != 0;
    }

    public final MessageProperties clearReplyTo() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFF7FF);
        this.replyTo = null;
        this.dirty = true;
        return this;
    }

    public final ReplyTo getReplyTo() {
        return this.replyTo;
    }

    public final MessageProperties setReplyTo(ReplyTo value) {
        this.replyTo = value;
        this.packing_flags = (short)(this.packing_flags | 0x800);
        this.dirty = true;
        return this;
    }

    public final MessageProperties replyTo(ReplyTo value) {
        return this.setReplyTo(value);
    }

    public final boolean hasContentType() {
        return (this.packing_flags & 0x1000) != 0;
    }

    public final MessageProperties clearContentType() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFEFFF);
        this.contentType = null;
        this.dirty = true;
        return this;
    }

    public final String getContentType() {
        return this.contentType;
    }

    public final MessageProperties setContentType(String value) {
        this.contentType = value;
        this.packing_flags = (short)(this.packing_flags | 0x1000);
        this.dirty = true;
        return this;
    }

    public final MessageProperties contentType(String value) {
        return this.setContentType(value);
    }

    public final boolean hasContentEncoding() {
        return (this.packing_flags & 0x2000) != 0;
    }

    public final MessageProperties clearContentEncoding() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFDFFF);
        this.contentEncoding = null;
        this.dirty = true;
        return this;
    }

    public final String getContentEncoding() {
        return this.contentEncoding;
    }

    public final MessageProperties setContentEncoding(String value) {
        this.contentEncoding = value;
        this.packing_flags = (short)(this.packing_flags | 0x2000);
        this.dirty = true;
        return this;
    }

    public final MessageProperties contentEncoding(String value) {
        return this.setContentEncoding(value);
    }

    public final boolean hasUserId() {
        return (this.packing_flags & 0x4000) != 0;
    }

    public final MessageProperties clearUserId() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFBFFF);
        this.userId = null;
        this.dirty = true;
        return this;
    }

    public final byte[] getUserId() {
        return this.userId;
    }

    public final MessageProperties setUserId(byte[] value) {
        this.userId = value;
        this.packing_flags = (short)(this.packing_flags | 0x4000);
        this.dirty = true;
        return this;
    }

    public final MessageProperties userId(byte[] value) {
        return this.setUserId(value);
    }

    public final boolean hasAppId() {
        return (this.packing_flags & 0x8000) != 0;
    }

    public final MessageProperties clearAppId() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFF7FFF);
        this.appId = null;
        this.dirty = true;
        return this;
    }

    public final byte[] getAppId() {
        return this.appId;
    }

    public final MessageProperties setAppId(byte[] value) {
        this.appId = value;
        this.packing_flags = (short)(this.packing_flags | 0x8000);
        this.dirty = true;
        return this;
    }

    public final MessageProperties appId(byte[] value) {
        return this.setAppId(value);
    }

    public final boolean hasApplicationHeaders() {
        return (this.packing_flags & 1) != 0;
    }

    public final MessageProperties clearApplicationHeaders() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFFFE);
        this.applicationHeaders = null;
        this.dirty = true;
        return this;
    }

    public final Map<String, Object> getApplicationHeaders() {
        return this.applicationHeaders;
    }

    public final MessageProperties setApplicationHeaders(Map<String, Object> value) {
        this.applicationHeaders = value;
        this.packing_flags = (short)(this.packing_flags | 1);
        this.dirty = true;
        return this;
    }

    public final MessageProperties applicationHeaders(Map<String, Object> value) {
        return this.setApplicationHeaders(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeUint64(this.contentLength);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeUuid(this.messageId);
        }
        if ((this.packing_flags & 0x400) != 0) {
            enc.writeVbin16(this.correlationId);
        }
        if ((this.packing_flags & 0x800) != 0) {
            enc.writeStruct(-3, this.replyTo);
        }
        if ((this.packing_flags & 0x1000) != 0) {
            enc.writeStr8(this.contentType);
        }
        if ((this.packing_flags & 0x2000) != 0) {
            enc.writeStr8(this.contentEncoding);
        }
        if ((this.packing_flags & 0x4000) != 0) {
            enc.writeVbin16(this.userId);
        }
        if ((this.packing_flags & 0x8000) != 0) {
            enc.writeVbin16(this.appId);
        }
        if ((this.packing_flags & 1) != 0) {
            enc.writeMap(this.applicationHeaders);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.contentLength = dec.readUint64();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.messageId = dec.readUuid();
        }
        if ((this.packing_flags & 0x400) != 0) {
            this.correlationId = dec.readVbin16();
        }
        if ((this.packing_flags & 0x800) != 0) {
            this.replyTo = (ReplyTo)dec.readStruct(-3);
        }
        if ((this.packing_flags & 0x1000) != 0) {
            this.contentType = dec.readStr8();
        }
        if ((this.packing_flags & 0x2000) != 0) {
            this.contentEncoding = dec.readStr8();
        }
        if ((this.packing_flags & 0x4000) != 0) {
            this.userId = dec.readVbin16();
        }
        if ((this.packing_flags & 0x8000) != 0) {
            this.appId = dec.readVbin16();
        }
        if ((this.packing_flags & 1) != 0) {
            this.applicationHeaders = dec.readMap();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("contentLength", this.getContentLength());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("messageId", this.getMessageId());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("correlationId", this.getCorrelationId());
        }
        if ((this.packing_flags & 0x800) != 0) {
            result.put("replyTo", this.getReplyTo());
        }
        if ((this.packing_flags & 0x1000) != 0) {
            result.put("contentType", this.getContentType());
        }
        if ((this.packing_flags & 0x2000) != 0) {
            result.put("contentEncoding", this.getContentEncoding());
        }
        if ((this.packing_flags & 0x4000) != 0) {
            result.put("userId", this.getUserId());
        }
        if ((this.packing_flags & 0x8000) != 0) {
            result.put("appId", this.getAppId());
        }
        if ((this.packing_flags & 1) != 0) {
            result.put("applicationHeaders", this.getApplicationHeaders());
        }
        return result;
    }
}

