/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.wso2.andes.transport.Acquired;
import org.wso2.andes.transport.DtxCommit;
import org.wso2.andes.transport.DtxEnd;
import org.wso2.andes.transport.DtxForget;
import org.wso2.andes.transport.DtxGetTimeout;
import org.wso2.andes.transport.DtxPrepare;
import org.wso2.andes.transport.DtxRecover;
import org.wso2.andes.transport.DtxRollback;
import org.wso2.andes.transport.DtxSelect;
import org.wso2.andes.transport.DtxSetTimeout;
import org.wso2.andes.transport.DtxStart;
import org.wso2.andes.transport.ExchangeBind;
import org.wso2.andes.transport.ExchangeBound;
import org.wso2.andes.transport.ExchangeBoundResult;
import org.wso2.andes.transport.ExchangeDeclare;
import org.wso2.andes.transport.ExchangeDelete;
import org.wso2.andes.transport.ExchangeQuery;
import org.wso2.andes.transport.ExchangeQueryResult;
import org.wso2.andes.transport.ExchangeUnbind;
import org.wso2.andes.transport.ExecutionErrorCode;
import org.wso2.andes.transport.ExecutionException;
import org.wso2.andes.transport.ExecutionResult;
import org.wso2.andes.transport.ExecutionSync;
import org.wso2.andes.transport.Future;
import org.wso2.andes.transport.GetTimeoutResult;
import org.wso2.andes.transport.Header;
import org.wso2.andes.transport.MessageAccept;
import org.wso2.andes.transport.MessageAcceptMode;
import org.wso2.andes.transport.MessageAcquire;
import org.wso2.andes.transport.MessageAcquireMode;
import org.wso2.andes.transport.MessageCancel;
import org.wso2.andes.transport.MessageCreditUnit;
import org.wso2.andes.transport.MessageFlow;
import org.wso2.andes.transport.MessageFlowMode;
import org.wso2.andes.transport.MessageFlush;
import org.wso2.andes.transport.MessageReject;
import org.wso2.andes.transport.MessageRejectCode;
import org.wso2.andes.transport.MessageRelease;
import org.wso2.andes.transport.MessageResume;
import org.wso2.andes.transport.MessageResumeResult;
import org.wso2.andes.transport.MessageSetFlowMode;
import org.wso2.andes.transport.MessageStop;
import org.wso2.andes.transport.MessageSubscribe;
import org.wso2.andes.transport.MessageTransfer;
import org.wso2.andes.transport.Method;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.QueueDeclare;
import org.wso2.andes.transport.QueueDelete;
import org.wso2.andes.transport.QueuePurge;
import org.wso2.andes.transport.QueueQuery;
import org.wso2.andes.transport.QueueQueryResult;
import org.wso2.andes.transport.RangeSet;
import org.wso2.andes.transport.RecoverResult;
import org.wso2.andes.transport.SessionAttach;
import org.wso2.andes.transport.SessionAttached;
import org.wso2.andes.transport.SessionCommandPoint;
import org.wso2.andes.transport.SessionCompleted;
import org.wso2.andes.transport.SessionConfirmed;
import org.wso2.andes.transport.SessionDetach;
import org.wso2.andes.transport.SessionDetachCode;
import org.wso2.andes.transport.SessionDetached;
import org.wso2.andes.transport.SessionExpected;
import org.wso2.andes.transport.SessionFlush;
import org.wso2.andes.transport.SessionGap;
import org.wso2.andes.transport.SessionKnownCompleted;
import org.wso2.andes.transport.SessionRequestTimeout;
import org.wso2.andes.transport.SessionTimeout;
import org.wso2.andes.transport.Struct;
import org.wso2.andes.transport.TxCommit;
import org.wso2.andes.transport.TxRollback;
import org.wso2.andes.transport.TxSelect;
import org.wso2.andes.transport.XaResult;
import org.wso2.andes.transport.Xid;

public abstract class SessionInvoker {
    final void sessionAttach(byte[] name, Option ... _options) {
        this.invoke(new SessionAttach(name, _options));
    }

    final void sessionAttached(byte[] name, Option ... _options) {
        this.invoke(new SessionAttached(name, _options));
    }

    final void sessionDetach(byte[] name, Option ... _options) {
        this.invoke(new SessionDetach(name, _options));
    }

    final void sessionDetached(byte[] name, SessionDetachCode code, Option ... _options) {
        this.invoke(new SessionDetached(name, code, _options));
    }

    final void sessionRequestTimeout(long timeout, Option ... _options) {
        this.invoke(new SessionRequestTimeout(timeout, _options));
    }

    final void sessionTimeout(long timeout, Option ... _options) {
        this.invoke(new SessionTimeout(timeout, _options));
    }

    final void sessionCommandPoint(int commandId, long commandOffset, Option ... _options) {
        this.invoke(new SessionCommandPoint(commandId, commandOffset, _options));
    }

    final void sessionExpected(RangeSet commands, List<Object> fragments, Option ... _options) {
        this.invoke(new SessionExpected(commands, fragments, _options));
    }

    final void sessionConfirmed(RangeSet commands, List<Object> fragments, Option ... _options) {
        this.invoke(new SessionConfirmed(commands, fragments, _options));
    }

    final void sessionCompleted(RangeSet commands, Option ... _options) {
        this.invoke(new SessionCompleted(commands, _options));
    }

    final void sessionKnownCompleted(RangeSet commands, Option ... _options) {
        this.invoke(new SessionKnownCompleted(commands, _options));
    }

    final void sessionFlush(Option ... _options) {
        this.invoke(new SessionFlush(_options));
    }

    final void sessionGap(RangeSet commands, Option ... _options) {
        this.invoke(new SessionGap(commands, _options));
    }

    public final void executionSync(Option ... _options) {
        this.invoke(new ExecutionSync(_options));
    }

    public final void executionResult(int commandId, Struct value, Option ... _options) {
        this.invoke(new ExecutionResult(commandId, value, _options));
    }

    public final void executionException(ExecutionErrorCode errorCode, int commandId, short classCode, short commandCode, short fieldIndex, String description, Map<String, Object> errorInfo, Option ... _options) {
        this.invoke(new ExecutionException(errorCode, commandId, classCode, commandCode, fieldIndex, description, errorInfo, _options));
    }

    public final void messageTransfer(String destination, MessageAcceptMode acceptMode, MessageAcquireMode acquireMode, Header header, ByteBuffer body, Option ... _options) {
        this.invoke(new MessageTransfer(destination, acceptMode, acquireMode, header, body, _options));
    }

    public final void messageAccept(RangeSet transfers, Option ... _options) {
        this.invoke(new MessageAccept(transfers, _options));
    }

    public final void messageReject(RangeSet transfers, MessageRejectCode code, String text, Option ... _options) {
        this.invoke(new MessageReject(transfers, code, text, _options));
    }

    public final void messageRelease(RangeSet transfers, Option ... _options) {
        this.invoke(new MessageRelease(transfers, _options));
    }

    public final Future<Acquired> messageAcquire(RangeSet transfers, Option ... _options) {
        return this.invoke(new MessageAcquire(transfers, _options), Acquired.class);
    }

    public final Future<MessageResumeResult> messageResume(String destination, String resumeId, Option ... _options) {
        return this.invoke(new MessageResume(destination, resumeId, _options), MessageResumeResult.class);
    }

    public final void messageSubscribe(String queue, String destination, MessageAcceptMode acceptMode, MessageAcquireMode acquireMode, String resumeId, long resumeTtl, Map<String, Object> arguments, Option ... _options) {
        this.invoke(new MessageSubscribe(queue, destination, acceptMode, acquireMode, resumeId, resumeTtl, arguments, _options));
    }

    public final void messageCancel(String destination, Option ... _options) {
        this.invoke(new MessageCancel(destination, _options));
    }

    public final void messageSetFlowMode(String destination, MessageFlowMode flowMode, Option ... _options) {
        this.invoke(new MessageSetFlowMode(destination, flowMode, _options));
    }

    public final void messageFlow(String destination, MessageCreditUnit unit, long value, Option ... _options) {
        this.invoke(new MessageFlow(destination, unit, value, _options));
    }

    public final void messageFlush(String destination, Option ... _options) {
        this.invoke(new MessageFlush(destination, _options));
    }

    public final void messageStop(String destination, Option ... _options) {
        this.invoke(new MessageStop(destination, _options));
    }

    public final void txSelect(Option ... _options) {
        this.invoke(new TxSelect(_options));
    }

    public final void txCommit(Option ... _options) {
        this.invoke(new TxCommit(_options));
    }

    public final void txRollback(Option ... _options) {
        this.invoke(new TxRollback(_options));
    }

    public final void dtxSelect(Option ... _options) {
        this.invoke(new DtxSelect(_options));
    }

    public final Future<XaResult> dtxStart(Xid xid, Option ... _options) {
        return this.invoke(new DtxStart(xid, _options), XaResult.class);
    }

    public final Future<XaResult> dtxEnd(Xid xid, Option ... _options) {
        return this.invoke(new DtxEnd(xid, _options), XaResult.class);
    }

    public final Future<XaResult> dtxCommit(Xid xid, Option ... _options) {
        return this.invoke(new DtxCommit(xid, _options), XaResult.class);
    }

    public final void dtxForget(Xid xid, Option ... _options) {
        this.invoke(new DtxForget(xid, _options));
    }

    public final Future<GetTimeoutResult> dtxGetTimeout(Xid xid, Option ... _options) {
        return this.invoke(new DtxGetTimeout(xid, _options), GetTimeoutResult.class);
    }

    public final Future<XaResult> dtxPrepare(Xid xid, Option ... _options) {
        return this.invoke(new DtxPrepare(xid, _options), XaResult.class);
    }

    public final Future<RecoverResult> dtxRecover(Option ... _options) {
        return this.invoke(new DtxRecover(_options), RecoverResult.class);
    }

    public final Future<XaResult> dtxRollback(Xid xid, Option ... _options) {
        return this.invoke(new DtxRollback(xid, _options), XaResult.class);
    }

    public final void dtxSetTimeout(Xid xid, long timeout, Option ... _options) {
        this.invoke(new DtxSetTimeout(xid, timeout, _options));
    }

    public final void exchangeDeclare(String exchange, String type, String alternateExchange, Map<String, Object> arguments, Option ... _options) {
        this.invoke(new ExchangeDeclare(exchange, type, alternateExchange, arguments, _options));
    }

    public final void exchangeDelete(String exchange, Option ... _options) {
        this.invoke(new ExchangeDelete(exchange, _options));
    }

    public final Future<ExchangeQueryResult> exchangeQuery(String name, Option ... _options) {
        return this.invoke(new ExchangeQuery(name, _options), ExchangeQueryResult.class);
    }

    public final void exchangeBind(String queue, String exchange, String bindingKey, Map<String, Object> arguments, Option ... _options) {
        this.invoke(new ExchangeBind(queue, exchange, bindingKey, arguments, _options));
    }

    public final void exchangeUnbind(String queue, String exchange, String bindingKey, Option ... _options) {
        this.invoke(new ExchangeUnbind(queue, exchange, bindingKey, _options));
    }

    public final Future<ExchangeBoundResult> exchangeBound(String exchange, String queue, String bindingKey, Map<String, Object> arguments, Option ... _options) {
        return this.invoke(new ExchangeBound(exchange, queue, bindingKey, arguments, _options), ExchangeBoundResult.class);
    }

    public final void queueDeclare(String queue, String alternateExchange, Map<String, Object> arguments, Option ... _options) {
        this.invoke(new QueueDeclare(queue, alternateExchange, arguments, _options));
    }

    public final void queueDelete(String queue, Option ... _options) {
        this.invoke(new QueueDelete(queue, _options));
    }

    public final void queuePurge(String queue, Option ... _options) {
        this.invoke(new QueuePurge(queue, _options));
    }

    public final Future<QueueQueryResult> queueQuery(String queue, Option ... _options) {
        return this.invoke(new QueueQuery(queue, _options), QueueQueryResult.class);
    }

    protected abstract void invoke(Method var1);

    protected abstract <T> Future<T> invoke(Method var1, Class<T> var2);
}

