/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.url;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.exchange.ExchangeDefaults;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.url.AMQBindingURL;

public class BindingURLParser {
    private static final char PROPERTY_EQUALS_CHAR = '=';
    private static final char PROPERTY_SEPARATOR_CHAR = '&';
    private static final char ALTERNATIVE_PROPERTY_SEPARATOR_CHAR = ',';
    private static final char FORWARD_SLASH_CHAR = '/';
    private static final char QUESTION_MARK_CHAR = '?';
    private static final char SINGLE_QUOTE_CHAR = '\'';
    private static final char COLON_CHAR = ':';
    private static final char END_OF_URL_MARKER_CHAR = '%';
    private static final Logger _logger = LoggerFactory.getLogger(BindingURLParser.class);
    private char[] _url;
    private AMQBindingURL _bindingURL;
    private BindingURLParserState _currentParserState;
    private String _error;
    private int _index = 0;
    private String _currentPropName;
    private Map<String, Object> _options;

    public synchronized void parse(String url, AMQBindingURL bindingURL) throws URISyntaxException {
        this._url = (url + '%').toCharArray();
        this._bindingURL = bindingURL;
        BindingURLParserState prevState = this._currentParserState = BindingURLParserState.BINDING_URL_START;
        this._index = 0;
        this._currentPropName = null;
        this._error = null;
        this._options = new HashMap<String, Object>();
        try {
            while (this._currentParserState != BindingURLParserState.ERROR && this._currentParserState != BindingURLParserState.BINDING_URL_END) {
                prevState = this._currentParserState;
                this._currentParserState = this.next();
            }
            if (this._currentParserState == BindingURLParserState.ERROR) {
                this._error = "Invalid URL format [current_state = " + (Object)((Object)prevState) + ", details parsed so far " + this._bindingURL + " ] error at (" + this._index + ") due to " + this._error;
                _logger.debug(this._error);
                URISyntaxException ex = new URISyntaxException(this.markErrorLocation(), "Error occured while parsing URL", this._index);
                throw ex;
            }
            this.processOptions();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this._error = "Invalid URL format [current_state = " + (Object)((Object)prevState) + ", details parsed so far " + this._bindingURL + " ] error at (" + this._index + ")";
            URISyntaxException ex = new URISyntaxException(this.markErrorLocation(), "Error occured while parsing URL", this._index);
            ex.initCause(e);
            throw ex;
        }
    }

    private BindingURLParserState next() {
        switch (this._currentParserState) {
            case BINDING_URL_START: {
                return this.extractExchangeClass();
            }
            case COLON_CHAR: {
                ++this._index;
                return BindingURLParserState.DOUBLE_SEP;
            }
            case DOUBLE_SEP: {
                this._index += 2;
                return BindingURLParserState.EXCHANGE_NAME;
            }
            case EXCHANGE_NAME: {
                return this.extractExchangeName();
            }
            case EXCHANGE_SEPERATOR_CHAR: {
                ++this._index;
                return BindingURLParserState.DESTINATION;
            }
            case DESTINATION: {
                return this.extractDestination();
            }
            case DESTINATION_SEPERATOR_CHAR: {
                ++this._index;
                return BindingURLParserState.QUEUE_NAME;
            }
            case QUEUE_NAME: {
                return this.extractQueueName();
            }
            case QUESTION_MARK_CHAR: {
                ++this._index;
                return BindingURLParserState.PROPERTY_NAME;
            }
            case PROPERTY_NAME: {
                return this.extractPropertyName();
            }
            case PROPERTY_EQUALS: {
                ++this._index;
                return BindingURLParserState.START_PROPERTY_VALUE;
            }
            case START_PROPERTY_VALUE: {
                ++this._index;
                return BindingURLParserState.PROPERTY_VALUE;
            }
            case PROPERTY_VALUE: {
                return this.extractPropertyValue();
            }
            case END_PROPERTY_VALUE: {
                ++this._index;
                return this.checkEndOfURL();
            }
            case PROPERTY_SEPARATOR: {
                ++this._index;
                return BindingURLParserState.PROPERTY_NAME;
            }
        }
        return BindingURLParserState.ERROR;
    }

    private BindingURLParserState extractExchangeClass() {
        char nextChar = this._url[this._index];
        StringBuilder builder = new StringBuilder();
        while (nextChar != ':' && nextChar != '?' && nextChar != '%') {
            builder.append(nextChar);
            ++this._index;
            nextChar = this._url[this._index];
        }
        if (nextChar == ':') {
            this._bindingURL.setExchangeClass(builder.toString());
            return BindingURLParserState.COLON_CHAR;
        }
        if (nextChar == '?') {
            this._bindingURL.setExchangeClass(ExchangeDefaults.DIRECT_EXCHANGE_CLASS.asString());
            this._bindingURL.setExchangeName("");
            this._bindingURL.setQueueName(builder.toString());
            return BindingURLParserState.QUESTION_MARK_CHAR;
        }
        this._bindingURL.setExchangeClass(ExchangeDefaults.DIRECT_EXCHANGE_CLASS.asString());
        this._bindingURL.setExchangeName("");
        this._bindingURL.setQueueName(builder.toString());
        return BindingURLParserState.BINDING_URL_END;
    }

    private BindingURLParserState extractExchangeName() {
        char nextChar = this._url[this._index];
        StringBuilder builder = new StringBuilder();
        while (nextChar != '/') {
            builder.append(nextChar);
            ++this._index;
            nextChar = this._url[this._index];
        }
        this._bindingURL.setExchangeName(builder.toString());
        return BindingURLParserState.EXCHANGE_SEPERATOR_CHAR;
    }

    private BindingURLParserState extractDestination() {
        char nextChar = this._url[this._index];
        if (nextChar == '?') {
            return BindingURLParserState.QUESTION_MARK_CHAR;
        }
        StringBuilder builder = new StringBuilder();
        while (nextChar != '/' && nextChar != '?') {
            builder.append(nextChar);
            ++this._index;
            nextChar = this._url[this._index];
        }
        if (nextChar == '/') {
            this._bindingURL.setDestinationName(builder.toString());
            return BindingURLParserState.DESTINATION_SEPERATOR_CHAR;
        }
        this._bindingURL.setQueueName(builder.toString());
        return BindingURLParserState.QUESTION_MARK_CHAR;
    }

    private BindingURLParserState extractQueueName() {
        char nextChar = this._url[this._index];
        StringBuilder builder = new StringBuilder();
        while (nextChar != '?' && nextChar != '%') {
            builder.append(nextChar);
            nextChar = this._url[++this._index];
        }
        this._bindingURL.setQueueName(builder.toString());
        if (nextChar == '?') {
            return BindingURLParserState.QUESTION_MARK_CHAR;
        }
        return BindingURLParserState.BINDING_URL_END;
    }

    private BindingURLParserState extractPropertyName() {
        StringBuilder builder = new StringBuilder();
        char next = this._url[this._index];
        while (next != '=') {
            builder.append(next);
            next = this._url[++this._index];
        }
        this._currentPropName = builder.toString();
        if (this._currentPropName.trim().equals("")) {
            this._error = "Property name cannot be empty";
            return BindingURLParserState.ERROR;
        }
        return BindingURLParserState.PROPERTY_EQUALS;
    }

    private BindingURLParserState extractPropertyValue() {
        StringBuilder builder = new StringBuilder();
        char next = this._url[this._index];
        while (next != '\'') {
            builder.append(next);
            next = this._url[++this._index];
        }
        String propValue = builder.toString();
        if (propValue.trim().equals("")) {
            this._error = "Property values cannot be empty";
            return BindingURLParserState.ERROR;
        }
        if (this._options.containsKey(this._currentPropName)) {
            Object obj = this._options.get(this._currentPropName);
            if (obj instanceof List) {
                List list = (List)obj;
                list.add(propValue);
            } else {
                ArrayList<String> list = new ArrayList<String>();
                list.add((String)obj);
                list.add(propValue);
                this._options.put(this._currentPropName, list);
            }
        } else {
            this._options.put(this._currentPropName, propValue);
        }
        return BindingURLParserState.END_PROPERTY_VALUE;
    }

    private BindingURLParserState checkEndOfURL() {
        char nextChar = this._url[this._index];
        if (nextChar == '%') {
            return BindingURLParserState.BINDING_URL_END;
        }
        if (nextChar == '&' || nextChar == ',') {
            return BindingURLParserState.PROPERTY_SEPARATOR;
        }
        return BindingURLParserState.ERROR;
    }

    private String markErrorLocation() {
        String tmp = String.valueOf(this._url);
        return tmp.substring(0, this._index) + "^" + tmp.substring(this._index + 1 > tmp.length() - 1 ? tmp.length() - 1 : this._index + 1, tmp.length() - 1);
    }

    private void processOptions() throws URISyntaxException {
        if (this._options.containsKey("bindingkey") && this._options.get("bindingkey") != null) {
            Object obj = this._options.get("bindingkey");
            if (obj instanceof String) {
                AMQShortString[] bindingKeys = new AMQShortString[]{new AMQShortString((String)obj)};
                this._bindingURL.setBindingKeys(bindingKeys);
            } else {
                List list = (List)obj;
                AMQShortString[] bindingKeys = new AMQShortString[list.size()];
                int i = 0;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    bindingKeys[i] = new AMQShortString((String)it.next());
                    ++i;
                }
                this._bindingURL.setBindingKeys(bindingKeys);
            }
        }
        for (String key : this._options.keySet()) {
            if (!(this._options.get(key) instanceof String)) continue;
            this._bindingURL.setOption(key, (String)this._options.get(key));
        }
        if (this._options.containsKey("bindingkey") && this._options.containsKey("routingkey")) {
            throw new URISyntaxException(String.valueOf(this._url), "It is illegal to specify both a routingKey and a bindingKey in the same URL", -1);
        }
        if (this._bindingURL.getExchangeClass().equals(ExchangeDefaults.TOPIC_EXCHANGE_CLASS)) {
            String queueName = null;
            if (Boolean.parseBoolean(this._bindingURL.getOption("durable"))) {
                if (this._bindingURL.containsOption("clientid") && this._bindingURL.containsOption("subscription")) {
                    queueName = this._bindingURL.getOption("clientid") + ":" + this._bindingURL.getOption("subscription");
                } else {
                    throw new URISyntaxException(String.valueOf(this._url), "Durable subscription must have values for clientid and subscription", -1);
                }
            }
            this._bindingURL.setQueueName(queueName);
        }
    }

    public static void main(String[] args) {
        String[] urls = new String[]{"topic://amq.topic//myTopic?routingkey='stocks.#'", "topic://amq.topic/message_queue?bindingkey='usa.*'&bindingkey='control',exclusive='true'", "topic://amq.topic//?bindingKey='usa.*',bindingkey='control',exclusive='true'", "direct://amq.direct/dummyDest/myQueue?routingkey='abc.*'", "exchange.Class://exchangeName/Destination/Queue", "exchangeClass://exchangeName/Destination/?option='value',option2='value2'", "IBMPerfQueue1?durable='true'", "exchangeClass://exchangeName/Destination/?bindingkey='key1',bindingkey='key2'", "exchangeClass://exchangeName/Destination/?bindingkey='key1'&routingkey='key2'"};
        try {
            BindingURLParser parser = new BindingURLParser();
            for (String url : urls) {
                System.out.println("URL " + url);
                AMQBindingURL bindingURL = new AMQBindingURL(url);
                parser.parse(url, bindingURL);
                System.out.println("\nX " + bindingURL.toString() + " \n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static enum BindingURLParserState {
        BINDING_URL_START,
        EXCHANGE_CLASS,
        COLON_CHAR,
        DOUBLE_SEP,
        EXCHANGE_NAME,
        EXCHANGE_SEPERATOR_CHAR,
        DESTINATION,
        DESTINATION_SEPERATOR_CHAR,
        QUEUE_NAME,
        QUESTION_MARK_CHAR,
        PROPERTY_NAME,
        PROPERTY_EQUALS,
        START_PROPERTY_VALUE,
        PROPERTY_VALUE,
        END_PROPERTY_VALUE,
        PROPERTY_SEPARATOR,
        BINDING_URL_END,
        ERROR;

    }
}

