/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.gateway.analytics.collectors.impl;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.common.gateway.analytics.collectors.AnalyticsDataProvider;
import org.wso2.carbon.apimgt.common.gateway.analytics.collectors.impl.AbstractRequestDataCollector;
import org.wso2.carbon.apimgt.common.gateway.analytics.collectors.impl.SuccessRequestDataCollector;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.dto.Application;

public abstract class CommonRequestDataCollector
extends AbstractRequestDataCollector {
    private static final Log log = LogFactory.getLog(SuccessRequestDataCollector.class);

    public CommonRequestDataCollector(AnalyticsDataProvider provider) {
        super(provider);
    }

    public Application getAnonymousApp() {
        Application application = new Application();
        application.setApplicationId("anonymous");
        application.setApplicationName("anonymous");
        application.setKeyType("anonymous");
        application.setApplicationOwner("anonymous");
        return application;
    }

    public Application getUnknownApp() {
        Application application = new Application();
        application.setApplicationId("UNKNOWN");
        application.setApplicationName("UNKNOWN");
        application.setKeyType("UNKNOWN");
        application.setApplicationOwner("UNKNOWN");
        return application;
    }

    public static String getTimeInISO(long time) {
        OffsetDateTime offsetDateTime = OffsetDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneOffset.UTC.normalized());
        return offsetDateTime.toString();
    }
}

