/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.gateway.analytics.collectors.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.common.gateway.analytics.collectors.AnalyticsDataProvider;
import org.wso2.carbon.apimgt.common.gateway.analytics.collectors.RequestDataCollector;
import org.wso2.carbon.apimgt.common.gateway.analytics.collectors.impl.CommonRequestDataCollector;
import org.wso2.carbon.apimgt.common.gateway.analytics.exceptions.AnalyticsException;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.RequestDataPublisher;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.dto.API;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.dto.Application;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.dto.Event;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.dto.Latencies;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.dto.MetaInfo;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.dto.Operation;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.dto.Target;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.impl.SuccessRequestDataPublisher;

public class SuccessRequestDataCollector
extends CommonRequestDataCollector
implements RequestDataCollector {
    private static final Log log = LogFactory.getLog(SuccessRequestDataCollector.class);
    private RequestDataPublisher processor;
    private AnalyticsDataProvider provider;

    public SuccessRequestDataCollector(AnalyticsDataProvider provider, RequestDataPublisher processor) {
        super(provider);
        this.processor = processor;
        this.provider = provider;
    }

    public SuccessRequestDataCollector(AnalyticsDataProvider provider) {
        this(provider, new SuccessRequestDataPublisher());
    }

    @Override
    public void collectData() throws AnalyticsException {
        log.debug("Handling success analytics types");
        long requestInTime = this.provider.getRequestTime();
        String offsetDateTime = SuccessRequestDataCollector.getTimeInISO(requestInTime);
        Event event = new Event();
        API api = this.provider.getApi();
        Operation operation = this.provider.getOperation();
        Target target = this.provider.getTarget();
        Application application = this.provider.isAnonymous() ? this.getAnonymousApp() : this.provider.getApplication();
        Latencies latencies = this.provider.getLatencies();
        MetaInfo metaInfo = this.provider.getMetaInfo();
        String userAgent = this.provider.getUserAgentHeader();
        String userIp = this.provider.getEndUserIP();
        if (userIp == null) {
            userIp = "UNKNOWN";
        }
        event.setApi(api);
        event.setOperation(operation);
        event.setTarget(target);
        event.setApplication(application);
        event.setLatencies(latencies);
        event.setProxyResponseCode(this.provider.getProxyResponseCode());
        event.setRequestTimestamp(offsetDateTime);
        event.setMetaInfo(metaInfo);
        event.setUserAgentHeader(userAgent);
        event.setUserIp(userIp);
        this.processor.publish(event);
    }
}

