/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.gateway.analytics.publishers.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.am.analytics.publisher.exception.MetricReportingException;
import org.wso2.am.analytics.publisher.reporter.CounterMetric;
import org.wso2.am.analytics.publisher.reporter.MetricEventBuilder;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.RequestDataPublisher;
import org.wso2.carbon.apimgt.common.gateway.analytics.publishers.dto.Event;

public abstract class AbstractRequestDataPublisher
implements RequestDataPublisher {
    private static final Log log = LogFactory.getLog(AbstractRequestDataPublisher.class);
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};

    @Override
    public void publish(Event analyticsEvent) {
        CounterMetric counterMetric = this.getCounterMetric();
        if (counterMetric == null) {
            log.error("counterMetric cannot be null.");
            return;
        }
        Map<String, Object> dataMap = OBJECT_MAPPER.convertValue((Object)analyticsEvent, MAP_TYPE_REFERENCE);
        MetricEventBuilder builder = counterMetric.getEventBuilder();
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            try {
                builder.addAttribute(entry.getKey(), entry.getValue());
            }
            catch (MetricReportingException e) {
                log.error("Error adding data to the event stream.", e);
                return;
            }
        }
        try {
            counterMetric.incrementCount(builder);
        }
        catch (MetricReportingException e) {
            log.error("Error occurred when publishing event.", e);
        }
    }
}

