/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.gateway.exception;

import java.util.Arrays;
import org.wso2.carbon.apimgt.common.gateway.exception.ErrorHandler;
import org.wso2.carbon.apimgt.common.gateway.exception.ErrorItem;

public enum ExceptionCodes implements ErrorHandler
{
    INTERNAL_ERROR(900967L, "General Error", 500, "Server Error Occurred");

    private final long errorCode;
    private final String errorMessage;
    private final int httpStatusCode;
    private final String errorDescription;
    private boolean stackTrace = false;

    private ExceptionCodes(long errorCode, String msg, int httpErrorCode, String errorDescription, boolean stackTrace) {
        this.errorCode = errorCode;
        this.errorMessage = msg;
        this.httpStatusCode = httpErrorCode;
        this.errorDescription = errorDescription;
        this.stackTrace = stackTrace;
    }

    private ExceptionCodes(long errorCode, String msg, int httpErrorCode, String errorDescription) {
        this.errorCode = errorCode;
        this.errorMessage = msg;
        this.httpStatusCode = httpErrorCode;
        this.errorDescription = errorDescription;
    }

    @Override
    public long getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Override
    public String getErrorDescription() {
        return this.errorDescription;
    }

    @Override
    public boolean printStackTrace() {
        return this.stackTrace;
    }

    public static ErrorHandler from(ErrorHandler errorHandler, String ... params) {
        String message = errorHandler.getErrorMessage();
        String description = errorHandler.getErrorDescription();
        if (params != null && params.length > 0) {
            int placesToFormatInMessage = message.length() - message.replace("%", "").length();
            int placesToFormatInDescription = description.length() - description.replace("%", "").length();
            Object[] part1 = Arrays.copyOfRange(params, 0, placesToFormatInMessage);
            Object[] part2 = Arrays.copyOfRange(params, placesToFormatInMessage, placesToFormatInMessage + placesToFormatInDescription);
            if (placesToFormatInMessage > 0) {
                message = String.format(message, part1);
            }
            if (placesToFormatInDescription > 0) {
                description = String.format(description, part2);
            }
        }
        return new ErrorItem(message, description, errorHandler.getErrorCode(), errorHandler.getHttpStatusCode(), errorHandler.printStackTrace());
    }
}

