/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.api.config;

import java.util.ArrayList;
import java.util.List;
import org.wso2.micro.gateway.enforcer.api.config.ResourceConfig;

public class APIConfig {
    private String name;
    private String version;
    private String basePath;
    private String apiLifeCycleState;
    private List<String> securitySchemas = new ArrayList<String>();
    private String tier = "Unlimited";
    private List<ResourceConfig> resources = new ArrayList<ResourceConfig>();

    private APIConfig() {
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getApiLifeCycleState() {
        return this.apiLifeCycleState;
    }

    public List<String> getSecuritySchemas() {
        return this.securitySchemas;
    }

    public String getTier() {
        return this.tier;
    }

    public List<ResourceConfig> getResources() {
        return this.resources;
    }

    public static class Builder {
        private String name;
        private String version;
        private String basePath;
        private String apiLifeCycleState;
        private List<String> securitySchemas = new ArrayList<String>();
        private String tier = "Unlimited";
        private List<ResourceConfig> resources = new ArrayList<ResourceConfig>();

        public Builder(String name) {
            this.name = name;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder apiLifeCycleState(String apiLifeCycleState) {
            this.apiLifeCycleState = apiLifeCycleState;
            return this;
        }

        public Builder resources(List<ResourceConfig> resources) {
            this.resources = resources;
            return this;
        }

        public APIConfig build() {
            APIConfig apiConfig = new APIConfig();
            apiConfig.name = this.name;
            apiConfig.basePath = this.basePath;
            apiConfig.version = this.version;
            apiConfig.apiLifeCycleState = this.apiLifeCycleState;
            apiConfig.resources = this.resources;
            return apiConfig;
        }
    }
}

