/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.common;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.wso2.carbon.apimgt.common.gateway.dto.JWTValidationInfo;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.config.dto.CacheDto;
import org.wso2.micro.gateway.enforcer.security.jwt.SignedJWTInfo;

public class CacheProvider {
    private static LoadingCache<String, SignedJWTInfo> gatewaySignedJWTParseCache;
    private static LoadingCache<String, String> gatewayTokenCache;
    private static LoadingCache<String, JWTValidationInfo> gatewayKeyCache;
    private static LoadingCache<String, Boolean> invalidTokenCache;
    private static LoadingCache<String, JWTValidationInfo> gatewayJWTTokenCache;
    private static boolean cacheEnabled;

    public static void init() {
        CacheDto cacheDto = ConfigHolder.getInstance().getConfig().getCacheDto();
        cacheEnabled = cacheDto.isEnabled();
        int maxSize = cacheDto.getMaximumSize();
        int expiryTime = cacheDto.getExpiryTime();
        gatewaySignedJWTParseCache = CacheProvider.initCache(maxSize, expiryTime);
        gatewayTokenCache = CacheProvider.initCache(maxSize, expiryTime);
        gatewayKeyCache = CacheProvider.initCache(maxSize, expiryTime);
        invalidTokenCache = CacheProvider.initCache(maxSize, expiryTime);
        gatewayJWTTokenCache = CacheProvider.initCache(maxSize, expiryTime);
    }

    private static LoadingCache initCache(int maxSize, int expiryTime) {
        return CacheBuilder.newBuilder().maximumSize(maxSize).expireAfterAccess(expiryTime, TimeUnit.MINUTES).build(new CacheLoader<String, String>(){

            @Override
            public String load(String s2) throws Exception {
                return "Token is not available in cache";
            }
        });
    }

    public static LoadingCache getGatewaySignedJWTParseCache() {
        return gatewaySignedJWTParseCache;
    }

    public static LoadingCache getGatewayTokenCache() {
        return gatewayTokenCache;
    }

    public static LoadingCache getGatewayKeyCache() {
        return gatewayKeyCache;
    }

    public static LoadingCache getInvalidTokenCache() {
        return invalidTokenCache;
    }

    public static LoadingCache getGatewayJWTTokenCache() {
        return gatewayJWTTokenCache;
    }

    static {
        cacheEnabled = true;
    }
}

