/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.config;

import org.apache.commons.lang3.StringUtils;

public class EnvVarConfig {
    private static final String TRUSTED_CA_CERTS_PATH = "TRUSTED_CA_CERTS_PATH";
    private static final String ADAPTER_HOST_NAME = "ADAPTER_HOST_NAME";
    private static final String ENFORCER_PRIVATE_KEY_PATH = "ENFORCER_PRIVATE_KEY_PATH";
    private static final String ENFORCER_PUBLIC_CERT_PATH = "ENFORCER_PUBLIC_CERT_PATH";
    private static final String ADAPTER_HOST = "ADAPTER_HOST";
    private static final String ADAPTER_XDS_PORT = "ADAPTER_XDS_PORT";
    private static final String ENFORCER_LABEL = "ENFORCER_LABEL";
    public static final String XDS_MAX_MSG_SIZE = "XDS_MAX_MSG_SIZE";
    private static final String DEFAULT_TRUSTED_CA_CERTS_PATH = "/home/wso2/security/truststore";
    private static final String DEFAULT_ADAPTER_HOST_NAME = "adapter";
    private static final String DEFAULT_ENFORCER_PRIVATE_KEY_PATH = "/home/wso2/security/keystore/mg.key";
    private static final String DEFAULT_ENFORCER_PUBLIC_CERT_PATH = "/home/wso2/security/keystore/mg.pem";
    private static final String DEFAULT_ADAPTER_HOST = "adapter";
    private static final String DEFAULT_ADAPTER_XDS_PORT = "18000";
    private static final String DEFAULT_ENFORCER_LABEL = "enforcer";
    public static final String DEFAULT_XDS_MAX_MSG_SIZE = "4194304";
    private String trustedAdapterCertsPath = this.retrieveEnvVarOrDefault("TRUSTED_CA_CERTS_PATH", "/home/wso2/security/truststore");
    private String enforcerPrivateKeyPath = this.retrieveEnvVarOrDefault("ENFORCER_PRIVATE_KEY_PATH", "/home/wso2/security/keystore/mg.key");
    private String enforcerPublicKeyPath = this.retrieveEnvVarOrDefault("ENFORCER_PUBLIC_CERT_PATH", "/home/wso2/security/keystore/mg.pem");
    private String adapterHost;
    private String enforcerLabel = this.retrieveEnvVarOrDefault("ENFORCER_LABEL", "enforcer");
    private String adapterXdsPort;
    private String adapterHostName;
    private final String xdsMaxMsgSize;

    public EnvVarConfig() {
        this.adapterHost = this.retrieveEnvVarOrDefault(ADAPTER_HOST, "adapter");
        this.adapterHostName = this.retrieveEnvVarOrDefault(ADAPTER_HOST_NAME, "adapter");
        this.adapterXdsPort = this.retrieveEnvVarOrDefault(ADAPTER_XDS_PORT, DEFAULT_ADAPTER_XDS_PORT);
        this.xdsMaxMsgSize = this.retrieveEnvVarOrDefault(XDS_MAX_MSG_SIZE, DEFAULT_XDS_MAX_MSG_SIZE);
    }

    private String retrieveEnvVarOrDefault(String variable, String defaultValue) {
        if (StringUtils.isEmpty(System.getenv(variable))) {
            return defaultValue;
        }
        return System.getenv(variable);
    }

    public String getTrustedAdapterCertsPath() {
        return this.trustedAdapterCertsPath;
    }

    public String getEnforcerPrivateKeyPath() {
        return this.enforcerPrivateKeyPath;
    }

    public String getEnforcerPublicKeyPath() {
        return this.enforcerPublicKeyPath;
    }

    public String getAdapterHost() {
        return this.adapterHost;
    }

    public String getEnforcerLabel() {
        return this.enforcerLabel;
    }

    public String getAdapterXdsPort() {
        return this.adapterXdsPort;
    }

    public String getAdapterHostName() {
        return this.adapterHostName;
    }

    public String getXdsMaxMsgSize() {
        return this.xdsMaxMsgSize;
    }
}

