/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.constants;

public class APISecurityConstants {
    public static final String API_AUTH_FAILURE_HANDLER = "_auth_failure_handler_";
    public static final int API_AUTH_GENERAL_ERROR = 900900;
    public static final String API_AUTH_GENERAL_ERROR_MESSAGE = "Unclassified Authentication Failure";
    public static final int API_AUTH_INVALID_CREDENTIALS = 900901;
    public static final String API_AUTH_INVALID_CREDENTIALS_MESSAGE = "Invalid Credentials";
    public static final String API_AUTH_INVALID_CREDENTIALS_DESCRIPTION = "Make sure you have provided the correct security credentials";
    public static final int API_AUTH_MISSING_CREDENTIALS = 900902;
    public static final String API_AUTH_MISSING_CREDENTIALS_MESSAGE = "Missing Credentials";
    public static final String API_AUTH_MISSING_CREDENTIALS_DESCRIPTION = "Make sure your API invocation call has a header: ";
    public static final int API_AUTH_ACCESS_TOKEN_EXPIRED = 900903;
    public static final String API_AUTH_ACCESS_TOKEN_EXPIRED_MESSAGE = "Access Token Expired";
    public static final String API_AUTH_ACCESS_TOKEN_EXPIRED_DESCRIPTION = "Renew the access token and try again";
    public static final int API_AUTH_ACCESS_TOKEN_INACTIVE = 900904;
    public static final String API_AUTH_ACCESS_TOKEN_INACTIVE_MESSAGE = "Access Token Inactive";
    public static final String API_AUTH_ACCESS_TOKEN_INACTIVE_DESCRIPTION = "Generate a new access token and try again";
    public static final int API_AUTH_INCORRECT_ACCESS_TOKEN_TYPE = 900905;
    public static final String API_AUTH_INCORRECT_ACCESS_TOKEN_TYPE_MESSAGE = "Incorrect Access Token Type is provided";
    public static final int API_AUTH_INCORRECT_API_RESOURCE = 900906;
    public static final String API_AUTH_INCORRECT_API_RESOURCE_MESSAGE = "No matching resource found in the API for the given request";
    public static final String API_AUTH_INCORRECT_API_RESOURCE_DESCRIPTION = "Check the API documentation and add a proper REST resource path to the invocation URL";
    public static final int API_BLOCKED = 900907;
    public static final String API_BLOCKED_MESSAGE = "The requested API is temporarily blocked";
    public static final int API_AUTH_FORBIDDEN = 900908;
    public static final String API_AUTH_FORBIDDEN_MESSAGE = "Resource forbidden ";
    public static final int SUBSCRIPTION_INACTIVE = 900909;
    public static final String SUBSCRIPTION_INACTIVE_MESSAGE = "The subscription to the API is inactive";
    public static final int INVALID_SCOPE = 900910;
    public static final String INVALID_SCOPE_MESSAGE = "The access token does not allow you to access the requested resource";
    public static final int API_AUTH_MISSING_OPEN_API_DEF = 900911;
    public static final String API_AUTH_MISSING_OPEN_API_DEF_ERROR_MESSAGE = "Internal Server Error";
    public static final String DESCRIPTION_SEPARATOR = ". ";
    public static final String API_SECURITY_NS = "http://wso2.org/apimanager/security";
    public static final String API_SECURITY_NS_PREFIX = "ams";
    public static final int DEFAULT_MAX_VALID_KEYS = 250;
    public static final int DEFAULT_MAX_INVALID_KEYS = 100;

    public static final String getAuthenticationFailureMessage(int errorCode) {
        String errorMessage;
        switch (errorCode) {
            case 900903: {
                errorMessage = API_AUTH_ACCESS_TOKEN_EXPIRED_MESSAGE;
                break;
            }
            case 900904: {
                errorMessage = API_AUTH_ACCESS_TOKEN_INACTIVE_MESSAGE;
                break;
            }
            case 900900: {
                errorMessage = API_AUTH_GENERAL_ERROR_MESSAGE;
                break;
            }
            case 900911: {
                errorMessage = API_AUTH_MISSING_OPEN_API_DEF_ERROR_MESSAGE;
                break;
            }
            case 900901: {
                errorMessage = API_AUTH_INVALID_CREDENTIALS_MESSAGE;
                break;
            }
            case 900902: {
                errorMessage = API_AUTH_MISSING_CREDENTIALS_MESSAGE;
                break;
            }
            case 900906: {
                errorMessage = API_AUTH_INCORRECT_API_RESOURCE_MESSAGE;
                break;
            }
            case 900905: {
                errorMessage = API_AUTH_INCORRECT_ACCESS_TOKEN_TYPE_MESSAGE;
                break;
            }
            case 900907: {
                errorMessage = API_BLOCKED_MESSAGE;
                break;
            }
            case 900908: {
                errorMessage = API_AUTH_FORBIDDEN_MESSAGE;
                break;
            }
            case 900909: {
                errorMessage = SUBSCRIPTION_INACTIVE_MESSAGE;
                break;
            }
            case 900910: {
                errorMessage = INVALID_SCOPE_MESSAGE;
                break;
            }
            default: {
                errorMessage = API_AUTH_GENERAL_ERROR_MESSAGE;
            }
        }
        return errorMessage;
    }

    public static String getFailureMessageDetailDescription(int errorCode, String errorMessage) {
        Object errorDescription = errorMessage;
        switch (errorCode) {
            case 900906: {
                errorDescription = (String)errorDescription + ". Check the API documentation and add a proper REST resource path to the invocation URL";
                break;
            }
            case 900904: {
                errorDescription = (String)errorDescription + ". Generate a new access token and try again";
                break;
            }
            case 900902: {
                errorDescription = (String)errorDescription + ". Make sure your API invocation call has a header: ";
                break;
            }
            case 900903: {
                errorDescription = (String)errorDescription + ". Renew the access token and try again";
                break;
            }
            case 900901: {
                errorDescription = (String)errorDescription + ". Make sure you have provided the correct security credentials";
                break;
            }
        }
        return errorDescription;
    }
}

