/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.cors;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.micro.gateway.enforcer.Filter;
import org.wso2.micro.gateway.enforcer.api.RequestContext;
import org.wso2.micro.gateway.enforcer.api.config.APIConfig;
import org.wso2.micro.gateway.enforcer.api.config.ResourceConfig;

public class CorsFilter
implements Filter {
    private static final Logger logger = LogManager.getLogger(CorsFilter.class);

    @Override
    public void init(APIConfig apiConfig) {
    }

    @Override
    public boolean handleRequest(RequestContext requestContext) {
        logger.debug("Cors Filter (enforcer) is applied.");
        if (requestContext.getRequestMethod().contains("OPTIONS")) {
            StringBuilder allowedMethodsBuilder = new StringBuilder("OPTIONS");
            for (ResourceConfig resourceConfig : requestContext.getMathedAPI().getAPIConfig().getResources()) {
                if (resourceConfig.getMethod() == ResourceConfig.HttpMethods.OPTIONS) {
                    logger.debug("OPTIONS method is listed under the resource. Hence OPTIONS request willbe responded from the upstream");
                    return true;
                }
                allowedMethodsBuilder.append(", ").append(resourceConfig.getMethod().name());
            }
            requestContext.getProperties().put("status_code", 204);
            requestContext.addResponseHeaders("allow", allowedMethodsBuilder.toString());
            logger.debug("OPTIONS request received for " + requestContext.getMathedAPI().getAPIConfig().getResources().get(0).getPath() + ". Responded with allow header : " + allowedMethodsBuilder.toString());
            return false;
        }
        return true;
    }
}

