/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.discovery;

import com.google.protobuf.Any;
import com.google.rpc.Status;
import io.envoyproxy.envoy.config.core.v3.Node;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.gateway.discovery.service.subscription.ApiListDiscoveryServiceGrpc;
import org.wso2.gateway.discovery.subscription.APIList;
import org.wso2.gateway.discovery.subscription.APIs;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.subscription.SubscriptionDataStoreImpl;
import org.wso2.micro.gateway.enforcer.util.GRPCUtils;

public class ApiListDiscoveryClient {
    private static final Logger logger = LogManager.getLogger(ApiListDiscoveryClient.class);
    private static ApiListDiscoveryClient instance;
    private final ManagedChannel channel;
    private final ApiListDiscoveryServiceGrpc.ApiListDiscoveryServiceStub stub;
    private StreamObserver<DiscoveryRequest> reqObserver;
    private SubscriptionDataStoreImpl subscriptionDataStore = SubscriptionDataStoreImpl.getInstance();
    private DiscoveryResponse latestReceived;
    private DiscoveryResponse latestACKed;
    private final String nodeId;

    private ApiListDiscoveryClient(String host, int port) {
        this.channel = GRPCUtils.createSecuredChannel(logger, host, port);
        this.stub = ApiListDiscoveryServiceGrpc.newStub(this.channel);
        this.nodeId = ConfigHolder.getInstance().getEnvVarConfig().getEnforcerLabel();
        this.latestACKed = DiscoveryResponse.getDefaultInstance();
    }

    public static ApiListDiscoveryClient getInstance() {
        if (instance == null) {
            String sdsHost = ConfigHolder.getInstance().getEnvVarConfig().getAdapterHost();
            int sdsPort = Integer.parseInt(ConfigHolder.getInstance().getEnvVarConfig().getAdapterXdsPort());
            instance = new ApiListDiscoveryClient(sdsHost, sdsPort);
        }
        return instance;
    }

    public void watchApiList() {
        this.reqObserver = this.stub.streamApiList(new StreamObserver<DiscoveryResponse>(){

            @Override
            public void onNext(DiscoveryResponse response) {
                logger.debug("Received Api list discovery response " + response);
                ApiListDiscoveryClient.this.latestReceived = response;
                try {
                    ArrayList<APIs> apiList = new ArrayList<APIs>();
                    for (Any res : response.getResourcesList()) {
                        apiList.addAll(res.unpack(APIList.class).getListList());
                    }
                    ApiListDiscoveryClient.this.subscriptionDataStore.addApis(apiList);
                    ApiListDiscoveryClient.this.ack();
                }
                catch (Exception e) {
                    this.onError(e);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                logger.error("Error occurred during Api list discovery", throwable);
                ApiListDiscoveryClient.this.nack(throwable);
            }

            @Override
            public void onCompleted() {
                logger.info("Completed receiving Api list");
            }
        });
        try {
            DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestACKed.getVersionInfo()).setTypeUrl("type.googleapis.com/wso2.discovery.subscription.APIList").build();
            this.reqObserver.onNext(req);
            logger.debug("Sent Discovery request for type url: type.googleapis.com/wso2.discovery.subscription.APIList");
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred in API list discovery service", (Throwable)e);
            this.reqObserver.onError(e);
        }
    }

    private void ack() {
        DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestReceived.getVersionInfo()).setResponseNonce(this.latestReceived.getNonce()).setTypeUrl("type.googleapis.com/wso2.discovery.subscription.APIList").build();
        this.reqObserver.onNext(req);
        this.latestACKed = this.latestReceived;
    }

    private void nack(Throwable e) {
        if (this.latestReceived == null) {
            return;
        }
        DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestACKed.getVersionInfo()).setResponseNonce(this.latestReceived.getNonce()).setTypeUrl("type.googleapis.com/wso2.discovery.subscription.APIList").setErrorDetail(Status.newBuilder().setMessage(e.getMessage())).build();
        this.reqObserver.onNext(req);
    }
}

