/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.discovery;

import com.google.protobuf.Any;
import com.google.rpc.Status;
import io.envoyproxy.envoy.config.core.v3.Node;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.gateway.discovery.service.subscription.ApplicationPolicyDiscoveryServiceGrpc;
import org.wso2.gateway.discovery.subscription.ApplicationPolicy;
import org.wso2.gateway.discovery.subscription.ApplicationPolicyList;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.subscription.SubscriptionDataStoreImpl;
import org.wso2.micro.gateway.enforcer.util.GRPCUtils;

public class ApplicationPolicyDiscoveryClient {
    private static final Logger logger = LogManager.getLogger(ApplicationPolicyDiscoveryClient.class);
    private static ApplicationPolicyDiscoveryClient instance;
    private final ManagedChannel channel;
    private final ApplicationPolicyDiscoveryServiceGrpc.ApplicationPolicyDiscoveryServiceStub stub;
    private StreamObserver<DiscoveryRequest> reqObserver;
    private SubscriptionDataStoreImpl subscriptionDataStore = SubscriptionDataStoreImpl.getInstance();
    private DiscoveryResponse latestReceived;
    private DiscoveryResponse latestACKed;
    private final String nodeId;

    private ApplicationPolicyDiscoveryClient(String host, int port) {
        this.channel = GRPCUtils.createSecuredChannel(logger, host, port);
        this.stub = ApplicationPolicyDiscoveryServiceGrpc.newStub(this.channel);
        this.nodeId = "commonEnforcerLabel";
        this.latestACKed = DiscoveryResponse.getDefaultInstance();
    }

    public static ApplicationPolicyDiscoveryClient getInstance() {
        if (instance == null) {
            String sdsHost = ConfigHolder.getInstance().getEnvVarConfig().getAdapterHost();
            int sdsPort = Integer.parseInt(ConfigHolder.getInstance().getEnvVarConfig().getAdapterXdsPort());
            instance = new ApplicationPolicyDiscoveryClient(sdsHost, sdsPort);
        }
        return instance;
    }

    public void watchApplicationPolicies() {
        this.reqObserver = this.stub.streamApplicationPolicies(new StreamObserver<DiscoveryResponse>(){

            @Override
            public void onNext(DiscoveryResponse response) {
                logger.debug("Received Application Policy discovery response " + response);
                ApplicationPolicyDiscoveryClient.this.latestReceived = response;
                try {
                    ArrayList<ApplicationPolicy> applicationPolicyList = new ArrayList<ApplicationPolicy>();
                    for (Any res : response.getResourcesList()) {
                        applicationPolicyList.addAll(res.unpack(ApplicationPolicyList.class).getListList());
                    }
                    ApplicationPolicyDiscoveryClient.this.subscriptionDataStore.addApplicationPolicies(applicationPolicyList);
                    ApplicationPolicyDiscoveryClient.this.ack();
                }
                catch (Exception e) {
                    this.onError(e);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                logger.error("Error occurred during Application Policy discovery", throwable);
                ApplicationPolicyDiscoveryClient.this.nack(throwable);
            }

            @Override
            public void onCompleted() {
                logger.info("Completed receiving Application Policy data");
            }
        });
        try {
            DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestACKed.getVersionInfo()).setTypeUrl("type.googleapis.com/wso2.discovery.subscription.ApplicationPolicyList").build();
            this.reqObserver.onNext(req);
            logger.debug("Sent Discovery request for type url: type.googleapis.com/wso2.discovery.subscription.ApplicationPolicyList");
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred in Application Policy discovery service", (Throwable)e);
            this.reqObserver.onError(e);
        }
    }

    private void ack() {
        DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestReceived.getVersionInfo()).setResponseNonce(this.latestReceived.getNonce()).setTypeUrl("type.googleapis.com/wso2.discovery.subscription.ApplicationPolicyList").build();
        this.reqObserver.onNext(req);
        this.latestACKed = this.latestReceived;
    }

    private void nack(Throwable e) {
        if (this.latestReceived == null) {
            return;
        }
        DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestACKed.getVersionInfo()).setResponseNonce(this.latestReceived.getNonce()).setTypeUrl("type.googleapis.com/wso2.discovery.subscription.ApplicationPolicyList").setErrorDetail(Status.newBuilder().setMessage(e.getMessage())).build();
        this.reqObserver.onNext(req);
    }
}

