/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.discovery;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.rpc.Status;
import io.envoyproxy.envoy.config.core.v3.Node;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.gateway.discovery.keymgt.KeyManagerConfig;
import org.wso2.gateway.discovery.service.keymgt.KMDiscoveryServiceGrpc;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.exception.DiscoveryException;
import org.wso2.micro.gateway.enforcer.keymgt.KeyManagerHolder;
import org.wso2.micro.gateway.enforcer.util.GRPCUtils;

public class KeyManagerDiscoveryClient {
    private static KeyManagerDiscoveryClient instance;
    private final ManagedChannel channel;
    private final KMDiscoveryServiceGrpc.KMDiscoveryServiceStub stub;
    private final KMDiscoveryServiceGrpc.KMDiscoveryServiceBlockingStub blockingStub;
    private static final Logger logger;
    private StreamObserver<DiscoveryRequest> reqObserver;
    private static final Logger log;
    private final KeyManagerHolder kmHolder;
    private DiscoveryResponse latestReceived;
    private DiscoveryResponse latestACKed;
    private final String nodeId;

    private KeyManagerDiscoveryClient(String host, int port) {
        this.channel = GRPCUtils.createSecuredChannel(log, host, port);
        this.stub = KMDiscoveryServiceGrpc.newStub(this.channel);
        this.blockingStub = KMDiscoveryServiceGrpc.newBlockingStub(this.channel);
        this.nodeId = "commonEnforcerLabel";
        this.latestACKed = DiscoveryResponse.getDefaultInstance();
        this.kmHolder = KeyManagerHolder.getInstance();
    }

    public static KeyManagerDiscoveryClient getInstance() {
        if (instance == null) {
            String adsHost = ConfigHolder.getInstance().getEnvVarConfig().getAdapterHost();
            int adsPort = Integer.parseInt(ConfigHolder.getInstance().getEnvVarConfig().getAdapterXdsPort());
            instance = new KeyManagerDiscoveryClient(adsHost, adsPort);
        }
        return instance;
    }

    public List<KeyManagerConfig> requestInitKeyManagers() throws DiscoveryException {
        List<KeyManagerConfig> keyManagers;
        DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setTypeUrl("type.googleapis.com/wso2.discovery.keymgt.KeyManagerConfig").build();
        try {
            DiscoveryResponse response = ((KMDiscoveryServiceGrpc.KMDiscoveryServiceBlockingStub)this.blockingStub.withDeadlineAfter(60L, TimeUnit.SECONDS)).fetchKeyManagers(req);
            this.shutdown();
            keyManagers = this.handleResponse(response);
        }
        catch (Exception e) {
            throw new DiscoveryException("Couldn't fetch init KeyManagers", e);
        }
        return keyManagers;
    }

    public void watchKeyManagers() {
        this.reqObserver = this.stub.streamKeyManagers(new StreamObserver<DiscoveryResponse>(){

            @Override
            public void onNext(DiscoveryResponse response) {
                logger.debug("Received KeyManagers discovery response " + response);
                KeyManagerDiscoveryClient.this.latestReceived = response;
                try {
                    List<KeyManagerConfig> keyManagerConfig = KeyManagerDiscoveryClient.this.handleResponse(response);
                    KeyManagerDiscoveryClient.this.kmHolder.populateKMIssuerConfiguration(keyManagerConfig);
                    KeyManagerDiscoveryClient.this.ack();
                }
                catch (Exception e) {
                    this.onError(e);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                logger.error("Error occurred during Key Manager discovery", throwable);
                KeyManagerDiscoveryClient.this.nack(throwable);
            }

            @Override
            public void onCompleted() {
                logger.info("Completed receiving APIs");
            }
        });
        try {
            DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestACKed.getVersionInfo()).setTypeUrl("type.googleapis.com/wso2.discovery.keymgt.KeyManagerConfig").build();
            this.reqObserver.onNext(req);
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred in API discovery service", (Throwable)e);
            this.reqObserver.onError(e);
        }
    }

    private void ack() {
        DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestReceived.getVersionInfo()).setResponseNonce(this.latestReceived.getNonce()).setTypeUrl("type.googleapis.com/wso2.discovery.keymgt.KeyManagerConfig").build();
        this.reqObserver.onNext(req);
        this.latestACKed = this.latestReceived;
    }

    private void nack(Throwable e) {
        if (this.latestReceived == null) {
            return;
        }
        DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestACKed.getVersionInfo()).setResponseNonce(this.latestReceived.getNonce()).setTypeUrl("type.googleapis.com/wso2.discovery.keymgt.KeyManagerConfig").setErrorDetail(Status.newBuilder().setMessage(e.getMessage())).build();
        this.reqObserver.onNext(req);
    }

    private List<KeyManagerConfig> handleResponse(DiscoveryResponse response) throws InvalidProtocolBufferException {
        ArrayList<KeyManagerConfig> keyManagers = new ArrayList<KeyManagerConfig>();
        for (Any res : response.getResourcesList()) {
            keyManagers.add(res.unpack(KeyManagerConfig.class));
        }
        return keyManagers;
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    static {
        logger = LogManager.getLogger(KeyManagerDiscoveryClient.class);
        log = LogManager.getLogger(KeyManagerDiscoveryClient.class);
    }
}

