/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.discovery;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.rpc.Status;
import io.envoyproxy.envoy.config.core.v3.Node;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.gateway.discovery.keymgt.RevokedToken;
import org.wso2.gateway.discovery.service.keymgt.RevokedTokenDiscoveryServiceGrpc;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.security.jwt.validator.RevokedJWTDataHolder;
import org.wso2.micro.gateway.enforcer.util.GRPCUtils;

public class RevokedTokenDiscoveryClient {
    private static RevokedTokenDiscoveryClient instance;
    private final ManagedChannel channel;
    private final RevokedTokenDiscoveryServiceGrpc.RevokedTokenDiscoveryServiceStub stub;
    private final RevokedTokenDiscoveryServiceGrpc.RevokedTokenDiscoveryServiceBlockingStub blockingStub;
    private static final Logger logger;
    private final RevokedJWTDataHolder revokedJWTDataHolder;
    private StreamObserver<DiscoveryRequest> reqObserver;
    private static final Logger log;
    private DiscoveryResponse latestReceived;
    private DiscoveryResponse latestACKed;
    private final String nodeId;

    private RevokedTokenDiscoveryClient(String host, int port) {
        this.channel = GRPCUtils.createSecuredChannel(log, host, port);
        this.revokedJWTDataHolder = RevokedJWTDataHolder.getInstance();
        this.stub = RevokedTokenDiscoveryServiceGrpc.newStub(this.channel);
        this.blockingStub = RevokedTokenDiscoveryServiceGrpc.newBlockingStub(this.channel);
        this.nodeId = "commonEnforcerLabel";
        this.latestACKed = DiscoveryResponse.getDefaultInstance();
    }

    public static RevokedTokenDiscoveryClient getInstance() {
        if (instance == null) {
            String adsHost = ConfigHolder.getInstance().getEnvVarConfig().getAdapterHost();
            int adsPort = Integer.parseInt(ConfigHolder.getInstance().getEnvVarConfig().getAdapterXdsPort());
            instance = new RevokedTokenDiscoveryClient(adsHost, adsPort);
        }
        return instance;
    }

    public void watchRevokedTokens() {
        int maxSize = Integer.parseInt(ConfigHolder.getInstance().getEnvVarConfig().getXdsMaxMsgSize());
        this.reqObserver = ((RevokedTokenDiscoveryServiceGrpc.RevokedTokenDiscoveryServiceStub)this.stub.withMaxInboundMessageSize(maxSize)).streamTokens(new StreamObserver<DiscoveryResponse>(){

            @Override
            public void onNext(DiscoveryResponse response) {
                logger.debug("Received revoked tokens response " + response);
                RevokedTokenDiscoveryClient.this.latestReceived = response;
                try {
                    List<RevokedToken> tokens = RevokedTokenDiscoveryClient.this.handleResponse(response);
                    RevokedTokenDiscoveryClient.this.handleRevokedTokens(tokens);
                    RevokedTokenDiscoveryClient.this.ack();
                }
                catch (Exception e) {
                    logger.info(e);
                    this.onError(e);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                logger.error("Error occurred during revoked token discovery", throwable);
                RevokedTokenDiscoveryClient.this.nack(throwable);
            }

            @Override
            public void onCompleted() {
                logger.info("Completed receiving revoke tokens");
            }
        });
        try {
            DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestACKed.getVersionInfo()).setTypeUrl("type.googleapis.com/wso2.discovery.keymgt.RevokedToken").build();
            this.reqObserver.onNext(req);
            logger.debug("Sent Discovery request for type url: type.googleapis.com/wso2.discovery.keymgt.RevokedToken");
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred in revoked token discovery service", (Throwable)e);
            this.reqObserver.onError(e);
        }
    }

    private void ack() {
        DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestReceived.getVersionInfo()).setResponseNonce(this.latestReceived.getNonce()).setTypeUrl("type.googleapis.com/wso2.discovery.keymgt.RevokedToken").build();
        this.reqObserver.onNext(req);
        this.latestACKed = this.latestReceived;
    }

    private void nack(Throwable e) {
        if (this.latestReceived == null) {
            return;
        }
        DiscoveryRequest req = DiscoveryRequest.newBuilder().setNode(Node.newBuilder().setId(this.nodeId).build()).setVersionInfo(this.latestACKed.getVersionInfo()).setResponseNonce(this.latestReceived.getNonce()).setTypeUrl("type.googleapis.com/wso2.discovery.keymgt.RevokedToken").setErrorDetail(Status.newBuilder().setMessage(e.getMessage())).build();
        this.reqObserver.onNext(req);
    }

    private void handleRevokedTokens(List<RevokedToken> tokens) {
        for (RevokedToken revokedToken : tokens) {
            this.revokedJWTDataHolder.addRevokedJWTToMap(revokedToken.getJti(), revokedToken.getExpirytime());
        }
    }

    private List<RevokedToken> handleResponse(DiscoveryResponse response) throws InvalidProtocolBufferException {
        ArrayList<RevokedToken> apis = new ArrayList<RevokedToken>();
        for (Any res : response.getResourcesList()) {
            apis.add(res.unpack(RevokedToken.class));
        }
        return apis;
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    static {
        logger = LogManager.getLogger(RevokedTokenDiscoveryClient.class);
        log = LogManager.getLogger(RevokedTokenDiscoveryClient.class);
    }
}

