/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.filters;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.wso2.micro.gateway.enforcer.Filter;
import org.wso2.micro.gateway.enforcer.api.RequestContext;
import org.wso2.micro.gateway.enforcer.api.config.APIConfig;
import org.wso2.micro.gateway.enforcer.api.config.ResourceConfig;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.security.AuthenticationContext;
import org.wso2.micro.gateway.enforcer.throttle.ThrottleAgent;
import org.wso2.micro.gateway.enforcer.throttle.ThrottleDataHolder;
import org.wso2.micro.gateway.enforcer.util.FilterUtils;

public class ThrottleFilter
implements Filter {
    private static final Logger log = LogManager.getLogger(ThrottleFilter.class);
    private final boolean isGlobalThrottlingEnabled;
    private final ThrottleDataHolder dataHolder = ThrottleDataHolder.getInstance();

    public ThrottleFilter() {
        this.isGlobalThrottlingEnabled = ConfigHolder.getInstance().getConfig().getThrottleConfig().isGlobalPublishingEnabled();
    }

    @Override
    public void init(APIConfig apiConfig) {
    }

    @Override
    public boolean handleRequest(RequestContext requestContext) {
        log.debug("Throttle filter received the request");
        if (this.doThrottle(requestContext)) {
            return false;
        }
        ThrottleAgent.publishNonThrottledEvent(this.getThrottleEventMap(requestContext));
        return true;
    }

    private boolean doThrottle(RequestContext reqContext) {
        AuthenticationContext authContext = reqContext.getAuthenticationContext();
        if (reqContext.getAuthenticationContext() != null) {
            String appThrottleKey;
            boolean isAppThrottled;
            log.debug("Found AuthenticationContext for the request");
            APIConfig api = reqContext.getMathedAPI().getAPIConfig();
            String apiContext = api.getBasePath();
            String apiVersion = api.getVersion();
            String appId = authContext.getApplicationId();
            String apiTier = authContext.getApiTier();
            String apiThrottleKey = this.getApiThrottleKey(apiContext, apiVersion);
            String resourceTier = this.getResourceTier(reqContext.getMatchedResourcePath());
            String resourceThrottleKey = this.getResourceThrottleKey(reqContext, apiContext, apiVersion);
            String subTier = authContext.getTier();
            String appTier = authContext.getApplicationTier();
            if (this.isAPILevelThrottled(apiThrottleKey, apiTier)) {
                FilterUtils.setThrottleErrorToContext(reqContext, 900800, "Message throttled out", "You have exceeded your quota");
                reqContext.getProperties().put("THROTTLED_OUT_REASON", "API_LIMIT_EXCEEDED");
                return true;
            }
            if (this.isResourceLevelThrottled(resourceThrottleKey, resourceTier)) {
                FilterUtils.setThrottleErrorToContext(reqContext, 900802, "Message throttled out", "You have exceeded your quota");
                reqContext.getProperties().put("THROTTLED_OUT_REASON", "RESOURCE_LIMIT_EXCEEDED");
                return true;
            }
            String subThrottleKey = this.getSubscriptionThrottleKey(appId, apiContext, apiVersion);
            boolean isSubscriptionThrottled = this.isSubscriptionLevelThrottled(subThrottleKey, subTier);
            if (isSubscriptionThrottled) {
                if (authContext.isStopOnQuotaReach()) {
                    log.debug("Setting subscription throttle out response");
                    FilterUtils.setThrottleErrorToContext(reqContext, 900804, "Message throttled out", "You have exceeded your quota");
                    reqContext.getProperties().put("THROTTLED_OUT_REASON", "SUBSCRIPTION_LIMIT_EXCEEDED");
                    return true;
                }
                log.debug("Proceeding since stopOnQuotaReach is false");
            }
            if (isAppThrottled = this.isAppLevelThrottled(appThrottleKey = appId + ":" + authContext.getUsername(), appTier)) {
                log.debug("Setting application throttle out response");
                FilterUtils.setThrottleErrorToContext(reqContext, 900803, "Message throttled out", "You have exceeded your quota");
                reqContext.getProperties().put("THROTTLED_OUT_REASON", "APPLICATION_LIMIT_EXCEEDED");
                return true;
            }
        }
        return false;
    }

    private boolean isSubscriptionLevelThrottled(String throttleKey, String tier) {
        boolean isThrottled = this.dataHolder.isThrottled(throttleKey);
        log.debug("Subscription Level throttle decision is {} for key:tier {}:{}", (Object)isThrottled, (Object)throttleKey, (Object)tier);
        return isThrottled;
    }

    private boolean isAppLevelThrottled(String throttleKey, String tier) {
        boolean isThrottled = this.dataHolder.isThrottled(throttleKey);
        log.debug("Application Level throttle decision is {} for key:tier {}:{}", (Object)isThrottled, (Object)throttleKey, (Object)tier);
        return isThrottled;
    }

    private boolean isAPILevelThrottled(String throttleKey, String tier) {
        log.debug("Checking if request is throttled at API level for tier: {}", (Object)tier);
        if ("Unlimited".equals(tier)) {
            return false;
        }
        if (this.isGlobalThrottlingEnabled) {
            throttleKey = (String)throttleKey + "_default";
            boolean isThrottled = this.dataHolder.isThrottled((String)throttleKey);
            log.debug("API Level throttle decision: {}", (Object)isThrottled);
            return isThrottled;
        }
        return false;
    }

    private boolean isResourceLevelThrottled(String throttleKey, String tier) {
        log.debug("Checking if request is throttled at resource level for tier: " + tier);
        if ("Unlimited".equals(tier)) {
            return false;
        }
        if (this.isGlobalThrottlingEnabled) {
            throttleKey = (String)throttleKey + "_default";
            boolean isThrottled = this.dataHolder.isThrottled((String)throttleKey);
            log.debug("Resource Level throttle decision: {}", (Object)isThrottled);
            return isThrottled;
        }
        return false;
    }

    private Map<String, String> getThrottleEventMap(RequestContext requestContext) {
        Object resourceKey;
        String resourceTier;
        AuthenticationContext authenticationContext = requestContext.getAuthenticationContext();
        HashMap<String, String> throttleEvent = new HashMap<String, String>();
        String basePath = requestContext.getMathedAPI().getAPIConfig().getBasePath();
        String apiVersion = requestContext.getMathedAPI().getAPIConfig().getVersion();
        String apiContext = basePath + ":" + apiVersion;
        String apiName = requestContext.getMathedAPI().getAPIConfig().getName();
        String tenantDomain = FilterUtils.getTenantDomainFromRequestURL(apiContext);
        if (tenantDomain == null) {
            tenantDomain = "carbon.super";
        }
        if (!"Unlimited".equals(authenticationContext.getApiTier()) && authenticationContext.getApiTier() != null && !authenticationContext.getApiTier().isBlank()) {
            resourceTier = authenticationContext.getApiTier();
            resourceKey = apiContext;
        } else {
            resourceTier = this.getResourceTier(requestContext.getMatchedResourcePath());
            resourceKey = this.getResourceThrottleKey(requestContext, apiContext, apiVersion);
        }
        throttleEvent.put("messageID", requestContext.getRequestID());
        throttleEvent.put("appKey", authenticationContext.getApplicationId() + ":" + authenticationContext.getUsername());
        throttleEvent.put("appTier", authenticationContext.getApplicationTier());
        throttleEvent.put("apiKey", apiContext);
        throttleEvent.put("apiTier", authenticationContext.getApiTier());
        throttleEvent.put("subscriptionKey", authenticationContext.getApplicationId() + ":" + apiContext);
        throttleEvent.put("subscriptionTier", authenticationContext.getTier());
        throttleEvent.put("resourceKey", (String)resourceKey);
        throttleEvent.put("resourceTier", resourceTier);
        throttleEvent.put("userId", authenticationContext.getUsername());
        throttleEvent.put("apiContext", basePath);
        throttleEvent.put("apiVersion", apiVersion);
        throttleEvent.put("appTenant", authenticationContext.getSubscriberTenantDomain());
        throttleEvent.put("apiTenant", tenantDomain);
        throttleEvent.put("appId", authenticationContext.getApplicationId());
        throttleEvent.put("apiName", apiName);
        throttleEvent.put("properties", this.getProperties(requestContext).toString());
        return throttleEvent;
    }

    private String getResourceThrottleKey(RequestContext requestContext, String apiContext, String apiVersion) {
        Object resourceThrottleKey = apiContext;
        if (!apiVersion.isBlank()) {
            resourceThrottleKey = (String)resourceThrottleKey + "/" + apiVersion;
        }
        resourceThrottleKey = (String)resourceThrottleKey + requestContext.getMatchedResourcePath().getPath() + ":" + requestContext.getRequestMethod();
        return resourceThrottleKey;
    }

    private String getApiThrottleKey(String apiContext, String apiVersion) {
        Object apiThrottleKey = apiContext;
        if (!apiVersion.isBlank()) {
            apiThrottleKey = (String)apiThrottleKey + ":" + apiVersion;
        }
        return apiThrottleKey;
    }

    private String getSubscriptionThrottleKey(String appId, String apiContext, String apiVersion) {
        String subThrottleKey = appId + ":" + apiContext;
        if (!apiVersion.isBlank()) {
            subThrottleKey = subThrottleKey + ":" + apiVersion;
        }
        return subThrottleKey;
    }

    private String getResourceTier(ResourceConfig resourceConfig) {
        if (!resourceConfig.getTier().isBlank()) {
            return resourceConfig.getTier();
        }
        return "Unlimited";
    }

    private JSONObject getProperties(RequestContext requestContext) {
        String remoteIP = requestContext.getAddress();
        JSONObject jsonObMap = new JSONObject();
        if (remoteIP != null && remoteIP.length() > 0) {
            try {
                InetAddress address = InetAddress.getByName(remoteIP);
                if (address instanceof Inet4Address) {
                    jsonObMap.put("ip", FilterUtils.ipToLong(remoteIP));
                    jsonObMap.put("ipv6", 0);
                } else if (address instanceof Inet6Address) {
                    jsonObMap.put("ipv6", FilterUtils.ipToBigInteger(remoteIP));
                    jsonObMap.put("ip", 0);
                }
            }
            catch (UnknownHostException e) {
                log.error("Error while parsing host IP {}", (Object)remoteIP, (Object)e);
                jsonObMap.put("ipv6", 0);
                jsonObMap.put("ip", 0);
            }
        }
        return jsonObMap;
    }
}

