/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.grpc;

import com.google.rpc.Status;
import io.envoyproxy.envoy.config.core.v3.HeaderValue;
import io.envoyproxy.envoy.config.core.v3.HeaderValueOption;
import io.envoyproxy.envoy.service.auth.v3.AuthorizationGrpc;
import io.envoyproxy.envoy.service.auth.v3.CheckRequest;
import io.envoyproxy.envoy.service.auth.v3.CheckResponse;
import io.envoyproxy.envoy.service.auth.v3.DeniedHttpResponse;
import io.envoyproxy.envoy.service.auth.v3.OkHttpResponse;
import io.envoyproxy.envoy.type.v3.HttpStatus;
import io.grpc.stub.StreamObserver;
import org.json.JSONObject;
import org.wso2.micro.gateway.enforcer.api.ResponseObject;
import org.wso2.micro.gateway.enforcer.server.RequestHandler;

public class ExtAuthService
extends AuthorizationGrpc.AuthorizationImplBase {
    private RequestHandler requestHandler = new RequestHandler();

    @Override
    public void check(CheckRequest request, StreamObserver<CheckResponse> responseObserver) {
        ResponseObject responseObject = this.requestHandler.process(request, responseObserver);
        CheckResponse response1 = this.buildResponse(request, responseObject);
        responseObserver.onNext(response1);
        responseObserver.onCompleted();
    }

    private CheckResponse buildResponse(CheckRequest request, ResponseObject responseObject) {
        DeniedHttpResponse.Builder responseBuilder = DeniedHttpResponse.newBuilder();
        HttpStatus status = HttpStatus.newBuilder().setCodeValue(responseObject.getStatusCode()).build();
        String traceKey = request.getAttributes().getRequest().getHttp().getId();
        if (responseObject.isDirectResponse()) {
            if (responseObject.getStatusCode() == 204) {
                responseObject.getHeaderMap().forEach((key, value) -> {
                    HeaderValueOption headerValueOption = HeaderValueOption.newBuilder().setHeader(HeaderValue.newBuilder().setKey((String)key).setValue((String)value).build()).build();
                    responseBuilder.addHeaders(headerValueOption);
                });
                return CheckResponse.newBuilder().setStatus(Status.newBuilder().setCode(this.getCode(responseObject.getStatusCode()))).setDeniedResponse(responseBuilder.setStatus(status).build()).build();
            }
            JSONObject responseJson = new JSONObject();
            responseJson.put("code", responseObject.getErrorCode());
            responseJson.put("error_message", responseObject.getErrorMessage());
            responseJson.put("error_description", responseObject.getErrorDescription());
            HeaderValueOption headerValueOption = HeaderValueOption.newBuilder().setHeader(HeaderValue.newBuilder().setKey("Content-type").setValue("application/json").build()).setHeader(HeaderValue.newBuilder().setKey("X-TRACE-KEY").setValue(traceKey).build()).build();
            responseBuilder.addHeaders(headerValueOption);
            return CheckResponse.newBuilder().setStatus(Status.newBuilder().setCode(this.getCode(responseObject.getStatusCode()))).setDeniedResponse(responseBuilder.setBody(responseJson.toString()).setStatus(status).build()).build();
        }
        OkHttpResponse.Builder okResponseBuilder = OkHttpResponse.newBuilder();
        if (responseObject.getHeaderMap() != null) {
            responseObject.getHeaderMap().forEach((key, value) -> {
                HeaderValueOption headerValueOption = HeaderValueOption.newBuilder().setHeader(HeaderValue.newBuilder().setKey((String)key).setValue((String)value).build()).build();
                okResponseBuilder.addHeaders(headerValueOption);
            });
        }
        HeaderValueOption headerValueOption = HeaderValueOption.newBuilder().setHeader(HeaderValue.newBuilder().setKey("X-TRACE-KEY").setValue(traceKey).build()).build();
        responseBuilder.addHeaders(headerValueOption);
        return CheckResponse.newBuilder().setStatus(Status.newBuilder().setCode(0).build()).setOkResponse(okResponseBuilder.build()).build();
    }

    private int getCode(int statusCode) {
        switch (statusCode) {
            case 200: {
                return 0;
            }
            case 401: {
                return 16;
            }
            case 403: {
                return 7;
            }
            case 409: {
                return 8;
            }
        }
        return 13;
    }
}

