/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.keymgt;

import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.wso2.carbon.apimgt.common.gateway.dto.ClaimMappingDto;
import org.wso2.carbon.apimgt.common.gateway.dto.JWKSConfigurationDTO;
import org.wso2.gateway.discovery.keymgt.KeyManagerConfig;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.config.dto.ExtendedTokenIssuerDto;
import org.wso2.micro.gateway.enforcer.discovery.KeyManagerDiscoveryClient;
import org.wso2.micro.gateway.enforcer.util.TLSUtils;

public class KeyManagerHolder {
    private static final Logger logger = LogManager.getLogger(ConfigHolder.class);
    private static final String X509 = "X.509";
    private static KeyManagerHolder instance;
    private Map<String, ExtendedTokenIssuerDto> tokenIssuerMap = ConfigHolder.getInstance().getConfig().getIssuersMap();

    private KeyManagerHolder() {
    }

    public static KeyManagerHolder getInstance() {
        if (instance == null) {
            instance = new KeyManagerHolder();
        }
        return instance;
    }

    public void init() {
        if (ConfigHolder.getInstance().getConfig().getEventHub().isEnabled()) {
            KeyManagerDiscoveryClient keyManagerDs = KeyManagerDiscoveryClient.getInstance();
            keyManagerDs.watchKeyManagers();
        }
    }

    public void populateKMIssuerConfiguration(List<KeyManagerConfig> kmIssuers) {
        Map<String, ExtendedTokenIssuerDto> kmIssuerMap = this.getAllKmIssuers(kmIssuers);
        this.updateIssuerMap(kmIssuerMap);
    }

    public Map<String, ExtendedTokenIssuerDto> getAllKmIssuers(List<KeyManagerConfig> kmIssuers) {
        HashMap<String, ExtendedTokenIssuerDto> kmIssuerMap = new HashMap<String, ExtendedTokenIssuerDto>();
        for (KeyManagerConfig keyManagerConfig : kmIssuers) {
            JSONObject configObj = new JSONObject(keyManagerConfig.getConfiguration());
            HashMap<String, Object> configuration = new HashMap<String, Object>();
            Iterator<String> keysItr = configObj.keys();
            while (keysItr.hasNext()) {
                String key = keysItr.next();
                Object value = configObj.get(key);
                configuration.put(key, value);
            }
            if (!keyManagerConfig.getEnabled()) continue;
            this.addKMTokenIssuers(keyManagerConfig.getName(), configuration, kmIssuerMap);
        }
        return kmIssuerMap;
    }

    public void addKMTokenIssuers(String keyManagerName, Map<String, Object> configuration, Map<String, ExtendedTokenIssuerDto> kmIssuerMap) {
        Object issuer;
        Object selfValidateJWT = configuration.get("self_validate_jwt");
        if (selfValidateJWT != null && ((Boolean)selfValidateJWT).booleanValue() && (issuer = configuration.get("issuer")) != null) {
            Object jwksEndpoint;
            Object scopeClaim;
            Object consumerKeyClaim;
            ExtendedTokenIssuerDto tokenIssuerDto = new ExtendedTokenIssuerDto((String)issuer);
            tokenIssuerDto.setName(keyManagerName);
            tokenIssuerDto.setValidateSubscriptions(true);
            Object claimMappings = configuration.get("claim_mappings");
            if (claimMappings instanceof JSONArray) {
                Gson gson = new Gson();
                ClaimMappingDto[] claimMappingDto = gson.fromJson(claimMappings.toString(), ClaimMappingDto[].class);
                tokenIssuerDto.addClaimMappings(claimMappingDto);
            }
            if ((consumerKeyClaim = configuration.get("consumer_key_claim")) instanceof String && StringUtils.isNotEmpty((String)consumerKeyClaim)) {
                tokenIssuerDto.setConsumerKeyClaim((String)consumerKeyClaim);
            }
            if ((scopeClaim = configuration.get("scopes_claim")) instanceof String && StringUtils.isNotEmpty((String)scopeClaim)) {
                tokenIssuerDto.setScopesClaim((String)scopeClaim);
            }
            if ((jwksEndpoint = configuration.get("jwks_endpoint")) != null && StringUtils.isNotEmpty((String)jwksEndpoint)) {
                JWKSConfigurationDTO jwksConfigurationDTO = new JWKSConfigurationDTO();
                jwksConfigurationDTO.setEnabled(true);
                jwksConfigurationDTO.setUrl((String)jwksEndpoint);
                tokenIssuerDto.setJwksConfigurationDTO(jwksConfigurationDTO);
            }
            Object certificateType = configuration.get("certificate_type");
            Object certificateValue = configuration.get("certificate_value");
            if (certificateType != null && StringUtils.isNotEmpty((String)certificateType) && certificateValue != null && StringUtils.isNotEmpty((String)certificateValue)) {
                if ("JWKS".equals(certificateType)) {
                    JWKSConfigurationDTO jwksConfigurationDTO = new JWKSConfigurationDTO();
                    jwksConfigurationDTO.setEnabled(true);
                    jwksConfigurationDTO.setUrl((String)certificateValue);
                    tokenIssuerDto.setJwksConfigurationDTO(jwksConfigurationDTO);
                } else {
                    try {
                        byte[] certBytes = Base64.getDecoder().decode(certificateValue.toString());
                        ByteArrayInputStream is = new ByteArrayInputStream(certBytes);
                        Certificate certificate = CertificateFactory.getInstance(X509).generateCertificate(is);
                        tokenIssuerDto.setCertificate(TLSUtils.convertCertificate(certificate));
                    }
                    catch (CertificateException e) {
                        logger.error("Error reading the certificate for issuer " + issuer + ". Error cause: " + e.getMessage());
                    }
                }
            }
            kmIssuerMap.put(tokenIssuerDto.getIssuer(), tokenIssuerDto);
        }
    }

    public void updateIssuerMap(Map<String, ExtendedTokenIssuerDto> kmIssuerMap) {
        ArrayList<ExtendedTokenIssuerDto> configIssuerList = ConfigHolder.getInstance().getConfigIssuerList();
        for (ExtendedTokenIssuerDto configTokenIssuer : configIssuerList) {
            if (!kmIssuerMap.containsKey(configTokenIssuer.getIssuer())) {
                kmIssuerMap.put(configTokenIssuer.getIssuer(), configTokenIssuer);
                continue;
            }
            logger.warn("token issuer " + configTokenIssuer.getIssuer() + " already exists in config map. Existing configurations will be replaced by external KeyManager configurations");
        }
        this.tokenIssuerMap.clear();
        this.tokenIssuerMap.putAll(kmIssuerMap);
    }
}

