/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.micro.gateway.enforcer.api.config.ResourceConfig;
import org.wso2.micro.gateway.enforcer.dto.APIKeyValidationInfoDTO;
import org.wso2.micro.gateway.enforcer.exception.MGWException;
import org.wso2.micro.gateway.enforcer.models.API;
import org.wso2.micro.gateway.enforcer.models.ApiPolicy;
import org.wso2.micro.gateway.enforcer.models.Application;
import org.wso2.micro.gateway.enforcer.models.ApplicationKeyMapping;
import org.wso2.micro.gateway.enforcer.models.ApplicationPolicy;
import org.wso2.micro.gateway.enforcer.models.Subscription;
import org.wso2.micro.gateway.enforcer.models.SubscriptionPolicy;
import org.wso2.micro.gateway.enforcer.models.URLMapping;
import org.wso2.micro.gateway.enforcer.security.TokenValidationContext;
import org.wso2.micro.gateway.enforcer.subscription.SubscriptionDataHolder;
import org.wso2.micro.gateway.enforcer.subscription.SubscriptionDataStore;
import org.wso2.micro.gateway.enforcer.util.FilterUtils;

public class KeyValidator {
    private static final Logger log = LogManager.getLogger(KeyValidator.class);

    public APIKeyValidationInfoDTO validateSubscription(String apiContext, String apiVersion, String consumerKey, String keyManager) {
        APIKeyValidationInfoDTO apiKeyValidationInfoDTO = new APIKeyValidationInfoDTO();
        try {
            if (log.isDebugEnabled()) {
                log.debug("Before validating subscriptions");
                log.debug("Validation Info : { context : " + apiContext + " , version : " + apiVersion + " , consumerKey : " + consumerKey + " }");
            }
            this.validateSubscriptionDetails(apiContext, apiVersion, consumerKey, keyManager, apiKeyValidationInfoDTO);
            if (log.isDebugEnabled()) {
                log.debug("After validating subscriptions");
            }
        }
        catch (MGWException e) {
            log.error("Error Occurred while validating subscription.", (Throwable)e);
        }
        return apiKeyValidationInfoDTO;
    }

    public boolean validateScopes(TokenValidationContext validationContext) throws MGWException {
        if (validationContext.isCacheHit()) {
            return true;
        }
        APIKeyValidationInfoDTO apiKeyValidationInfoDTO = validationContext.getValidationInfoDTO();
        if (apiKeyValidationInfoDTO == null) {
            throw new MGWException("Key Validation information not set");
        }
        Set<String> scopesSet = apiKeyValidationInfoDTO.getScopes();
        StringBuilder scopeList = new StringBuilder();
        if (scopesSet != null && !scopesSet.isEmpty()) {
            String[] scopes = scopesSet.toArray(new String[scopesSet.size()]);
            if (log.isDebugEnabled() && scopes != null) {
                for (String scope : scopes) {
                    scopeList.append(scope);
                    scopeList.append(",");
                }
                scopeList.deleteCharAt(scopeList.length() - 1);
                log.debug("Scopes allowed for token : " + validationContext.getAccessToken() + " : " + scopeList.toString());
            }
        }
        ResourceConfig matchedResource = validationContext.getMatchingResourceConfig();
        boolean scopesValidated = false;
        if (matchedResource.getSecuritySchemas().entrySet().size() > 0) {
            for (Map.Entry<String, List<String>> pair : matchedResource.getSecuritySchemas().entrySet()) {
                boolean validate = false;
                if (pair.getValue() != null && pair.getValue().size() > 0) {
                    scopesValidated = false;
                    for (String scope : pair.getValue()) {
                        if (!scopesSet.contains(scope)) continue;
                        scopesValidated = true;
                        validate = true;
                        break;
                    }
                } else {
                    scopesValidated = true;
                }
                if (!validate) continue;
                break;
            }
        } else {
            scopesValidated = true;
        }
        if (!scopesValidated) {
            apiKeyValidationInfoDTO.setAuthorized(false);
            apiKeyValidationInfoDTO.setValidationStatus(900910);
        }
        return scopesValidated;
    }

    private boolean validateSubscriptionDetails(String context, String version, String consumerKey, String keyManager, APIKeyValidationInfoDTO infoDTO) throws MGWException {
        boolean defaultVersionInvoked = false;
        String apiTenantDomain = FilterUtils.getTenantDomainFromRequestURL(context);
        if (apiTenantDomain == null) {
            apiTenantDomain = "carbon.super";
        }
        if (version != null && version.startsWith("_default_")) {
            defaultVersionInvoked = true;
            version = version.split("_default_")[1];
        }
        this.validateSubscriptionDetails(infoDTO, context, version, consumerKey, keyManager, defaultVersionInvoked);
        return infoDTO.isAuthorized();
    }

    private APIKeyValidationInfoDTO validateSubscriptionDetails(APIKeyValidationInfoDTO infoDTO, String context, String version, String consumerKey, String keyManager, boolean defaultVersionInvoked) {
        String apiTenantDomain = FilterUtils.getTenantDomainFromRequestURL(context);
        if (apiTenantDomain == null) {
            apiTenantDomain = "carbon.super";
        }
        int tenantId = -1234;
        API api = null;
        ApplicationKeyMapping key = null;
        Application app = null;
        Subscription sub = null;
        SubscriptionDataStore datastore = SubscriptionDataHolder.getInstance().getTenantSubscriptionStore(apiTenantDomain);
        if (datastore != null) {
            api = datastore.getApiByContextAndVersion(context, version);
            if (api != null) {
                key = datastore.getKeyMappingByKeyAndKeyManager(consumerKey, keyManager);
                if (key != null) {
                    app = datastore.getApplicationById(key.getApplicationId());
                    if (app != null) {
                        sub = datastore.getSubscriptionById(app.getId(), api.getApiId());
                        if (sub != null) {
                            if (log.isDebugEnabled()) {
                                log.debug("All information is retrieved from the inmemory data store.");
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug("Valid subscription not found for appId " + app.getId() + " and apiId " + api.getApiId());
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug("Application not found in the datastore for id " + key.getApplicationId());
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Application keymapping not found in the datastore for id consumerKey " + consumerKey);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("API not found in the datastore for " + context + ":" + version);
            }
        } else {
            log.error("Subscription datastore is null for tenant domain " + apiTenantDomain);
        }
        if (api != null && app != null && key != null && sub != null) {
            this.validate(infoDTO, apiTenantDomain, tenantId, datastore, api, key, app, sub, keyManager);
        } else if (!infoDTO.isAuthorized() && infoDTO.getValidationStatus() == 0) {
            infoDTO.setValidationStatus(900908);
        }
        return infoDTO;
    }

    private APIKeyValidationInfoDTO validate(APIKeyValidationInfoDTO infoDTO, String apiTenantDomain, int tenantId, SubscriptionDataStore datastore, API api, ApplicationKeyMapping key, Application app, Subscription sub, String keyManager) {
        String subscriptionStatus = sub.getSubscriptionState();
        String type = key.getKeyType();
        if ("BLOCKED".equals(subscriptionStatus)) {
            infoDTO.setValidationStatus(900907);
            infoDTO.setAuthorized(false);
            return infoDTO;
        }
        if ("ON_HOLD".equals(subscriptionStatus) || "REJECTED".equals(subscriptionStatus)) {
            infoDTO.setValidationStatus(900909);
            infoDTO.setAuthorized(false);
            return infoDTO;
        }
        if ("PROD_ONLY_BLOCKED".equals(subscriptionStatus) && !"SANDBOX".equals(type)) {
            infoDTO.setValidationStatus(900907);
            infoDTO.setType(type);
            infoDTO.setAuthorized(false);
            return infoDTO;
        }
        infoDTO.setTier(sub.getPolicyId());
        infoDTO.setSubscriber(app.getSubName());
        infoDTO.setApplicationId(app.getId().toString());
        infoDTO.setApiName(api.getApiName());
        infoDTO.setApiVersion(api.getApiVersion());
        infoDTO.setApiPublisher(api.getApiProvider());
        infoDTO.setApplicationName(app.getName());
        infoDTO.setApplicationTier(app.getPolicy());
        infoDTO.setApplicationUUID(app.getUUID());
        infoDTO.setAppAttributes(app.getAttributes());
        infoDTO.setType(type);
        String apiTier = api.getApiTier();
        String subscriberTenant = "carbon.super";
        ApplicationPolicy appPolicy = datastore.getApplicationPolicyByName(app.getPolicy(), tenantId);
        SubscriptionPolicy subPolicy = datastore.getSubscriptionPolicyByName(sub.getPolicyId(), tenantId);
        ApiPolicy apiPolicy = datastore.getApiPolicyByName(api.getApiTier(), tenantId);
        boolean isContentAware = false;
        if (appPolicy.isContentAware() || subPolicy.isContentAware() || apiPolicy != null && apiPolicy.isContentAware()) {
            isContentAware = true;
        }
        infoDTO.setContentAware(isContentAware);
        int spikeArrest = 0;
        String apiLevelThrottlingKey = "api_level_throttling_key";
        if (subPolicy.getRateLimitCount() > 0) {
            spikeArrest = subPolicy.getRateLimitCount();
        }
        String spikeArrestUnit = null;
        if (subPolicy.getRateLimitTimeUnit() != null) {
            spikeArrestUnit = subPolicy.getRateLimitTimeUnit();
        }
        boolean stopOnQuotaReach = subPolicy.isStopOnQuotaReach();
        int graphQLMaxDepth = 0;
        if (subPolicy.getGraphQLMaxDepth() > 0) {
            graphQLMaxDepth = subPolicy.getGraphQLMaxDepth();
        }
        int graphQLMaxComplexity = 0;
        if (subPolicy.getGraphQLMaxComplexity() > 0) {
            graphQLMaxComplexity = subPolicy.getGraphQLMaxComplexity();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(apiLevelThrottlingKey);
        infoDTO.setSpikeArrestLimit(spikeArrest);
        infoDTO.setSpikeArrestUnit(spikeArrestUnit);
        infoDTO.setStopOnQuotaReach(stopOnQuotaReach);
        infoDTO.setSubscriberTenantDomain(subscriberTenant);
        infoDTO.setGraphQLMaxDepth(graphQLMaxDepth);
        infoDTO.setGraphQLMaxComplexity(graphQLMaxComplexity);
        if (apiTier != null && apiTier.trim().length() > 0) {
            infoDTO.setApiTier(apiTier);
        }
        infoDTO.setThrottlingDataList(list);
        infoDTO.setAuthorized(true);
        return infoDTO;
    }

    private boolean isResourcePathMatching(String resourceString, URLMapping urlMapping) {
        String urlPattern;
        String resource = resourceString.trim();
        if (resource.equalsIgnoreCase(urlPattern = urlMapping.getUrlPattern().trim())) {
            return true;
        }
        if (resource.length() + 1 == urlPattern.length() && urlPattern.endsWith("/")) {
            String urlPatternWithoutSlash = urlPattern.substring(0, urlPattern.length() - 1);
            return resource.equalsIgnoreCase(urlPatternWithoutSlash);
        }
        return false;
    }
}

