/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.security.jwt;

import com.google.common.cache.LoadingCache;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.util.DateUtils;
import java.text.ParseException;
import java.util.Base64;
import java.util.Date;
import java.util.HashSet;
import net.minidev.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.wso2.carbon.apimgt.common.gateway.dto.JWTConfigurationDto;
import org.wso2.carbon.apimgt.common.gateway.dto.JWTInfoDto;
import org.wso2.carbon.apimgt.common.gateway.dto.JWTValidationInfo;
import org.wso2.carbon.apimgt.common.gateway.exception.JWTGeneratorException;
import org.wso2.carbon.apimgt.common.gateway.jwtgenerator.AbstractAPIMgtGatewayJWTGenerator;
import org.wso2.micro.gateway.enforcer.api.RequestContext;
import org.wso2.micro.gateway.enforcer.api.config.ResourceConfig;
import org.wso2.micro.gateway.enforcer.common.CacheProvider;
import org.wso2.micro.gateway.enforcer.common.ReferenceHolder;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.config.EnforcerConfig;
import org.wso2.micro.gateway.enforcer.config.dto.ExtendedTokenIssuerDto;
import org.wso2.micro.gateway.enforcer.constants.APIConstants;
import org.wso2.micro.gateway.enforcer.constants.APISecurityConstants;
import org.wso2.micro.gateway.enforcer.dto.APIKeyValidationInfoDTO;
import org.wso2.micro.gateway.enforcer.exception.APISecurityException;
import org.wso2.micro.gateway.enforcer.exception.MGWException;
import org.wso2.micro.gateway.enforcer.security.AuthenticationContext;
import org.wso2.micro.gateway.enforcer.security.Authenticator;
import org.wso2.micro.gateway.enforcer.security.TokenValidationContext;
import org.wso2.micro.gateway.enforcer.security.jwt.JWTUtil;
import org.wso2.micro.gateway.enforcer.security.jwt.SignedJWTInfo;
import org.wso2.micro.gateway.enforcer.security.jwt.validator.JWTValidator;
import org.wso2.micro.gateway.enforcer.security.jwt.validator.RevokedJWTDataHolder;
import org.wso2.micro.gateway.enforcer.util.FilterUtils;

public class JWTAuthenticator
implements Authenticator {
    private static final Logger log = LogManager.getLogger(JWTAuthenticator.class);
    private JWTValidator jwtValidator = new JWTValidator();
    private boolean isGatewayTokenCacheEnabled = ConfigHolder.getInstance().getConfig().getCacheDto().isEnabled();
    private AbstractAPIMgtGatewayJWTGenerator jwtGenerator;

    @Override
    public boolean canAuthenticate(RequestContext requestContext) {
        String jwt = requestContext.getHeaders().get("authorization");
        return jwt != null && jwt.split("\\.").length == 3;
    }

    @Override
    public AuthenticationContext authenticate(RequestContext requestContext) throws APISecurityException {
        SignedJWTInfo signedJWTInfo;
        String jwtToken = requestContext.getHeaders().get("authorization");
        String[] splitToken = jwtToken.split("\\s");
        if (splitToken.length > 1) {
            jwtToken = splitToken[1];
        }
        Object context = requestContext.getMathedAPI().getAPIConfig().getBasePath();
        String name = requestContext.getMathedAPI().getAPIConfig().getName();
        String version = requestContext.getMathedAPI().getAPIConfig().getVersion();
        context = (String)context + "/" + version;
        ResourceConfig matchingResource = requestContext.getMatchedResourcePath();
        String httpMethod = requestContext.getMatchedResourcePath().getMethod().toString();
        try {
            signedJWTInfo = this.getSignedJwt(jwtToken);
        }
        catch (IllegalArgumentException | ParseException e) {
            throw new SecurityException("Not a JWT token. Failed to decode the token header.", e);
        }
        JWTClaimsSet claims = signedJWTInfo.getJwtClaimsSet();
        String jwtTokenIdentifier = this.getJWTTokenIdentifier(signedJWTInfo);
        String jwtHeader = signedJWTInfo.getSignedJWT().getHeader().toString();
        if (StringUtils.isNotEmpty(jwtTokenIdentifier) && RevokedJWTDataHolder.isJWTTokenSignatureExistsInRevokedMap(jwtTokenIdentifier)) {
            if (log.isDebugEnabled()) {
                log.debug("Token retrieved from the revoked jwt token map. Token: " + FilterUtils.getMaskedToken(jwtHeader));
            }
            log.error("Invalid JWT token. " + FilterUtils.getMaskedToken(jwtHeader));
            throw new APISecurityException(900901, "Invalid JWT token");
        }
        JWTValidationInfo validationInfo = this.getJwtValidationInfo(signedJWTInfo, jwtTokenIdentifier);
        if (validationInfo != null) {
            if (validationInfo.isValid()) {
                net.minidev.json.JSONObject api;
                APIKeyValidationInfoDTO apiKeyValidationInfoDTO = null;
                EnforcerConfig configuration = ConfigHolder.getInstance().getConfig();
                ExtendedTokenIssuerDto issuerDto = configuration.getIssuersMap().get(validationInfo.getIssuer());
                if (issuerDto.isValidateSubscriptions() && (api = this.validateSubscriptionFromClaim(name, version, claims, splitToken, true)) == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Begin subscription validation via Key Manager: " + validationInfo.getKeyManager());
                    }
                    apiKeyValidationInfoDTO = this.validateSubscriptionUsingKeyManager(requestContext, validationInfo);
                    if (log.isDebugEnabled()) {
                        log.debug("Subscription validation via Key Manager. Status: " + apiKeyValidationInfoDTO.isAuthorized());
                    }
                    if (!apiKeyValidationInfoDTO.isAuthorized()) {
                        throw new APISecurityException(APIConstants.StatusCodes.UNAUTHORIZED.getCode(), apiKeyValidationInfoDTO.getValidationStatus(), "User is NOT authorized to access the Resource. API Subscription validation failed.");
                    }
                }
                this.validateScopes((String)context, version, matchingResource, validationInfo, signedJWTInfo);
                log.debug("JWT authentication successful.");
                String endUserToken = null;
                JWTConfigurationDto jwtConfigurationDto = ConfigHolder.getInstance().getConfig().getJwtConfigurationDto();
                if (jwtConfigurationDto.isEnabled()) {
                    jwtConfigurationDto.setTtl(JWTUtil.getTTL());
                    JWTInfoDto jwtInfoDto = FilterUtils.generateJWTInfoDto(null, validationInfo, apiKeyValidationInfoDTO, requestContext);
                    endUserToken = this.generateAndRetrieveJWTToken(jwtTokenIdentifier, jwtInfoDto);
                    requestContext.addResponseHeaders(jwtConfigurationDto.getJwtHeader(), endUserToken);
                }
                AuthenticationContext authenticationContext = FilterUtils.generateAuthenticationContext(requestContext, jwtTokenIdentifier, validationInfo, apiKeyValidationInfoDTO, endUserToken, true);
                if (claims.getClaim("keytype") != null) {
                    authenticationContext.setKeyType(claims.getClaim("keytype").toString());
                }
                return authenticationContext;
            }
            throw new APISecurityException(APIConstants.StatusCodes.UNAUTHENTICATED.getCode(), validationInfo.getValidationCode(), APISecurityConstants.getAuthenticationFailureMessage(validationInfo.getValidationCode()));
        }
        throw new APISecurityException(APIConstants.StatusCodes.UNAUTHENTICATED.getCode(), 900900, "Unclassified Authentication Failure");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String generateAndRetrieveJWTToken(String tokenSignature, JWTInfoDto jwtInfoDto) throws APISecurityException {
        log.debug("Inside generateAndRetrieveJWTToken");
        String endUserToken = null;
        boolean valid = false;
        String jwtTokenCacheKey = jwtInfoDto.getApicontext().concat(":").concat(jwtInfoDto.getVersion()).concat(":").concat(tokenSignature);
        JWTConfigurationDto jwtConfigurationDto = ConfigHolder.getInstance().getConfig().getJwtConfigurationDto();
        this.jwtGenerator = JWTUtil.getApiMgtGatewayJWTGenerator();
        if (this.jwtGenerator != null) {
            this.jwtGenerator.setJWTConfigurationDto(jwtConfigurationDto);
            if (this.isGatewayTokenCacheEnabled) {
                try {
                    Object token = CacheProvider.getGatewayJWTTokenCache().get(jwtTokenCacheKey);
                    if (token != null) {
                        endUserToken = (String)token;
                        String[] splitToken = ((String)token).split("\\.");
                        JSONObject payload = new JSONObject(new String(Base64.getUrlDecoder().decode(splitToken[1])));
                        long exp = payload.getLong("exp");
                        long timestampSkew = this.getTimeStampSkewInSeconds() * 1000L;
                        valid = exp - System.currentTimeMillis() > timestampSkew;
                    }
                }
                catch (Exception e) {
                    log.error("Error while getting token from the cache", (Throwable)e);
                }
                if (!StringUtils.isEmpty(endUserToken)) {
                    if (valid) return endUserToken;
                }
                try {
                    endUserToken = this.jwtGenerator.generateToken(jwtInfoDto);
                    CacheProvider.getGatewayJWTTokenCache().put(jwtTokenCacheKey, endUserToken);
                    return endUserToken;
                }
                catch (JWTGeneratorException e) {
                    log.error("Error while Generating Backend JWT", (Throwable)e);
                    throw new APISecurityException(900900, "Unclassified Authentication Failure", e);
                }
            }
            try {
                return this.jwtGenerator.generateToken(jwtInfoDto);
            }
            catch (JWTGeneratorException e) {
                log.error("Error while Generating Backend JWT", (Throwable)e);
                throw new APISecurityException(900900, "Unclassified Authentication Failure", e);
            }
        }
        log.debug("Error while loading JWTGenerator");
        return endUserToken;
    }

    private void validateScopes(String apiContext, String apiVersion, ResourceConfig matchingResource, JWTValidationInfo jwtValidationInfo, SignedJWTInfo jwtToken) throws APISecurityException {
        block4: {
            try {
                String tenantDomain = "carbon.super";
                TokenValidationContext tokenValidationContext = new TokenValidationContext();
                APIKeyValidationInfoDTO apiKeyValidationInfoDTO = new APIKeyValidationInfoDTO();
                HashSet<String> scopeSet = new HashSet<String>();
                scopeSet.addAll(jwtValidationInfo.getScopes());
                apiKeyValidationInfoDTO.setScopes(scopeSet);
                tokenValidationContext.setValidationInfoDTO(apiKeyValidationInfoDTO);
                tokenValidationContext.setAccessToken(jwtToken.getToken());
                tokenValidationContext.setHttpVerb(matchingResource.getPath().toUpperCase());
                tokenValidationContext.setMatchingResourceConfig(matchingResource);
                tokenValidationContext.setContext(apiContext);
                tokenValidationContext.setVersion(apiVersion);
                boolean valid = ReferenceHolder.getInstance().getKeyValidationHandler(tenantDomain).validateScopes(tokenValidationContext);
                if (valid) {
                    if (log.isDebugEnabled()) {
                        log.debug("Scope validation successful for the resource: " + matchingResource + ", user: " + jwtValidationInfo.getUser());
                    }
                    break block4;
                }
                String message = "User is NOT authorized to access the Resource: " + matchingResource.getPath() + ". Scope validation failed.";
                log.debug(message);
                throw new APISecurityException(APIConstants.StatusCodes.UNAUTHORIZED.getCode(), 900910, message);
            }
            catch (MGWException e) {
                String message = "Error while accessing backend services for token scope validation";
                log.error(message, (Throwable)e);
                throw new APISecurityException(900900, message, e);
            }
        }
    }

    private APIKeyValidationInfoDTO validateSubscriptionUsingKeyManager(RequestContext requestContext, JWTValidationInfo jwtValidationInfo) throws APISecurityException {
        String apiContext = requestContext.getMathedAPI().getAPIConfig().getBasePath();
        String apiVersion = requestContext.getMathedAPI().getAPIConfig().getVersion();
        return this.validateSubscriptionUsingKeyManager(apiContext, apiVersion, jwtValidationInfo);
    }

    private APIKeyValidationInfoDTO validateSubscriptionUsingKeyManager(String apiContext, String apiVersion, JWTValidationInfo jwtValidationInfo) throws APISecurityException {
        String tenantDomain = "carbon.super";
        String consumerKey = jwtValidationInfo.getConsumerKey();
        String keyManager = jwtValidationInfo.getKeyManager();
        if (consumerKey != null && keyManager != null) {
            return ReferenceHolder.getInstance().getKeyValidationHandler(tenantDomain).validateSubscription(apiContext, apiVersion, consumerKey, keyManager);
        }
        log.debug("Cannot call Key Manager to validate subscription. Payload of the token does not contain the Authorized party - the party to which the ID Token was issued");
        throw new APISecurityException(900908, "Resource forbidden ");
    }

    private net.minidev.json.JSONObject validateSubscriptionFromClaim(String name, String version, JWTClaimsSet payload, String[] splitToken, boolean isOauth) throws APISecurityException {
        net.minidev.json.JSONObject api = null;
        if (payload.getClaim("subscribedAPIs") != null) {
            JSONArray subscribedAPIs = (JSONArray)payload.getClaim("subscribedAPIs");
            for (int i = 0; i < subscribedAPIs.size(); ++i) {
                net.minidev.json.JSONObject subscribedAPI = (net.minidev.json.JSONObject)subscribedAPIs.get(i);
                if (!name.equals(subscribedAPI.getAsString("name")) || !version.equals(subscribedAPI.getAsString("version"))) continue;
                api = subscribedAPI;
                if (!log.isDebugEnabled()) break;
                log.debug("User is subscribed to the API: " + name + ", version: " + version + ". Token: " + FilterUtils.getMaskedToken(splitToken[0]));
                break;
            }
            if (api == null) {
                if (log.isDebugEnabled()) {
                    log.debug("User is not subscribed to access the API: " + name + ", version: " + version + ". Token: " + FilterUtils.getMaskedToken(splitToken[0]));
                }
                log.error("User is not subscribed to access the API.");
                throw new APISecurityException(APIConstants.StatusCodes.UNAUTHORIZED.getCode(), 900908, "Resource forbidden ");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("No subscription information found in the token.");
            }
            if (!isOauth) {
                log.error("User is not subscribed to access the API.");
                throw new APISecurityException(APIConstants.StatusCodes.UNAUTHORIZED.getCode(), 900908, "Resource forbidden ");
            }
        }
        return api;
    }

    private JWTValidationInfo getJwtValidationInfo(SignedJWTInfo signedJWTInfo, String jti) throws APISecurityException {
        String jwtHeader = signedJWTInfo.getSignedJWT().getHeader().toString();
        String tenantDomain = "carbon.super";
        JWTValidationInfo jwtValidationInfo = null;
        if (this.isGatewayTokenCacheEnabled) {
            Object cacheToken = CacheProvider.getGatewayTokenCache().getIfPresent(jti);
            if (cacheToken != null && ((Boolean)cacheToken).booleanValue()) {
                if (CacheProvider.getGatewayKeyCache().getIfPresent(jti) != null) {
                    JWTValidationInfo tempJWTValidationInfo = (JWTValidationInfo)CacheProvider.getGatewayKeyCache().getIfPresent(jti);
                    this.checkTokenExpiration(jti, tempJWTValidationInfo);
                    jwtValidationInfo = tempJWTValidationInfo;
                }
            } else if (CacheProvider.getInvalidTokenCache().getIfPresent(jti) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Token retrieved from the invalid token cache. Token: " + FilterUtils.getMaskedToken(jwtHeader));
                }
                log.error("Invalid JWT token. " + FilterUtils.getMaskedToken(jwtHeader));
                if (CacheProvider.getGatewayKeyCache().getIfPresent(jti) != null) {
                    jwtValidationInfo = (JWTValidationInfo)CacheProvider.getGatewayKeyCache().getIfPresent(jti);
                } else {
                    log.warn("Token retrieved from the invalid token cache. But the validation info not found in the key cache for the Token: " + FilterUtils.getMaskedToken(jwtHeader));
                    jwtValidationInfo = new JWTValidationInfo();
                    jwtValidationInfo.setValidationCode(900900);
                    jwtValidationInfo.setValid(false);
                }
            }
        }
        if (jwtValidationInfo == null) {
            try {
                jwtValidationInfo = this.jwtValidator.validateJWTToken(signedJWTInfo);
                if (this.isGatewayTokenCacheEnabled) {
                    if (jwtValidationInfo.isValid()) {
                        CacheProvider.getGatewayTokenCache().put(jti, true);
                    } else {
                        CacheProvider.getInvalidTokenCache().put(jti, true);
                    }
                    CacheProvider.getGatewayKeyCache().put(jti, jwtValidationInfo);
                }
                return jwtValidationInfo;
            }
            catch (MGWException e) {
                throw new APISecurityException(900900, "Unclassified Authentication Failure");
            }
        }
        return jwtValidationInfo;
    }

    private JWTValidationInfo checkTokenExpiration(String tokenIdentifier, JWTValidationInfo payload) {
        long timestampSkew = this.getTimeStampSkewInSeconds();
        Date now = new Date();
        Date exp = new Date(payload.getExpiryTime());
        if (!DateUtils.isAfter(exp, now, timestampSkew)) {
            if (this.isGatewayTokenCacheEnabled) {
                CacheProvider.getGatewayTokenCache().invalidate(tokenIdentifier);
                CacheProvider.getGatewayJWTTokenCache().invalidate(tokenIdentifier);
                CacheProvider.getInvalidTokenCache().put(tokenIdentifier, true);
            }
            payload.setValid(false);
            payload.setValidationCode(900901);
            return payload;
        }
        return payload;
    }

    protected long getTimeStampSkewInSeconds() {
        return 5L;
    }

    private SignedJWTInfo getSignedJwt(String accessToken) throws ParseException {
        SignedJWTInfo signedJWTInfo;
        String signature = accessToken.split("\\.")[2];
        LoadingCache gatewaySignedJWTParseCache = CacheProvider.getGatewaySignedJWTParseCache();
        if (gatewaySignedJWTParseCache != null) {
            Object cachedEntry = gatewaySignedJWTParseCache.getIfPresent(accessToken);
            if (cachedEntry != null) {
                signedJWTInfo = (SignedJWTInfo)cachedEntry;
            } else {
                SignedJWT signedJWT = SignedJWT.parse(accessToken);
                JWTClaimsSet jwtClaimsSet = signedJWT.getJWTClaimsSet();
                signedJWTInfo = new SignedJWTInfo(accessToken, signedJWT, jwtClaimsSet);
                gatewaySignedJWTParseCache.put(signature, signedJWTInfo);
            }
        } else {
            SignedJWT signedJWT = SignedJWT.parse(accessToken);
            JWTClaimsSet jwtClaimsSet = signedJWT.getJWTClaimsSet();
            signedJWTInfo = new SignedJWTInfo(accessToken, signedJWT, jwtClaimsSet);
        }
        return signedJWTInfo;
    }

    private String getJWTTokenIdentifier(SignedJWTInfo signedJWTInfo) {
        JWTClaimsSet jwtClaimsSet = signedJWTInfo.getJwtClaimsSet();
        String jwtid = jwtClaimsSet.getJWTID();
        if (StringUtils.isNotEmpty(jwtid)) {
            return jwtid;
        }
        return signedJWTInfo.getSignedJWT().getSignature().toString();
    }
}

