/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.security.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.carbon.apimgt.common.gateway.dto.JWTConfigurationDto;
import org.wso2.carbon.apimgt.common.gateway.jwtgenerator.APIMgtGatewayJWTGeneratorImpl;
import org.wso2.carbon.apimgt.common.gateway.jwtgenerator.AbstractAPIMgtGatewayJWTGenerator;
import org.wso2.carbon.apimgt.common.gateway.jwttransformer.JWTTransformer;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.exception.MGWException;
import org.wso2.micro.gateway.enforcer.security.jwt.JwtTransformerAnnotation;

public class JWTUtil {
    private static final Logger log = LogManager.getLogger(JWTUtil.class);
    private static volatile long ttl = -1L;

    /*
     * Exception decompiling
     */
    public static String retrieveJWKSConfiguration(String jwksEndpoint) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean verifyTokenSignature(SignedJWT jwt, RSAPublicKey publicKey) {
        JWSAlgorithm algorithm = jwt.getHeader().getAlgorithm();
        if (JWSAlgorithm.RS256.equals(algorithm) || JWSAlgorithm.RS512.equals(algorithm) || JWSAlgorithm.RS384.equals(algorithm)) {
            try {
                RSASSAVerifier jwsVerifier = new RSASSAVerifier(publicKey);
                return jwt.verify(jwsVerifier);
            }
            catch (JOSEException e) {
                log.error("Error while verifying JWT signature", (Throwable)e);
                return false;
            }
        }
        log.error("Public key is not a RSA");
        return false;
    }

    public static boolean verifyTokenSignature(SignedJWT jwt, String alias) throws MGWException {
        Certificate publicCert = null;
        try {
            publicCert = ConfigHolder.getInstance().getTrustStoreForJWT().getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new MGWException("Error while retrieving the certificate for JWT verification.", e);
        }
        if (publicCert != null) {
            JWSAlgorithm algorithm = jwt.getHeader().getAlgorithm();
            if (JWSAlgorithm.RS256.equals(algorithm) || JWSAlgorithm.RS512.equals(algorithm) || JWSAlgorithm.RS384.equals(algorithm)) {
                return JWTUtil.verifyTokenSignature(jwt, (RSAPublicKey)publicCert.getPublicKey());
            }
            log.error("Public key is not RSA");
            throw new MGWException("Public key is not RSA");
        }
        log.debug("Couldn't find a public certificate to verify the signature");
        throw new MGWException("Couldn't find a public certificate to verify the signature");
    }

    public static PrivateKey getPrivateKey(String filePath) throws MGWException {
        RSAPrivateKey privateKey = null;
        try {
            RSAPrivateKey rsaPrivateKey;
            String strKeyPEM = "";
            Path keyPath = Paths.get(filePath, new String[0]);
            String key = Files.readString(keyPath, Charset.defaultCharset());
            strKeyPEM = key.replace("-----BEGIN PRIVATE KEY-----\n", "").replaceAll(System.lineSeparator(), "").replace("-----END PRIVATE KEY-----", "");
            byte[] encoded = Base64.getDecoder().decode(strKeyPEM);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
            privateKey = rsaPrivateKey = (RSAPrivateKey)kf.generatePrivate(keySpec);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            log.debug("Error obtaining private key", (Throwable)e);
            throw new MGWException("Error obtaining private key");
        }
        return privateKey;
    }

    public static long getTTL() {
        return ttl * 1000L;
    }

    public static AbstractAPIMgtGatewayJWTGenerator getApiMgtGatewayJWTGenerator() {
        JWTConfigurationDto jwtConfigurationDto = ConfigHolder.getInstance().getConfig().getJwtConfigurationDto();
        String classNameInConfig = jwtConfigurationDto.getGatewayJWTGeneratorImpl();
        AbstractAPIMgtGatewayJWTGenerator jwtGenerator = null;
        if (classNameInConfig.equals("org.wso2.carbon.apimgt.common.gateway.jwtgenerator.APIMgtGatewayJWTGeneratorImpl")) {
            jwtGenerator = new APIMgtGatewayJWTGeneratorImpl();
            return jwtGenerator;
        }
        List<String> jarFilesList = JWTUtil.getJarFilesList();
        for (int fileIndex = 0; fileIndex < jarFilesList.size(); ++fileIndex) {
            try {
                String pathToJar = "/home/wso2/lib/dropins/" + jarFilesList.get(fileIndex);
                JarFile jarFile = new JarFile(pathToJar);
                Enumeration<JarEntry> e = jarFile.entries();
                URL[] urls = new URL[]{new URL("jar:file:" + pathToJar + "!/")};
                URLClassLoader cl = URLClassLoader.newInstance(urls);
                while (e.hasMoreElements()) {
                    JarEntry je = e.nextElement();
                    if (je.isDirectory() || !je.getName().endsWith(".class")) continue;
                    String className = je.getName().substring(0, je.getName().length() - 6);
                    if (!classNameInConfig.equals(className = className.replace('/', '.'))) continue;
                    Class<?> classInJar = cl.loadClass(className);
                    try {
                        jwtGenerator = (AbstractAPIMgtGatewayJWTGenerator)classInJar.newInstance();
                        return jwtGenerator;
                    }
                    catch (IllegalAccessException | InstantiationException exception) {
                        log.debug("Error in generating an object from the class", (Throwable)exception);
                    }
                }
                continue;
            }
            catch (IOException | ClassNotFoundException e) {
                log.debug("Error in loading class", (Throwable)e);
            }
        }
        return jwtGenerator;
    }

    public static List<String> getJarFilesList() {
        File[] files;
        ArrayList<String> jarFilesList = new ArrayList<String>();
        for (File file : files = new File("/home/wso2/lib/dropins/").listFiles()) {
            String fileName;
            if (!file.isFile() || !(fileName = file.getName()).endsWith(".jar")) continue;
            jarFilesList.add(file.getName());
        }
        return jarFilesList;
    }

    public static Map<String, JWTTransformer> loadJWTTransformers() {
        JWTTransformer jwtTransformer = null;
        List<String> jarFilesList = JWTUtil.getJarFilesList();
        HashMap<String, JWTTransformer> jwtTransformersMap = new HashMap<String, JWTTransformer>();
        for (int fileIndex = 0; fileIndex < jarFilesList.size(); ++fileIndex) {
            try {
                String pathToJar = "/home/wso2/lib/dropins/" + jarFilesList.get(fileIndex);
                JarFile jarFile = new JarFile(pathToJar);
                Enumeration<JarEntry> e = jarFile.entries();
                URL[] urls = new URL[]{new URL("jar:file:" + pathToJar + "!/")};
                URLClassLoader cl = URLClassLoader.newInstance(urls);
                while (e.hasMoreElements()) {
                    JarEntry je = e.nextElement();
                    if (je.isDirectory() || !je.getName().endsWith(".class")) continue;
                    String className = je.getName().substring(0, je.getName().length() - 6);
                    className = className.replace('/', '.');
                    Class<?> classInJar = cl.loadClass(className);
                    try {
                        Annotation[] annotations;
                        for (Annotation annotation : annotations = classInJar.getAnnotations()) {
                            JwtTransformerAnnotation jwtTransformerAnnotation;
                            if (!(annotation instanceof JwtTransformerAnnotation) || !(jwtTransformerAnnotation = (JwtTransformerAnnotation)annotation).enabled()) continue;
                            jwtTransformer = (JWTTransformer)classInJar.newInstance();
                            jwtTransformersMap.put(jwtTransformerAnnotation.issuer(), jwtTransformer);
                        }
                    }
                    catch (IllegalAccessException | InstantiationException exception) {
                        log.debug("Error in generating an object from the class", (Throwable)exception);
                    }
                }
                continue;
            }
            catch (IOException | ClassNotFoundException e) {
                log.debug("Error in loading class", (Throwable)e);
            }
        }
        return jwtTransformersMap;
    }
}

