/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.security.jwt.issuer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWTClaimsSet;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.common.gateway.exception.JWTGeneratorException;
import org.wso2.carbon.apimgt.common.gateway.util.JWTUtil;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.config.dto.JWTIssuerConfigurationDto;
import org.wso2.micro.gateway.enforcer.security.TokenValidationContext;
import org.wso2.micro.gateway.enforcer.security.jwt.issuer.TokenIssuer;

public abstract class AbstractJWTIssuer
implements TokenIssuer {
    private static final Log log = LogFactory.getLog(AbstractJWTIssuer.class);
    private static final String SHA256_WITH_RSA = "SHA256withRSA";
    private static final String NONE = "NONE";
    private static volatile long ttl = -1L;
    private String signatureAlgorithm = "SHA256withRSA";
    public String dialectURI;
    JWTIssuerConfigurationDto jwtIssuerConfigurationDto;

    public AbstractJWTIssuer() {
        this.setJWTConfigurationDto();
    }

    public void setJWTConfigurationDto() {
        this.jwtIssuerConfigurationDto = ConfigHolder.getInstance().getConfig().getJwtIssuerConfigurationDto();
        this.dialectURI = this.jwtIssuerConfigurationDto.getConsumerDialectUri();
        this.signatureAlgorithm = this.jwtIssuerConfigurationDto.getSignatureAlgorithm();
        if (this.signatureAlgorithm == null || !NONE.equals(this.signatureAlgorithm) && !SHA256_WITH_RSA.equals(this.signatureAlgorithm)) {
            this.signatureAlgorithm = SHA256_WITH_RSA;
        }
    }

    public abstract Map<String, String> populateStandardClaims(TokenValidationContext var1) throws JWTGeneratorException;

    public String getDialectURI() {
        return this.dialectURI;
    }

    public String encode(byte[] stringToBeEncoded) throws JWTGeneratorException {
        return Base64.getUrlEncoder().encodeToString(stringToBeEncoded);
    }

    @Override
    public String generateToken(TokenValidationContext validationContext) throws JWTGeneratorException {
        String jwtHeader = this.buildHeader();
        String base64UrlEncodedHeader = "";
        if (jwtHeader != null) {
            base64UrlEncodedHeader = this.encode(jwtHeader.getBytes(Charset.defaultCharset()));
        }
        String jwtBody = this.buildBody(validationContext);
        String base64UrlEncodedBody = "";
        if (jwtBody != null) {
            base64UrlEncodedBody = this.encode(jwtBody.getBytes());
        }
        if (SHA256_WITH_RSA.equals(this.signatureAlgorithm)) {
            String assertion = base64UrlEncodedHeader + "." + base64UrlEncodedBody;
            byte[] signedAssertion = this.signJWT(assertion, validationContext.getValidationInfoDTO().getEndUserName());
            if (log.isDebugEnabled()) {
                log.debug("signed assertion value : " + new String(signedAssertion, Charset.defaultCharset()));
            }
            String base64UrlEncodedAssertion = this.encode(signedAssertion);
            return base64UrlEncodedHeader + "." + base64UrlEncodedBody + "." + base64UrlEncodedAssertion;
        }
        return base64UrlEncodedHeader + "." + base64UrlEncodedBody + ".";
    }

    public String buildHeader() throws JWTGeneratorException {
        String jwtHeader = null;
        if (NONE.equals(this.signatureAlgorithm)) {
            StringBuilder jwtHeaderBuilder = new StringBuilder();
            jwtHeaderBuilder.append("{\"typ\":\"JWT\",");
            jwtHeaderBuilder.append("\"alg\":\"");
            jwtHeaderBuilder.append(JWTUtil.getJWSCompliantAlgorithmCode(NONE));
            jwtHeaderBuilder.append('\"');
            jwtHeaderBuilder.append('}');
            jwtHeader = jwtHeaderBuilder.toString();
        } else if (SHA256_WITH_RSA.equals(this.signatureAlgorithm)) {
            jwtHeader = this.addCertToHeader();
        }
        return jwtHeader;
    }

    public String buildBody(TokenValidationContext validationContext) throws JWTGeneratorException {
        Map<String, String> standardClaims = this.populateStandardClaims(validationContext);
        JWTClaimsSet.Builder jwtClaimsSetBuilder = new JWTClaimsSet.Builder();
        if (standardClaims != null) {
            for (String claimURI : new TreeSet<String>(standardClaims.keySet())) {
                String claimVal = standardClaims.get(claimURI);
                if (claimVal != null && claimVal.contains("{")) {
                    ObjectMapper mapper = new ObjectMapper();
                    try {
                        Map map = mapper.readValue(claimVal, Map.class);
                        jwtClaimsSetBuilder.claim(claimURI, map);
                    }
                    catch (IOException e) {
                        log.error(String.format("Error while reading claim values for %s", claimVal), e);
                    }
                    continue;
                }
                if ("exp".equals(claimURI)) {
                    jwtClaimsSetBuilder.expirationTime(new Date(Long.valueOf(standardClaims.get(claimURI))));
                    continue;
                }
                if ("iat".equals(claimURI)) {
                    jwtClaimsSetBuilder.issueTime(new Date(Long.valueOf(standardClaims.get(claimURI))));
                    continue;
                }
                jwtClaimsSetBuilder.claim(claimURI, claimVal);
            }
            jwtClaimsSetBuilder.jwtID(UUID.randomUUID().toString());
        }
        return jwtClaimsSetBuilder.build().toJSONObject().toJSONString();
    }

    public byte[] signJWT(String assertion, String endUserName) throws JWTGeneratorException {
        try {
            PrivateKey privateKey = this.jwtIssuerConfigurationDto.getPrivateKey();
            return JWTUtil.signJwt(assertion, privateKey, this.signatureAlgorithm);
        }
        catch (Exception e) {
            throw new JWTGeneratorException(e);
        }
    }

    public long getTTL() {
        ttl = this.jwtIssuerConfigurationDto.getTtl() != 0L ? this.jwtIssuerConfigurationDto.getTtl() : Long.valueOf(3600L).longValue();
        return ttl;
    }

    protected String addCertToHeader() throws JWTGeneratorException {
        try {
            Certificate publicCert = this.jwtIssuerConfigurationDto.getPublicCert();
            return JWTUtil.generateHeader(publicCert, this.signatureAlgorithm);
        }
        catch (Exception e) {
            String error = "Error in obtaining keystore";
            throw new JWTGeneratorException(error, e);
        }
    }
}

