/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.security.jwt.validator;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.util.DateUtils;
import java.io.IOException;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.carbon.apimgt.common.gateway.dto.JWTValidationInfo;
import org.wso2.carbon.apimgt.common.gateway.exception.JWTGeneratorException;
import org.wso2.carbon.apimgt.common.gateway.jwttransformer.DefaultJWTTransformer;
import org.wso2.carbon.apimgt.common.gateway.jwttransformer.JWTTransformer;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.config.dto.ExtendedTokenIssuerDto;
import org.wso2.micro.gateway.enforcer.exception.MGWException;
import org.wso2.micro.gateway.enforcer.security.jwt.JWTUtil;
import org.wso2.micro.gateway.enforcer.security.jwt.SignedJWTInfo;

public class JWTValidator {
    private static final Logger logger = LogManager.getLogger(JWTValidator.class);
    private ExtendedTokenIssuerDto tokenIssuer;
    private JWTTransformer jwtTransformer;
    private JWKSet jwkSet;

    public JWTValidationInfo validateJWTToken(SignedJWTInfo signedJWTInfo) throws MGWException {
        JWTValidationInfo jwtValidationInfo = new JWTValidationInfo();
        String issuer = signedJWTInfo.getJwtClaimsSet().getIssuer();
        Map<String, ExtendedTokenIssuerDto> tokenIssuers = ConfigHolder.getInstance().getConfig().getIssuersMap();
        if (StringUtils.isNotEmpty(issuer) && tokenIssuers.containsKey(issuer)) {
            this.tokenIssuer = tokenIssuers.get(issuer);
            this.jwtTransformer = ConfigHolder.getInstance().getConfig().getJwtTransformerMap().get(issuer);
            if (this.jwtTransformer == null) {
                this.jwtTransformer = new DefaultJWTTransformer();
            }
            this.jwtTransformer.loadConfiguration(this.tokenIssuer);
            return this.validateToken(signedJWTInfo);
        }
        jwtValidationInfo.setValid(false);
        jwtValidationInfo.setValidationCode(900900);
        return jwtValidationInfo;
    }

    private JWTValidationInfo validateToken(SignedJWTInfo signedJWTInfo) throws MGWException {
        JWTValidationInfo jwtValidationInfo = new JWTValidationInfo();
        try {
            boolean state = this.validateSignature(signedJWTInfo.getSignedJWT());
            if (state) {
                JWTClaimsSet jwtClaimsSet = signedJWTInfo.getJwtClaimsSet();
                state = this.validateTokenExpiry(jwtClaimsSet);
                if (state) {
                    jwtValidationInfo.setConsumerKey(this.getConsumerKey(jwtClaimsSet));
                    jwtValidationInfo.setScopes(this.getScopes(jwtClaimsSet));
                    JWTClaimsSet transformedJWTClaimSet = this.transformJWTClaims(jwtClaimsSet);
                    this.createJWTValidationInfoFromJWT(jwtValidationInfo, transformedJWTClaimSet);
                    jwtValidationInfo.setRawPayload(signedJWTInfo.getToken());
                    jwtValidationInfo.setKeyManager(this.tokenIssuer.getName());
                    return jwtValidationInfo;
                }
                jwtValidationInfo.setValid(false);
                jwtValidationInfo.setValidationCode(900901);
                return jwtValidationInfo;
            }
            jwtValidationInfo.setValid(false);
            jwtValidationInfo.setValidationCode(900901);
            return jwtValidationInfo;
        }
        catch (ParseException | JWTGeneratorException e) {
            throw new MGWException("Error while parsing JWT", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean validateSignature(SignedJWT signedJWT) throws MGWException {
        String certificateAlias = "wso2carbon";
        try {
            String keyID = signedJWT.getHeader().getKeyID();
            if (!StringUtils.isNotEmpty(keyID)) return JWTUtil.verifyTokenSignature(signedJWT, certificateAlias);
            if (this.tokenIssuer.getJwksConfigurationDTO().isEnabled() && StringUtils.isNotEmpty(this.tokenIssuer.getJwksConfigurationDTO().getUrl())) {
                if (this.jwkSet == null) {
                    this.jwkSet = this.retrieveJWKSet();
                }
                if (this.jwkSet.getKeyByKeyId(keyID) == null) {
                    this.jwkSet = this.retrieveJWKSet();
                }
                if (!(this.jwkSet.getKeyByKeyId(keyID) instanceof RSAKey)) throw new MGWException("Key Algorithm not supported");
                RSAKey keyByKeyId = (RSAKey)this.jwkSet.getKeyByKeyId(keyID);
                RSAPublicKey rsaPublicKey = keyByKeyId.toRSAPublicKey();
                if (rsaPublicKey == null) return JWTUtil.verifyTokenSignature(signedJWT, certificateAlias);
                return JWTUtil.verifyTokenSignature(signedJWT, rsaPublicKey);
            }
            if (this.tokenIssuer.getCertificate() == null) return JWTUtil.verifyTokenSignature(signedJWT, keyID);
            logger.debug("Retrieve certificate from Token issuer and validating");
            RSAPublicKey rsaPublicKey = (RSAPublicKey)this.tokenIssuer.getCertificate().getPublicKey();
            return JWTUtil.verifyTokenSignature(signedJWT, rsaPublicKey);
        }
        catch (JOSEException | IOException | ParseException e) {
            throw new MGWException("Error while parsing JWT", e);
        }
    }

    protected boolean validateTokenExpiry(JWTClaimsSet jwtClaimsSet) {
        long timestampSkew = 5L;
        Date now = new Date();
        Date exp = jwtClaimsSet.getExpirationTime();
        return exp == null || DateUtils.isAfter(exp, now, timestampSkew);
    }

    private JWKSet retrieveJWKSet() throws IOException, ParseException {
        String jwksInfo = JWTUtil.retrieveJWKSConfiguration(this.tokenIssuer.getJwksConfigurationDTO().getUrl());
        this.jwkSet = JWKSet.parse(jwksInfo);
        return this.jwkSet;
    }

    protected String getConsumerKey(JWTClaimsSet jwtClaimsSet) throws JWTGeneratorException {
        return this.jwtTransformer.getTransformedConsumerKey(jwtClaimsSet);
    }

    protected List<String> getScopes(JWTClaimsSet jwtClaimsSet) throws JWTGeneratorException {
        return this.jwtTransformer.getTransformedScopes(jwtClaimsSet);
    }

    protected JWTClaimsSet transformJWTClaims(JWTClaimsSet jwtClaimsSet) throws JWTGeneratorException {
        return this.jwtTransformer.transform(jwtClaimsSet);
    }

    private void createJWTValidationInfoFromJWT(JWTValidationInfo jwtValidationInfo, JWTClaimsSet jwtClaimsSet) throws ParseException {
        jwtValidationInfo.setIssuer(jwtClaimsSet.getIssuer());
        jwtValidationInfo.setValid(true);
        jwtValidationInfo.setClaims(jwtClaimsSet.getClaims());
        jwtValidationInfo.setExpiryTime(jwtClaimsSet.getExpirationTime().getTime());
        jwtValidationInfo.setIssuedTime(jwtClaimsSet.getIssueTime().getTime());
        jwtValidationInfo.setUser(jwtClaimsSet.getSubject());
        jwtValidationInfo.setJti(jwtClaimsSet.getJWTID());
        if (jwtClaimsSet.getClaim("scope") != null) {
            jwtValidationInfo.setScopes(Arrays.asList(jwtClaimsSet.getStringClaim("scope").split(" ")));
        }
    }
}

