/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.server;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerInterceptors;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.micro.gateway.enforcer.api.APIFactory;
import org.wso2.micro.gateway.enforcer.common.CacheProvider;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.config.dto.AuthServiceConfigurationDto;
import org.wso2.micro.gateway.enforcer.grpc.ExtAuthService;
import org.wso2.micro.gateway.enforcer.grpc.interceptors.AccessLogInterceptor;
import org.wso2.micro.gateway.enforcer.keymgt.KeyManagerHolder;
import org.wso2.micro.gateway.enforcer.security.jwt.validator.RevokedJWTDataHolder;
import org.wso2.micro.gateway.enforcer.server.EnforcerWorkerPool;
import org.wso2.micro.gateway.enforcer.server.TokenServer;
import org.wso2.micro.gateway.enforcer.subscription.SubscriptionDataHolder;
import org.wso2.micro.gateway.enforcer.throttle.ThrottleAgent;
import org.wso2.micro.gateway.enforcer.throttle.ThrottleEventListener;

public class AuthServer {
    private static final Logger logger = LogManager.getLogger(AuthServer.class);

    public static void main(String[] args) {
        try {
            APIFactory.getInstance().init();
            Server server = AuthServer.initServer();
            CacheProvider.init();
            if (ConfigHolder.getInstance().getConfig().getThrottleConfig().isGlobalPublishingEnabled()) {
                ThrottleAgent.startThrottlePublisherPool();
                ThrottleEventListener.init();
            }
            server.start();
            logger.info("Sever started Listening in port : 8081");
            SubscriptionDataHolder.getInstance().getTenantSubscriptionStore().initializeStore();
            KeyManagerHolder.getInstance().init();
            RevokedJWTDataHolder.getInstance().init();
            TokenServer tokenServer = new TokenServer();
            tokenServer.initToken();
            logger.info("Token endpoint started Listening in port : 8082");
            server.awaitTermination();
        }
        catch (IOException e) {
            logger.error("Error while starting the enforcer gRPC server or http server.", (Throwable)e);
            System.exit(1);
        }
        catch (InterruptedException e) {
            logger.error("Enforcer server main thread interrupted.", (Throwable)e);
            System.exit(1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static Server initServer() throws SSLException {
        File certFile = Paths.get(ConfigHolder.getInstance().getEnvVarConfig().getEnforcerPublicKeyPath(), new String[0]).toFile();
        File keyFile = Paths.get(ConfigHolder.getInstance().getEnvVarConfig().getEnforcerPrivateKeyPath(), new String[0]).toFile();
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors());
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2);
        AuthServiceConfigurationDto authServerConfig = ConfigHolder.getInstance().getConfig().getAuthService();
        AuthServiceConfigurationDto.ThreadPoolConfig threadPoolConfig = authServerConfig.getThreadPool();
        EnforcerWorkerPool enforcerWorkerPool = new EnforcerWorkerPool(threadPoolConfig.getCoreSize(), threadPoolConfig.getMaxSize(), threadPoolConfig.getKeepAliveTime(), threadPoolConfig.getQueueSize(), "External Authentication Service Thread Group", "ExtAuthService");
        return ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort(authServerConfig.getPort()).keepAliveTime(authServerConfig.getKeepAliveTime(), TimeUnit.SECONDS).bossEventLoopGroup(bossGroup).workerEventLoopGroup(workerGroup).addService(ServerInterceptors.intercept((BindableService)new ExtAuthService(), new AccessLogInterceptor()))).maxInboundMessageSize(authServerConfig.getMaxMessageSize()).maxInboundMetadataSize(authServerConfig.getMaxHeaderLimit()).channelType(NioServerSocketChannel.class).executor(enforcerWorkerPool.getExecutor())).sslContext(GrpcSslContexts.forServer(certFile, keyFile).trustManager(ConfigHolder.getInstance().getTrustManagerFactory()).clientAuth(ClientAuth.REQUIRE).build()).build();
    }
}

