/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.server;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.micro.gateway.enforcer.server.EnforcerThreadPoolExecutor;
import org.wso2.micro.gateway.enforcer.server.NativeThreadFactory;

public class EnforcerWorkerPool {
    private final BlockingQueue<Runnable> blockingQueue;
    private final ThreadPoolExecutor executor;
    private static final Logger log = LogManager.getLogger(EnforcerWorkerPool.class);

    public EnforcerWorkerPool(int core, int max, int keepAlive, int queueLength, String threadGroupName, String threadGroupId) {
        this.blockingQueue = queueLength == -1 ? new LinkedBlockingQueue<Runnable>() : new LinkedBlockingQueue(queueLength);
        this.executor = new EnforcerThreadPoolExecutor(core, max, (long)keepAlive, TimeUnit.SECONDS, this.blockingQueue, new NativeThreadFactory(new ThreadGroup(threadGroupName), threadGroupId));
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }
}

