/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.server;

import io.envoyproxy.envoy.service.auth.v3.CheckRequest;
import io.envoyproxy.envoy.service.auth.v3.CheckResponse;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.micro.gateway.enforcer.api.API;
import org.wso2.micro.gateway.enforcer.api.APIFactory;
import org.wso2.micro.gateway.enforcer.api.RequestContext;
import org.wso2.micro.gateway.enforcer.api.ResponseObject;
import org.wso2.micro.gateway.enforcer.api.config.APIConfig;
import org.wso2.micro.gateway.enforcer.api.config.ResourceConfig;
import org.wso2.micro.gateway.enforcer.constants.APIConstants;

public class RequestHandler {
    private static final Logger logger = LogManager.getLogger(RequestHandler.class);

    public ResponseObject process(CheckRequest request, StreamObserver<CheckResponse> responseObserver) {
        API matchedAPI = APIFactory.getInstance().getMatchedAPI(request);
        if (matchedAPI == null) {
            ResponseObject responseObject = new ResponseObject();
            responseObject.setStatusCode(APIConstants.StatusCodes.NOTFOUND.getCode());
            responseObject.setErrorCode(APIConstants.StatusCodes.NOTFOUND.getValue());
            responseObject.setDirectResponse(true);
            responseObject.setErrorMessage("Not Found");
            responseObject.setErrorDescription("The requested resource is not available.");
            return responseObject;
        }
        if (logger.isDebugEnabled()) {
            APIConfig api = matchedAPI.getAPIConfig();
            logger.debug("API {}/{} found in the cache", (Object)api.getBasePath(), (Object)api.getVersion());
        }
        RequestContext requestContext = this.buildRequestContext(matchedAPI, request);
        return matchedAPI.process(requestContext);
    }

    private RequestContext buildRequestContext(API api, CheckRequest request) {
        String requestPath = request.getAttributes().getRequest().getHttp().getPath();
        String method = request.getAttributes().getRequest().getHttp().getMethod();
        Map<String, String> headers = request.getAttributes().getRequest().getHttp().getHeadersMap();
        String res = request.getAttributes().getContextExtensionsMap().get("path");
        String prodCluster = request.getAttributes().getContextExtensionsMap().get("prodClusterName");
        String sandCluster = request.getAttributes().getContextExtensionsMap().get("sandClusterName");
        String requestID = request.getAttributes().getRequest().getHttp().getId();
        String address = "";
        if (request.getAttributes().getSource().hasAddress() && request.getAttributes().getSource().getAddress().hasSocketAddress()) {
            address = request.getAttributes().getSource().getAddress().getSocketAddress().getAddress();
        }
        ResourceConfig resourceConfig = APIFactory.getInstance().getMatchedResource(api, res, method);
        return new RequestContext.Builder(requestPath).matchedResourceConfig(resourceConfig).requestMethod(method).matchedAPI(api).headers(headers).requestID(requestID).address(address).prodClusterHeader(prodCluster).sandClusterHeader(sandCluster).build();
    }
}

