/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.server;

import io.grpc.netty.shaded.io.netty.bootstrap.ServerBootstrap;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.netty.shaded.io.netty.handler.logging.LogLevel;
import io.grpc.netty.shaded.io.netty.handler.logging.LoggingHandler;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.security.jwt.issuer.HttpTokenServerInitializer;

public class TokenServer {
    private static final Logger logger = LogManager.getLogger(TokenServer.class);
    static final int PORT = 8082;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initToken() throws SSLException, CertificateException, InterruptedException {
        File certFile = Paths.get(ConfigHolder.getInstance().getEnvVarConfig().getEnforcerPublicKeyPath(), new String[0]).toFile();
        File keyFile = Paths.get(ConfigHolder.getInstance().getEnvVarConfig().getEnforcerPrivateKeyPath(), new String[0]).toFile();
        SslContextBuilder ssl = SslContextBuilder.forServer(certFile, keyFile);
        ssl.trustManager(ConfigHolder.getInstance().getTrustManagerFactory());
        SslContext sslCtx = ssl.build();
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors());
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2);
        try {
            ServerBootstrap b = new ServerBootstrap();
            b.option(ChannelOption.SO_BACKLOG, 1024);
            ((ServerBootstrap)((ServerBootstrap)b.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class)).handler(new LoggingHandler(LogLevel.INFO))).childHandler(new HttpTokenServerInitializer(sslCtx));
            Channel ch = b.bind(8082).sync().channel();
            ch.closeFuture().sync();
        }
        finally {
            workerGroup.shutdownGracefully();
            bossGroup.shutdownGracefully();
        }
    }
}

