/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.subscription;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.gateway.discovery.subscription.APIs;
import org.wso2.gateway.discovery.subscription.SubscriptionPolicy;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;
import org.wso2.micro.gateway.enforcer.discovery.ApiListDiscoveryClient;
import org.wso2.micro.gateway.enforcer.discovery.ApplicationDiscoveryClient;
import org.wso2.micro.gateway.enforcer.discovery.ApplicationKeyMappingDiscoveryClient;
import org.wso2.micro.gateway.enforcer.discovery.ApplicationPolicyDiscoveryClient;
import org.wso2.micro.gateway.enforcer.discovery.SubscriptionDiscoveryClient;
import org.wso2.micro.gateway.enforcer.discovery.SubscriptionPolicyDiscoveryClient;
import org.wso2.micro.gateway.enforcer.models.API;
import org.wso2.micro.gateway.enforcer.models.ApiPolicy;
import org.wso2.micro.gateway.enforcer.models.Application;
import org.wso2.micro.gateway.enforcer.models.ApplicationKeyMapping;
import org.wso2.micro.gateway.enforcer.models.ApplicationKeyMappingCacheKey;
import org.wso2.micro.gateway.enforcer.models.ApplicationPolicy;
import org.wso2.micro.gateway.enforcer.models.Subscription;
import org.wso2.micro.gateway.enforcer.subscription.SubscriptionDataStore;
import org.wso2.micro.gateway.enforcer.subscription.SubscriptionDataStoreUtil;

public class SubscriptionDataStoreImpl
implements SubscriptionDataStore {
    private static final Logger log = LogManager.getLogger(SubscriptionDataStoreImpl.class);
    private static SubscriptionDataStoreImpl instance = new SubscriptionDataStoreImpl();
    public static final String DELEM_PERIOD = ":";
    private Map<ApplicationKeyMappingCacheKey, ApplicationKeyMapping> applicationKeyMappingMap;
    private Map<Integer, Application> applicationMap;
    private Map<String, API> apiMap;
    private Map<String, ApiPolicy> apiPolicyMap;
    private Map<String, org.wso2.micro.gateway.enforcer.models.SubscriptionPolicy> subscriptionPolicyMap;
    private Map<String, ApplicationPolicy> appPolicyMap;
    private Map<String, Subscription> subscriptionMap;
    private String tenantDomain = "carbon.super";

    SubscriptionDataStoreImpl() {
    }

    public static SubscriptionDataStoreImpl getInstance() {
        return instance;
    }

    public void initializeStore() {
        this.applicationKeyMappingMap = new ConcurrentHashMap<ApplicationKeyMappingCacheKey, ApplicationKeyMapping>();
        this.applicationMap = new ConcurrentHashMap<Integer, Application>();
        this.apiMap = new ConcurrentHashMap<String, API>();
        this.subscriptionPolicyMap = new ConcurrentHashMap<String, org.wso2.micro.gateway.enforcer.models.SubscriptionPolicy>();
        this.appPolicyMap = new ConcurrentHashMap<String, ApplicationPolicy>();
        this.apiPolicyMap = new ConcurrentHashMap<String, ApiPolicy>();
        this.subscriptionMap = new ConcurrentHashMap<String, Subscription>();
        if (ConfigHolder.getInstance().getConfig().getEventHub().isEnabled()) {
            this.initializeLoadingTasks();
        }
    }

    @Override
    public Application getApplicationById(int appId) {
        return this.applicationMap.get(appId);
    }

    @Override
    public ApplicationKeyMapping getKeyMappingByKeyAndKeyManager(String key, String keyManager) {
        return this.applicationKeyMappingMap.get(new ApplicationKeyMappingCacheKey(key, keyManager));
    }

    @Override
    public API getApiByContextAndVersion(String context, String version) {
        String key = context + DELEM_PERIOD + version;
        return this.apiMap.get(key);
    }

    @Override
    public org.wso2.micro.gateway.enforcer.models.SubscriptionPolicy getSubscriptionPolicyByName(String policyName, int tenantId) {
        String key = PolicyType.SUBSCRIPTION + SubscriptionDataStoreUtil.getPolicyCacheKey(policyName, tenantId);
        return this.subscriptionPolicyMap.get(key);
    }

    @Override
    public ApplicationPolicy getApplicationPolicyByName(String policyName, int tenantId) {
        String key = PolicyType.APPLICATION + DELEM_PERIOD + SubscriptionDataStoreUtil.getPolicyCacheKey(policyName, tenantId);
        return this.appPolicyMap.get(key);
    }

    @Override
    public Subscription getSubscriptionById(int appId, int apiId) {
        return this.subscriptionMap.get(SubscriptionDataStoreUtil.getSubscriptionCacheKey(appId, apiId));
    }

    @Override
    public ApiPolicy getApiPolicyByName(String policyName, int tenantId) {
        String key = PolicyType.API + DELEM_PERIOD + SubscriptionDataStoreUtil.getPolicyCacheKey(policyName, tenantId);
        return this.apiPolicyMap.get(key);
    }

    private void initializeLoadingTasks() {
        SubscriptionDiscoveryClient.getInstance().watchSubscriptions();
        ApplicationDiscoveryClient.getInstance().watchApplications();
        ApiListDiscoveryClient.getInstance().watchApiList();
        ApplicationPolicyDiscoveryClient.getInstance().watchApplicationPolicies();
        SubscriptionPolicyDiscoveryClient.getInstance().watchSubscriptionPolicies();
        ApplicationKeyMappingDiscoveryClient.getInstance().watchApplicationKeyMappings();
    }

    @Override
    public void addSubscriptions(List<org.wso2.gateway.discovery.subscription.Subscription> subscriptionList) {
        ConcurrentHashMap<String, Subscription> newSubscriptionMap = new ConcurrentHashMap<String, Subscription>();
        for (org.wso2.gateway.discovery.subscription.Subscription subscription : subscriptionList) {
            Subscription newSubscription = new Subscription();
            newSubscription.setSubscriptionId(subscription.getSubscriptionId());
            newSubscription.setPolicyId(subscription.getPolicyId());
            newSubscription.setApiId(subscription.getApiId());
            newSubscription.setAppId(subscription.getAppId());
            newSubscription.setSubscriptionState(subscription.getSubscriptionState());
            newSubscription.setTimeStamp(subscription.getTimeStamp());
            newSubscriptionMap.put(newSubscription.getCacheKey(), newSubscription);
        }
        if (log.isDebugEnabled()) {
            log.debug("Total Subscriptions in new cache: {}", (Object)newSubscriptionMap.size());
        }
        this.subscriptionMap = newSubscriptionMap;
    }

    @Override
    public void addApplications(List<org.wso2.gateway.discovery.subscription.Application> applicationList) {
        ConcurrentHashMap<Integer, Application> newApplicationMap = new ConcurrentHashMap<Integer, Application>();
        for (org.wso2.gateway.discovery.subscription.Application application : applicationList) {
            Application newApplication = new Application();
            newApplication.setId(application.getId());
            newApplication.setName(application.getName());
            newApplication.setPolicy(application.getPolicy());
            newApplication.setSubId(application.getSubId());
            newApplication.setSubName(application.getSubName());
            newApplication.setTokenType(application.getTokenType());
            newApplication.setUUID(application.getUuid());
            application.getAttributesMap().forEach(newApplication::addAttribute);
            newApplicationMap.put(newApplication.getCacheKey(), newApplication);
        }
        if (log.isDebugEnabled()) {
            log.debug("Total Applications in new cache: {}", (Object)newApplicationMap.size());
        }
        this.applicationMap = newApplicationMap;
    }

    @Override
    public void addApis(List<APIs> apisList) {
        ConcurrentHashMap<String, API> newApiMap = new ConcurrentHashMap<String, API>();
        for (APIs api : apisList) {
            API newApi = new API();
            newApi.setApiId(Integer.parseInt(api.getApiId()));
            newApi.setApiName(api.getName());
            newApi.setApiProvider(api.getProvider());
            newApi.setApiType(api.getApiType());
            newApi.setApiVersion(api.getVersion());
            newApi.setContext(api.getContext());
            newApi.setApiTier(api.getPolicy());
            newApiMap.put(newApi.getCacheKey(), newApi);
        }
        if (log.isDebugEnabled()) {
            log.debug("Total Apis in new cache: {}", (Object)newApiMap.size());
        }
        this.apiMap = newApiMap;
    }

    @Override
    public void addApplicationPolicies(List<org.wso2.gateway.discovery.subscription.ApplicationPolicy> applicationPolicyList) {
        ConcurrentHashMap<String, ApplicationPolicy> newAppPolicyMap = new ConcurrentHashMap<String, ApplicationPolicy>();
        for (org.wso2.gateway.discovery.subscription.ApplicationPolicy applicationPolicy : applicationPolicyList) {
            ApplicationPolicy newApplicationPolicy = new ApplicationPolicy();
            newApplicationPolicy.setId(applicationPolicy.getId());
            newApplicationPolicy.setQuotaType(applicationPolicy.getQuotaType());
            newApplicationPolicy.setTenantId(applicationPolicy.getTenantId());
            newApplicationPolicy.setTierName(applicationPolicy.getName());
            newAppPolicyMap.put(newApplicationPolicy.getCacheKey(), newApplicationPolicy);
        }
        if (log.isDebugEnabled()) {
            log.debug("Total Application Policies in new cache: {}", (Object)newAppPolicyMap.size());
        }
        this.appPolicyMap = newAppPolicyMap;
    }

    @Override
    public void addSubscriptionPolicies(List<SubscriptionPolicy> subscriptionPolicyList) {
        ConcurrentHashMap<String, org.wso2.micro.gateway.enforcer.models.SubscriptionPolicy> newSubscriptionPolicyMap = new ConcurrentHashMap<String, org.wso2.micro.gateway.enforcer.models.SubscriptionPolicy>();
        for (SubscriptionPolicy subscriptionPolicy : subscriptionPolicyList) {
            org.wso2.micro.gateway.enforcer.models.SubscriptionPolicy newSubscriptionPolicy = new org.wso2.micro.gateway.enforcer.models.SubscriptionPolicy();
            newSubscriptionPolicy.setId(subscriptionPolicy.getId());
            newSubscriptionPolicy.setQuotaType(subscriptionPolicy.getQuotaType());
            newSubscriptionPolicy.setRateLimitCount(subscriptionPolicy.getRateLimitCount());
            newSubscriptionPolicy.setRateLimitTimeUnit(subscriptionPolicy.getRateLimitTimeUnit());
            newSubscriptionPolicy.setStopOnQuotaReach(subscriptionPolicy.getStopOnQuotaReach());
            newSubscriptionPolicy.setTenantId(subscriptionPolicy.getTenantId());
            newSubscriptionPolicy.setTierName(subscriptionPolicy.getName());
            newSubscriptionPolicy.setGraphQLMaxComplexity(subscriptionPolicy.getGraphQLMaxComplexity());
            newSubscriptionPolicy.setGraphQLMaxDepth(subscriptionPolicy.getGraphQLMaxDepth());
            newSubscriptionPolicyMap.put(newSubscriptionPolicy.getCacheKey(), newSubscriptionPolicy);
        }
        if (log.isDebugEnabled()) {
            log.debug("Total Subscription Policies in new cache: {}", (Object)newSubscriptionPolicyMap.size());
        }
        this.subscriptionPolicyMap = newSubscriptionPolicyMap;
    }

    @Override
    public void addApplicationKeyMappings(List<org.wso2.gateway.discovery.subscription.ApplicationKeyMapping> applicationKeyMappingList) {
        ConcurrentHashMap<ApplicationKeyMappingCacheKey, ApplicationKeyMapping> newApplicationKeyMappingMap = new ConcurrentHashMap<ApplicationKeyMappingCacheKey, ApplicationKeyMapping>();
        for (org.wso2.gateway.discovery.subscription.ApplicationKeyMapping applicationKeyMapping : applicationKeyMappingList) {
            ApplicationKeyMapping mapping = new ApplicationKeyMapping();
            mapping.setApplicationId(applicationKeyMapping.getApplicationId());
            mapping.setConsumerKey(applicationKeyMapping.getConsumerKey());
            mapping.setKeyType(applicationKeyMapping.getKeyType());
            mapping.setKeyManager(applicationKeyMapping.getKeyManager());
            newApplicationKeyMappingMap.put(mapping.getCacheKey(), mapping);
        }
        if (log.isDebugEnabled()) {
            log.debug("Total Application Key Mappings in new cache: {}", (Object)newApplicationKeyMappingMap.size());
        }
        this.applicationKeyMappingMap = newApplicationKeyMappingMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOrUpdateSubscription(Subscription subscription) {
        Map<String, Subscription> map = this.subscriptionMap;
        synchronized (map) {
            Subscription retrievedSubscription = this.subscriptionMap.get(subscription.getCacheKey());
            if (retrievedSubscription == null) {
                this.subscriptionMap.put(subscription.getCacheKey(), subscription);
            } else if (subscription.getTimeStamp() < retrievedSubscription.getTimeStamp()) {
                if (log.isDebugEnabled()) {
                    log.debug("Drop the Event " + subscription.toString() + " since the event timestamp was old");
                }
            } else {
                this.subscriptionMap.put(subscription.getCacheKey(), subscription);
            }
        }
    }

    @Override
    public void removeSubscription(Subscription subscription) {
        this.subscriptionMap.remove(subscription.getCacheKey());
    }

    @Override
    public void addOrUpdateAPI(API api) {
        this.apiMap.put(api.getCacheKey(), api);
    }

    @Override
    public void addOrUpdateAPIWithUrlTemplates(API api) {
    }

    @Override
    public void removeAPI(API api) {
        this.apiMap.remove(api.getCacheKey());
    }

    @Override
    public void addOrUpdateApplicationKeyMapping(ApplicationKeyMapping applicationKeyMapping) {
        this.applicationKeyMappingMap.remove(applicationKeyMapping.getCacheKey());
        this.applicationKeyMappingMap.put(applicationKeyMapping.getCacheKey(), applicationKeyMapping);
    }

    @Override
    public void removeApplicationKeyMapping(ApplicationKeyMapping applicationKeyMapping) {
        this.applicationKeyMappingMap.remove(applicationKeyMapping.getCacheKey());
    }

    @Override
    public void addOrUpdateSubscriptionPolicy(org.wso2.micro.gateway.enforcer.models.SubscriptionPolicy subscriptionPolicy) {
        this.subscriptionPolicyMap.remove(subscriptionPolicy.getCacheKey());
        this.subscriptionPolicyMap.put(subscriptionPolicy.getCacheKey(), subscriptionPolicy);
    }

    @Override
    public void addOrUpdateApplicationPolicy(ApplicationPolicy applicationPolicy) {
        this.appPolicyMap.remove(applicationPolicy.getCacheKey());
        this.appPolicyMap.put(applicationPolicy.getCacheKey(), applicationPolicy);
    }

    @Override
    public void removeApplicationPolicy(ApplicationPolicy applicationPolicy) {
        this.appPolicyMap.remove(applicationPolicy.getCacheKey());
    }

    @Override
    public void removeSubscriptionPolicy(org.wso2.micro.gateway.enforcer.models.SubscriptionPolicy subscriptionPolicy) {
        this.subscriptionPolicyMap.remove(subscriptionPolicy.getCacheKey());
    }

    @Override
    public void addOrUpdateApplication(Application application) {
        this.applicationMap.remove(application.getId());
        this.applicationMap.put(application.getId(), application);
    }

    @Override
    public void removeApplication(Application application) {
        this.applicationMap.remove(application.getId());
    }

    @Override
    public void addOrUpdateApiPolicy(ApiPolicy apiPolicy) {
    }

    @Override
    public void removeApiPolicy(ApiPolicy apiPolicy) {
        this.apiPolicyMap.remove(apiPolicy.getCacheKey());
    }

    @Override
    public API getDefaultApiByContext(String context) {
        Set set = this.apiMap.keySet().stream().filter(s2 -> s2.startsWith(context)).collect(Collectors.toSet());
        for (String key : set) {
            API api = this.apiMap.get(key);
            if (!api.isDefaultVersion() || !api.getContext().replace("/" + api.getApiVersion(), "").equals(context)) continue;
            return api;
        }
        return null;
    }

    public static enum PolicyType {
        SUBSCRIPTION,
        APPLICATION,
        API;

    }
}

