/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.throttle.databridge.agent.endpoint.binary;

import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.AgentHolder;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.client.AbstractSecureClientPoolFactory;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.conf.DataEndpointConfiguration;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.exception.DataEndpointException;

public class BinarySecureClientPoolFactory
extends AbstractSecureClientPoolFactory {
    private static final Logger log = LogManager.getLogger(BinarySecureClientPoolFactory.class);
    private static SSLSocketFactory sslSocketFactory;

    public BinarySecureClientPoolFactory(KeyStore trustStore) {
        super(trustStore);
        try {
            SSLContext ctx = this.createSSLContext();
            sslSocketFactory = ctx.getSocketFactory();
        }
        catch (DataEndpointException e) {
            log.error("Error while initializing the SSL Context with provided parameters" + e.getErrorMessage(), (Throwable)e);
            log.warn("Default SSLSocketFactory will be used for the data publishing clients.");
            sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
    }

    @Override
    public Object createClient(String protocol, String hostName, int port) throws DataEndpointException {
        if (protocol.equalsIgnoreCase(DataEndpointConfiguration.Protocol.SSL.toString())) {
            int timeout = AgentHolder.getInstance().getDataEndpointAgent().getAgentConfiguration().getSocketTimeoutMS();
            String sslProtocols = AgentHolder.getInstance().getDataEndpointAgent().getAgentConfiguration().getSslEnabledProtocols();
            String ciphers = AgentHolder.getInstance().getDataEndpointAgent().getAgentConfiguration().getCiphers();
            try {
                SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(hostName, port);
                sslSocket.setSoTimeout(timeout);
                if (sslProtocols != null && sslProtocols.length() != 0) {
                    String[] sslProtocolsArray = sslProtocols.split(",");
                    sslSocket.setEnabledProtocols(sslProtocolsArray);
                }
                if (ciphers != null && ciphers.length() != 0) {
                    String[] ciphersArray = ciphers.replaceAll(" ", "").split(",");
                    sslSocket.setEnabledCipherSuites(ciphersArray);
                } else {
                    sslSocket.setEnabledCipherSuites(sslSocket.getSupportedCipherSuites());
                }
                return sslSocket;
            }
            catch (IOException e) {
                throw new DataEndpointException("Error while opening socket to " + hostName + ":" + port + ". " + e.getMessage(), e);
            }
        }
        throw new DataEndpointException("Unsupported protocol: " + protocol + ". Currently only " + DataEndpointConfiguration.Protocol.SSL.toString() + " supported.");
    }

    @Override
    public boolean validateClient(Object client) {
        Socket socket = (Socket)client;
        return socket.isConnected();
    }

    @Override
    public void terminateClient(Object client) {
        Socket socket = null;
        try {
            socket = (Socket)client;
            socket.close();
        }
        catch (IOException e) {
            log.warn("Cannot close the socket successfully from " + socket.getLocalAddress().getHostAddress() + ":" + socket.getPort());
        }
    }

    private SSLContext createSSLContext() throws DataEndpointException {
        try {
            KeyStore trustStore = this.getTrustStore();
            SSLContext ctx = SSLContexts.custom().loadTrustMaterial(trustStore).build();
            return ctx;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new DataEndpointException("Error while creating the SSLContext with instance type : TLS.", e);
        }
    }
}

