/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.throttle.databridge.publisher;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.carbon.databridge.commons.exception.TransportException;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.DataPublisher;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.exception.DataEndpointAuthenticationException;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.exception.DataEndpointConfigurationException;
import org.wso2.micro.gateway.enforcer.throttle.databridge.agent.exception.DataEndpointException;
import org.wso2.micro.gateway.enforcer.throttle.databridge.publisher.DataProcessAndPublishingAgent;
import org.wso2.micro.gateway.enforcer.throttle.databridge.publisher.PublisherConfiguration;
import org.wso2.micro.gateway.enforcer.throttle.databridge.publisher.ThrottleDataPublisherPool;

public class ThrottleDataPublisher {
    public static ThrottleDataPublisherPool dataPublisherPool;
    private static final Logger LOG;
    private static volatile DataPublisher dataPublisher;
    private Executor executor;

    public static DataPublisher getDataPublisher() {
        return dataPublisher;
    }

    public ThrottleDataPublisher() {
        dataPublisherPool = ThrottleDataPublisherPool.getInstance();
        PublisherConfiguration publisherConfiguration = PublisherConfiguration.getInstance();
        try {
            this.executor = new DataPublisherThreadPoolExecutor(publisherConfiguration.getPublisherThreadPoolCoreSize(), publisherConfiguration.getPublisherThreadPoolMaximumSize(), publisherConfiguration.getPublisherThreadPoolKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(){});
            dataPublisher = new DataPublisher(publisherConfiguration.getReceiverUrlGroup(), publisherConfiguration.getAuthUrlGroup(), publisherConfiguration.getUserName(), publisherConfiguration.getPassword());
        }
        catch (TransportException | DataEndpointAuthenticationException | DataEndpointConfigurationException | DataEndpointException e) {
            LOG.error("Error in initializing binary data-publisher to send requests to global throttling engine " + e.getMessage(), (Throwable)e);
        }
    }

    public void publishNonThrottledEvent(Map<String, String> throttleEvent) {
        try {
            if (dataPublisherPool != null) {
                String apiContext;
                String messageId;
                DataProcessAndPublishingAgent agent = dataPublisherPool.get();
                agent.setDataReference(throttleEvent);
                if (LOG.isDebugEnabled()) {
                    messageId = throttleEvent.getOrDefault("messageID", "null");
                    apiContext = throttleEvent.getOrDefault("apiContext", "null");
                    LOG.debug("Publishing throttle data from gateway to traffic-manager for: " + apiContext + " with ID: " + messageId + " started at " + new SimpleDateFormat("[yyyy.MM.dd HH:mm:ss,SSS zzz]").format(new Date()));
                }
                this.executor.execute(agent);
                if (LOG.isDebugEnabled()) {
                    messageId = throttleEvent.getOrDefault("messageID", "null");
                    apiContext = throttleEvent.getOrDefault("apiContext", "null");
                    LOG.debug("Publishing throttle data from gateway to traffic-manager for: " + apiContext + " with ID: " + messageId + " ended at " + new SimpleDateFormat("[yyyy.MM.dd HH:mm:ss,SSS zzz]").format(new Date()));
                }
            } else {
                LOG.debug("Throttle data publisher pool is not initialized.");
            }
        }
        catch (Exception e) {
            LOG.error("Error while publishing throttling events to global policy server", (Throwable)e);
        }
    }

    static {
        LOG = LogManager.getLogger(ThrottleDataPublisher.class);
        dataPublisher = null;
    }

    private class DataPublisherThreadPoolExecutor
    extends ThreadPoolExecutor {
        public DataPublisherThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, LinkedBlockingDeque<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            try {
                DataProcessAndPublishingAgent agent = (DataProcessAndPublishingAgent)r;
                dataPublisherPool.release(agent);
            }
            catch (Exception e) {
                LOG.error("Error while returning Throttle data publishing agent back to pool" + e.getMessage());
            }
        }
    }
}

